package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Basic properties of both Application and Network Target Groups.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * import software.amazon.awscdk.services.elasticloadbalancingv2.*;
 * import software.amazon.awscdk.core.*;
 * Vpc vpc;
 * BaseTargetGroupProps baseTargetGroupProps = BaseTargetGroupProps.builder()
 *         .deregistrationDelay(Duration.minutes(30))
 *         .healthCheck(HealthCheck.builder()
 *                 .enabled(false)
 *                 .healthyGrpcCodes("healthyGrpcCodes")
 *                 .healthyHttpCodes("healthyHttpCodes")
 *                 .healthyThresholdCount(123)
 *                 .interval(Duration.minutes(30))
 *                 .path("path")
 *                 .port("port")
 *                 .protocol(Protocol.HTTP)
 *                 .timeout(Duration.minutes(30))
 *                 .unhealthyThresholdCount(123)
 *                 .build())
 *         .targetGroupName("targetGroupName")
 *         .targetType(TargetType.INSTANCE)
 *         .vpc(vpc)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-28T18:14:42.285Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancingv2.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancingv2.BaseTargetGroupProps")
@software.amazon.jsii.Jsii.Proxy(BaseTargetGroupProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface BaseTargetGroupProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The amount of time for Elastic Load Balancing to wait before deregistering a target.
     * <p>
     * The range is 0-3600 seconds.
     * <p>
     * Default: 300
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Duration getDeregistrationDelay() {
        return null;
    }

    /**
     * Health check configuration.
     * <p>
     * Default: - The default value for each property in this configuration varies depending on the target.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-targetgroup.html#aws-resource-elasticloadbalancingv2-targetgroup-properties">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-targetgroup.html#aws-resource-elasticloadbalancingv2-targetgroup-properties</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck getHealthCheck() {
        return null;
    }

    /**
     * The name of the target group.
     * <p>
     * This name must be unique per region per account, can have a maximum of
     * 32 characters, must contain only alphanumeric characters or hyphens, and
     * must not begin or end with a hyphen.
     * <p>
     * Default: - Automatically generated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTargetGroupName() {
        return null;
    }

    /**
     * The type of targets registered to this TargetGroup, either IP or Instance.
     * <p>
     * All targets registered into the group must be of this type. If you
     * register targets to the TargetGroup in the CDK app, the TargetType is
     * determined automatically.
     * <p>
     * Default: - Determined automatically.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticloadbalancingv2.TargetType getTargetType() {
        return null;
    }

    /**
     * The virtual private cloud (VPC).
     * <p>
     * only if <code>TargetType</code> is <code>Ip</code> or <code>InstanceId</code>
     * <p>
     * Default: - undefined
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.IVpc getVpc() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link BaseTargetGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BaseTargetGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<BaseTargetGroupProps> {
        software.amazon.awscdk.core.Duration deregistrationDelay;
        software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck healthCheck;
        java.lang.String targetGroupName;
        software.amazon.awscdk.services.elasticloadbalancingv2.TargetType targetType;
        software.amazon.awscdk.services.ec2.IVpc vpc;

        /**
         * Sets the value of {@link BaseTargetGroupProps#getDeregistrationDelay}
         * @param deregistrationDelay The amount of time for Elastic Load Balancing to wait before deregistering a target.
         *                            The range is 0-3600 seconds.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deregistrationDelay(software.amazon.awscdk.core.Duration deregistrationDelay) {
            this.deregistrationDelay = deregistrationDelay;
            return this;
        }

        /**
         * Sets the value of {@link BaseTargetGroupProps#getHealthCheck}
         * @param healthCheck Health check configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthCheck(software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck healthCheck) {
            this.healthCheck = healthCheck;
            return this;
        }

        /**
         * Sets the value of {@link BaseTargetGroupProps#getTargetGroupName}
         * @param targetGroupName The name of the target group.
         *                        This name must be unique per region per account, can have a maximum of
         *                        32 characters, must contain only alphanumeric characters or hyphens, and
         *                        must not begin or end with a hyphen.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetGroupName(java.lang.String targetGroupName) {
            this.targetGroupName = targetGroupName;
            return this;
        }

        /**
         * Sets the value of {@link BaseTargetGroupProps#getTargetType}
         * @param targetType The type of targets registered to this TargetGroup, either IP or Instance.
         *                   All targets registered into the group must be of this type. If you
         *                   register targets to the TargetGroup in the CDK app, the TargetType is
         *                   determined automatically.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetType(software.amazon.awscdk.services.elasticloadbalancingv2.TargetType targetType) {
            this.targetType = targetType;
            return this;
        }

        /**
         * Sets the value of {@link BaseTargetGroupProps#getVpc}
         * @param vpc The virtual private cloud (VPC).
         *            only if <code>TargetType</code> is <code>Ip</code> or <code>InstanceId</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BaseTargetGroupProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public BaseTargetGroupProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link BaseTargetGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BaseTargetGroupProps {
        private final software.amazon.awscdk.core.Duration deregistrationDelay;
        private final software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck healthCheck;
        private final java.lang.String targetGroupName;
        private final software.amazon.awscdk.services.elasticloadbalancingv2.TargetType targetType;
        private final software.amazon.awscdk.services.ec2.IVpc vpc;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.deregistrationDelay = software.amazon.jsii.Kernel.get(this, "deregistrationDelay", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Duration.class));
            this.healthCheck = software.amazon.jsii.Kernel.get(this, "healthCheck", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck.class));
            this.targetGroupName = software.amazon.jsii.Kernel.get(this, "targetGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.targetType = software.amazon.jsii.Kernel.get(this, "targetType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.TargetType.class));
            this.vpc = software.amazon.jsii.Kernel.get(this, "vpc", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IVpc.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.deregistrationDelay = builder.deregistrationDelay;
            this.healthCheck = builder.healthCheck;
            this.targetGroupName = builder.targetGroupName;
            this.targetType = builder.targetType;
            this.vpc = builder.vpc;
        }

        @Override
        public final software.amazon.awscdk.core.Duration getDeregistrationDelay() {
            return this.deregistrationDelay;
        }

        @Override
        public final software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck getHealthCheck() {
            return this.healthCheck;
        }

        @Override
        public final java.lang.String getTargetGroupName() {
            return this.targetGroupName;
        }

        @Override
        public final software.amazon.awscdk.services.elasticloadbalancingv2.TargetType getTargetType() {
            return this.targetType;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IVpc getVpc() {
            return this.vpc;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getDeregistrationDelay() != null) {
                data.set("deregistrationDelay", om.valueToTree(this.getDeregistrationDelay()));
            }
            if (this.getHealthCheck() != null) {
                data.set("healthCheck", om.valueToTree(this.getHealthCheck()));
            }
            if (this.getTargetGroupName() != null) {
                data.set("targetGroupName", om.valueToTree(this.getTargetGroupName()));
            }
            if (this.getTargetType() != null) {
                data.set("targetType", om.valueToTree(this.getTargetType()));
            }
            if (this.getVpc() != null) {
                data.set("vpc", om.valueToTree(this.getVpc()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-elasticloadbalancingv2.BaseTargetGroupProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BaseTargetGroupProps.Jsii$Proxy that = (BaseTargetGroupProps.Jsii$Proxy) o;

            if (this.deregistrationDelay != null ? !this.deregistrationDelay.equals(that.deregistrationDelay) : that.deregistrationDelay != null) return false;
            if (this.healthCheck != null ? !this.healthCheck.equals(that.healthCheck) : that.healthCheck != null) return false;
            if (this.targetGroupName != null ? !this.targetGroupName.equals(that.targetGroupName) : that.targetGroupName != null) return false;
            if (this.targetType != null ? !this.targetType.equals(that.targetType) : that.targetType != null) return false;
            return this.vpc != null ? this.vpc.equals(that.vpc) : that.vpc == null;
        }

        @Override
        public final int hashCode() {
            int result = this.deregistrationDelay != null ? this.deregistrationDelay.hashCode() : 0;
            result = 31 * result + (this.healthCheck != null ? this.healthCheck.hashCode() : 0);
            result = 31 * result + (this.targetGroupName != null ? this.targetGroupName.hashCode() : 0);
            result = 31 * result + (this.targetType != null ? this.targetType.hashCode() : 0);
            result = 31 * result + (this.vpc != null ? this.vpc.hashCode() : 0);
            return result;
        }
    }
}
