/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.efs;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TagManager;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.efs.;
import software.amazon.awscdk.services.efs.CfnFileSystem;
import software.amazon.awscdk.services.efs.CfnFileSystemProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-efs.CfnFileSystem")
public class CfnFileSystem
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnFileSystem.class, (String)"CFN_RESOURCE_TYPE_NAME", String.class);

    protected CfnFileSystem(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnFileSystem(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnFileSystem(@NotNull Construct scope, @NotNull String id, @Nullable CfnFileSystemProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public CfnFileSystem(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    public void inspect(@NotNull TreeInspector inspector) {
        this.jsiiCall("inspect", NativeType.VOID, new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)this.jsiiCall("renderProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrArn() {
        return (String)this.jsiiGet("attrArn", String.class);
    }

    @NotNull
    public String getAttrFileSystemId() {
        return (String)this.jsiiGet("attrFileSystemId", String.class);
    }

    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)this.jsiiGet("cfnProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)this.jsiiGet("tags", TagManager.class);
    }

    @NotNull
    public Object getFileSystemPolicy() {
        return this.jsiiGet("fileSystemPolicy", Object.class);
    }

    public void setFileSystemPolicy(@NotNull Object value) {
        this.jsiiSet("fileSystemPolicy", Objects.requireNonNull(value, "fileSystemPolicy is required"));
    }

    @Nullable
    public Object getBackupPolicy() {
        return this.jsiiGet("backupPolicy", Object.class);
    }

    public void setBackupPolicy(@Nullable BackupPolicyProperty value) {
        this.jsiiSet("backupPolicy", value);
    }

    public void setBackupPolicy(@Nullable IResolvable value) {
        this.jsiiSet("backupPolicy", value);
    }

    @Nullable
    public Object getEncrypted() {
        return this.jsiiGet("encrypted", Object.class);
    }

    public void setEncrypted(@Nullable Boolean value) {
        this.jsiiSet("encrypted", value);
    }

    public void setEncrypted(@Nullable IResolvable value) {
        this.jsiiSet("encrypted", value);
    }

    @Nullable
    public String getKmsKeyId() {
        return (String)this.jsiiGet("kmsKeyId", String.class);
    }

    public void setKmsKeyId(@Nullable String value) {
        this.jsiiSet("kmsKeyId", value);
    }

    @Nullable
    public Object getLifecyclePolicies() {
        return this.jsiiGet("lifecyclePolicies", Object.class);
    }

    public void setLifecyclePolicies(@Nullable IResolvable value) {
        this.jsiiSet("lifecyclePolicies", value);
    }

    public void setLifecyclePolicies(@Nullable List<Object> value) {
        this.jsiiSet("lifecyclePolicies", value);
    }

    @Nullable
    public String getPerformanceMode() {
        return (String)this.jsiiGet("performanceMode", String.class);
    }

    public void setPerformanceMode(@Nullable String value) {
        this.jsiiSet("performanceMode", value);
    }

    @Nullable
    public Number getProvisionedThroughputInMibps() {
        return (Number)this.jsiiGet("provisionedThroughputInMibps", Number.class);
    }

    public void setProvisionedThroughputInMibps(@Nullable Number value) {
        this.jsiiSet("provisionedThroughputInMibps", value);
    }

    @Nullable
    public String getThroughputMode() {
        return (String)this.jsiiGet("throughputMode", String.class);
    }

    public void setThroughputMode(@Nullable String value) {
        this.jsiiSet("throughputMode", value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnFileSystem> {
        private final Construct scope;
        private final String id;
        private CfnFileSystemProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder backupPolicy(BackupPolicyProperty backupPolicy) {
            this.props().backupPolicy(backupPolicy);
            return this;
        }

        public Builder backupPolicy(IResolvable backupPolicy) {
            this.props().backupPolicy(backupPolicy);
            return this;
        }

        public Builder encrypted(Boolean encrypted) {
            this.props().encrypted(encrypted);
            return this;
        }

        public Builder encrypted(IResolvable encrypted) {
            this.props().encrypted(encrypted);
            return this;
        }

        public Builder fileSystemPolicy(Object fileSystemPolicy) {
            this.props().fileSystemPolicy(fileSystemPolicy);
            return this;
        }

        public Builder fileSystemTags(List<ElasticFileSystemTagProperty> fileSystemTags) {
            this.props().fileSystemTags(fileSystemTags);
            return this;
        }

        public Builder kmsKeyId(String kmsKeyId) {
            this.props().kmsKeyId(kmsKeyId);
            return this;
        }

        public Builder lifecyclePolicies(IResolvable lifecyclePolicies) {
            this.props().lifecyclePolicies(lifecyclePolicies);
            return this;
        }

        public Builder lifecyclePolicies(List<Object> lifecyclePolicies) {
            this.props().lifecyclePolicies(lifecyclePolicies);
            return this;
        }

        public Builder performanceMode(String performanceMode) {
            this.props().performanceMode(performanceMode);
            return this;
        }

        public Builder provisionedThroughputInMibps(Number provisionedThroughputInMibps) {
            this.props().provisionedThroughputInMibps(provisionedThroughputInMibps);
            return this;
        }

        public Builder throughputMode(String throughputMode) {
            this.props().throughputMode(throughputMode);
            return this;
        }

        public CfnFileSystem build() {
            return new CfnFileSystem(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private CfnFileSystemProps.Builder props() {
            if (this.props == null) {
                this.props = new CfnFileSystemProps.Builder();
            }
            return this.props;
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-efs.CfnFileSystem.LifecyclePolicyProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LifecyclePolicyProperty
    extends JsiiSerializable {
        @NotNull
        public String getTransitionToIa();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LifecyclePolicyProperty> {
            private String transitionToIa;

            public Builder transitionToIa(String transitionToIa) {
                this.transitionToIa = transitionToIa;
                return this;
            }

            public LifecyclePolicyProperty build() {
                return new Jsii.Proxy(this.transitionToIa, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-efs.CfnFileSystem.ElasticFileSystemTagProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ElasticFileSystemTagProperty
    extends JsiiSerializable {
        @NotNull
        public String getKey();

        @NotNull
        public String getValue();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ElasticFileSystemTagProperty> {
            private String key;
            private String value;

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public ElasticFileSystemTagProperty build() {
                return new Jsii.Proxy(this.key, this.value, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-efs.CfnFileSystem.BackupPolicyProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface BackupPolicyProperty
    extends JsiiSerializable {
        @NotNull
        public String getStatus();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<BackupPolicyProperty> {
            private String status;

            public Builder status(String status) {
                this.status = status;
                return this;
            }

            public BackupPolicyProperty build() {
                return new Jsii.Proxy(this.status, null);
            }
        }
    }
}

