/**
 * <h2>Amazon Elastic File System Construct Library</h2>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * <img alt="cfn-resources: Stable" src="https://img.shields.io/badge/cfn--resources-stable-success.svg?style=for-the-badge">
 * <p>
 * <blockquote>
 * <p>
 * All classes with the <code>Cfn</code> prefix in this module (<a href="https://docs.aws.amazon.com/cdk/latest/guide/constructs.html#constructs_lib">CFN Resources</a>) are always stable and safe to use.
 * <p>
 * </blockquote>
 * <p>
 * <img alt="cdk-constructs: Experimental" src="https://img.shields.io/badge/cdk--constructs-experimental-important.svg?style=for-the-badge">
 * <p>
 * <blockquote>
 * <p>
 * The APIs of higher level constructs in this module are experimental and under active development. They are subject to non-backward compatible changes or removal in any future version. These are not subject to the <a href="https://semver.org/">Semantic Versioning</a> model and breaking changes will be announced in the release notes. This means that while you may use them, you may need to update your source code when upgrading to a newer version of this package.
 * <p>
 * </blockquote>
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * This construct library allows you to set up AWS Elastic File System (EFS).
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * import software.amazon.awscdk.services.efs.*;
 * 
 * var myVpc = new Vpc(this, "VPC");
 * FileSystem fileSystem = new FileSystem(this, "MyEfsFileSystem", new FileSystemProps()
 *         .vpc(myVpc)
 *         .encrypted(true)
 *         .lifecyclePolicy(efs.LifecyclePolicy.getAFTER_14_DAYS())
 *         .performanceMode(efs.PerformanceMode.getGENERAL_PURPOSE())
 *         .throughputMode(efs.ThroughputMode.getBURSTING()));
 * </pre></blockquote>
 * <p>
 * A file system can set <code>RemovalPolicy</code>. Default policy is <code>RETAIN</code>.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var fileSystem = FileSystem.Builder.create(this, "EfsFileSystem")
 *         .vpc(vpc)
 *         .removalPolicy(RemovalPolicy.getDESTROY())
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h3>Access Point</h3>
 * <p>
 * An access point is an application-specific view into an EFS file system that applies an operating system user and
 * group, and a file system path, to any file system request made through the access point. The operating system user
 * and group override any identity information provided by the NFS client. The file system path is exposed as the
 * access point's root directory. Applications using the access point can only access data in its own directory and
 * below. To learn more, see <a href="https://docs.aws.amazon.com/efs/latest/ug/efs-access-points.html">Mounting a File System Using EFS Access Points</a>.
 * <p>
 * Use <code>addAccessPoint</code> to create an access point from a fileSystem:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * fileSystem.addAccessPoint("AccessPoint");
 * </pre></blockquote>
 * <p>
 * By default, when you create an access point, the root(<code>/</code>) directory is exposed to the client connecting to
 * the access point. You may specify custom path with the <code>path</code> property. If <code>path</code> does not exist, it will be
 * created with the settings defined in the <code>creationInfo</code>. See
 * <a href="https://docs.aws.amazon.com/efs/latest/ug/create-access-point.html">Creating Access Points</a> for more details.
 * <p>
 * <h3>Connecting</h3>
 * <p>
 * To control who can access the EFS, use the <code>.connections</code> attribute. EFS has
 * a fixed default port, so you don't need to specify the port:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * fileSystem.connections.allowDefaultPortFrom(instance);
 * </pre></blockquote>
 * <p>
 * <h3>Mounting the file system using User Data</h3>
 * <p>
 * In order to automatically mount this file system during instance launch,
 * following code can be used as reference:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var vpc = new Vpc(this, "VPC");
 * 
 * var fileSystem = FileSystem.Builder.create(this, "MyEfsFileSystem")
 *         .vpc(vpc)
 *         .encrypted(true)
 *         .lifecyclePolicy(efs.LifecyclePolicy.getAFTER_14_DAYS())
 *         .performanceMode(efs.PerformanceMode.getGENERAL_PURPOSE())
 *         .throughputMode(efs.ThroughputMode.getBURSTING())
 *         .build();
 * 
 * var inst = Instance.Builder.create(this, "inst")
 *         .instanceType(InstanceType.of(InstanceClass.getT2(), InstanceSize.getLARGE()))
 *         .machineImage(AmazonLinuxImage.Builder.create()
 *                 .generation(AmazonLinuxGeneration.getAMAZON_LINUX_2())
 *                 .build())
 *         .vpc(vpc)
 *         .vpcSubnets(Map.of(
 *                 "subnetType", SubnetType.getPUBLIC()))
 *         .build();
 * 
 * fileSystem.connections.allowDefaultPortFrom(inst);
 * 
 * inst.userData.addCommands("yum check-update -y", "yum upgrade -y", "yum install -y amazon-efs-utils", "yum install -y nfs-utils", "file_system_id_1=" + fileSystem.getFileSystemId(), "efs_mount_point_1=/mnt/efs/fs1", "mkdir -p \"${efs_mount_point_1}\"", "test -f \"/sbin/mount.efs\" &amp;&amp; echo \"${file_system_id_1}:/ ${efs_mount_point_1} efs defaults,_netdev\" &gt;&gt; /etc/fstab || " + "echo \"${file_system_id_1}.efs." + cdk.Stack.of(this).getRegion() + ".amazonaws.com:/ ${efs_mount_point_1} nfs4 nfsvers=4.1,rsize=1048576,wsize=1048576,hard,timeo=600,retrans=2,noresvport,_netdev 0 0\" &gt;&gt; /etc/fstab", "mount -a -t efs,nfs4 defaults");
 * </pre></blockquote>
 * <p>
 * This module is part of the <a href="https://github.com/aws/aws-cdk">AWS Cloud Development Kit</a> project.
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
package software.amazon.awscdk.services.efs;
