package software.amazon.awscdk.services.efs;

/**
 * Properties of EFS FileSystem.
 * <p>
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:15.232Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.efs.$Module.class, fqn = "@aws-cdk/aws-efs.FileSystemProps")
@software.amazon.jsii.Jsii.Proxy(FileSystemProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface FileSystemProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * VPC to launch the file system in.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IVpc getVpc();

    /**
     * Defines if the data at rest in the file system is encrypted or not.
     * <p>
     * Default: - false
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEncrypted() {
        return null;
    }

    /**
     * The filesystem's name.
     * <p>
     * Default: - CDK generated name
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getFileSystemName() {
        return null;
    }

    /**
     * The KMS key used for encryption.
     * <p>
     * This is required to encrypt the data at rest if &#64;encrypted is set to true.
     * <p>
     * Default: - if
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getKmsKey() {
        return null;
    }

    /**
     * A policy used by EFS lifecycle management to transition files to the Infrequent Access (IA) storage class.
     * <p>
     * Default: - none
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.efs.LifecyclePolicy getLifecyclePolicy() {
        return null;
    }

    /**
     * Enum to mention the performance mode of the file system.
     * <p>
     * Default: - GENERAL_PURPOSE
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.efs.PerformanceMode getPerformanceMode() {
        return null;
    }

    /**
     * Provisioned throughput for the file system.
     * <p>
     * This is a required property if the throughput mode is set to PROVISIONED.
     * Must be at least 1MiB/s.
     * <p>
     * Default: - none, errors out
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Size getProvisionedThroughputPerSecond() {
        return null;
    }

    /**
     * The removal policy to apply to the file system.
     * <p>
     * Default: RemovalPolicy.RETAIN
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.RemovalPolicy getRemovalPolicy() {
        return null;
    }

    /**
     * Security Group to assign to this file system.
     * <p>
     * Default: - creates new security group which allow all out bound traffic
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.ISecurityGroup getSecurityGroup() {
        return null;
    }

    /**
     * Enum to mention the throughput mode of the file system.
     * <p>
     * Default: - BURSTING
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.efs.ThroughputMode getThroughputMode() {
        return null;
    }

    /**
     * Which subnets to place the mount target in the VPC.
     * <p>
     * Default: - the Vpc default strategy if not specified
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.SubnetSelection getVpcSubnets() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link FileSystemProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link FileSystemProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<FileSystemProps> {
        private software.amazon.awscdk.services.ec2.IVpc vpc;
        private java.lang.Boolean encrypted;
        private java.lang.String fileSystemName;
        private software.amazon.awscdk.services.kms.IKey kmsKey;
        private software.amazon.awscdk.services.efs.LifecyclePolicy lifecyclePolicy;
        private software.amazon.awscdk.services.efs.PerformanceMode performanceMode;
        private software.amazon.awscdk.core.Size provisionedThroughputPerSecond;
        private software.amazon.awscdk.core.RemovalPolicy removalPolicy;
        private software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup;
        private software.amazon.awscdk.services.efs.ThroughputMode throughputMode;
        private software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets;

        /**
         * Sets the value of {@link FileSystemProps#getVpc}
         * @param vpc VPC to launch the file system in. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder vpc(software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        /**
         * Sets the value of {@link FileSystemProps#getEncrypted}
         * @param encrypted Defines if the data at rest in the file system is encrypted or not.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder encrypted(java.lang.Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        /**
         * Sets the value of {@link FileSystemProps#getFileSystemName}
         * @param fileSystemName The filesystem's name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder fileSystemName(java.lang.String fileSystemName) {
            this.fileSystemName = fileSystemName;
            return this;
        }

        /**
         * Sets the value of {@link FileSystemProps#getKmsKey}
         * @param kmsKey The KMS key used for encryption.
         *               This is required to encrypt the data at rest if &#64;encrypted is set to true.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder kmsKey(software.amazon.awscdk.services.kms.IKey kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        /**
         * Sets the value of {@link FileSystemProps#getLifecyclePolicy}
         * @param lifecyclePolicy A policy used by EFS lifecycle management to transition files to the Infrequent Access (IA) storage class.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder lifecyclePolicy(software.amazon.awscdk.services.efs.LifecyclePolicy lifecyclePolicy) {
            this.lifecyclePolicy = lifecyclePolicy;
            return this;
        }

        /**
         * Sets the value of {@link FileSystemProps#getPerformanceMode}
         * @param performanceMode Enum to mention the performance mode of the file system.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder performanceMode(software.amazon.awscdk.services.efs.PerformanceMode performanceMode) {
            this.performanceMode = performanceMode;
            return this;
        }

        /**
         * Sets the value of {@link FileSystemProps#getProvisionedThroughputPerSecond}
         * @param provisionedThroughputPerSecond Provisioned throughput for the file system.
         *                                       This is a required property if the throughput mode is set to PROVISIONED.
         *                                       Must be at least 1MiB/s.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder provisionedThroughputPerSecond(software.amazon.awscdk.core.Size provisionedThroughputPerSecond) {
            this.provisionedThroughputPerSecond = provisionedThroughputPerSecond;
            return this;
        }

        /**
         * Sets the value of {@link FileSystemProps#getRemovalPolicy}
         * @param removalPolicy The removal policy to apply to the file system.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder removalPolicy(software.amazon.awscdk.core.RemovalPolicy removalPolicy) {
            this.removalPolicy = removalPolicy;
            return this;
        }

        /**
         * Sets the value of {@link FileSystemProps#getSecurityGroup}
         * @param securityGroup Security Group to assign to this file system.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder securityGroup(software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup) {
            this.securityGroup = securityGroup;
            return this;
        }

        /**
         * Sets the value of {@link FileSystemProps#getThroughputMode}
         * @param throughputMode Enum to mention the throughput mode of the file system.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder throughputMode(software.amazon.awscdk.services.efs.ThroughputMode throughputMode) {
            this.throughputMode = throughputMode;
            return this;
        }

        /**
         * Sets the value of {@link FileSystemProps#getVpcSubnets}
         * @param vpcSubnets Which subnets to place the mount target in the VPC.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder vpcSubnets(software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets) {
            this.vpcSubnets = vpcSubnets;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link FileSystemProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public FileSystemProps build() {
            return new Jsii$Proxy(vpc, encrypted, fileSystemName, kmsKey, lifecyclePolicy, performanceMode, provisionedThroughputPerSecond, removalPolicy, securityGroup, throughputMode, vpcSubnets);
        }
    }

    /**
     * An implementation for {@link FileSystemProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FileSystemProps {
        private final software.amazon.awscdk.services.ec2.IVpc vpc;
        private final java.lang.Boolean encrypted;
        private final java.lang.String fileSystemName;
        private final software.amazon.awscdk.services.kms.IKey kmsKey;
        private final software.amazon.awscdk.services.efs.LifecyclePolicy lifecyclePolicy;
        private final software.amazon.awscdk.services.efs.PerformanceMode performanceMode;
        private final software.amazon.awscdk.core.Size provisionedThroughputPerSecond;
        private final software.amazon.awscdk.core.RemovalPolicy removalPolicy;
        private final software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup;
        private final software.amazon.awscdk.services.efs.ThroughputMode throughputMode;
        private final software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.vpc = this.jsiiGet("vpc", software.amazon.awscdk.services.ec2.IVpc.class);
            this.encrypted = this.jsiiGet("encrypted", java.lang.Boolean.class);
            this.fileSystemName = this.jsiiGet("fileSystemName", java.lang.String.class);
            this.kmsKey = this.jsiiGet("kmsKey", software.amazon.awscdk.services.kms.IKey.class);
            this.lifecyclePolicy = this.jsiiGet("lifecyclePolicy", software.amazon.awscdk.services.efs.LifecyclePolicy.class);
            this.performanceMode = this.jsiiGet("performanceMode", software.amazon.awscdk.services.efs.PerformanceMode.class);
            this.provisionedThroughputPerSecond = this.jsiiGet("provisionedThroughputPerSecond", software.amazon.awscdk.core.Size.class);
            this.removalPolicy = this.jsiiGet("removalPolicy", software.amazon.awscdk.core.RemovalPolicy.class);
            this.securityGroup = this.jsiiGet("securityGroup", software.amazon.awscdk.services.ec2.ISecurityGroup.class);
            this.throughputMode = this.jsiiGet("throughputMode", software.amazon.awscdk.services.efs.ThroughputMode.class);
            this.vpcSubnets = this.jsiiGet("vpcSubnets", software.amazon.awscdk.services.ec2.SubnetSelection.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.services.ec2.IVpc vpc, final java.lang.Boolean encrypted, final java.lang.String fileSystemName, final software.amazon.awscdk.services.kms.IKey kmsKey, final software.amazon.awscdk.services.efs.LifecyclePolicy lifecyclePolicy, final software.amazon.awscdk.services.efs.PerformanceMode performanceMode, final software.amazon.awscdk.core.Size provisionedThroughputPerSecond, final software.amazon.awscdk.core.RemovalPolicy removalPolicy, final software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup, final software.amazon.awscdk.services.efs.ThroughputMode throughputMode, final software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.vpc = java.util.Objects.requireNonNull(vpc, "vpc is required");
            this.encrypted = encrypted;
            this.fileSystemName = fileSystemName;
            this.kmsKey = kmsKey;
            this.lifecyclePolicy = lifecyclePolicy;
            this.performanceMode = performanceMode;
            this.provisionedThroughputPerSecond = provisionedThroughputPerSecond;
            this.removalPolicy = removalPolicy;
            this.securityGroup = securityGroup;
            this.throughputMode = throughputMode;
            this.vpcSubnets = vpcSubnets;
        }

        @Override
        public software.amazon.awscdk.services.ec2.IVpc getVpc() {
            return this.vpc;
        }

        @Override
        public java.lang.Boolean getEncrypted() {
            return this.encrypted;
        }

        @Override
        public java.lang.String getFileSystemName() {
            return this.fileSystemName;
        }

        @Override
        public software.amazon.awscdk.services.kms.IKey getKmsKey() {
            return this.kmsKey;
        }

        @Override
        public software.amazon.awscdk.services.efs.LifecyclePolicy getLifecyclePolicy() {
            return this.lifecyclePolicy;
        }

        @Override
        public software.amazon.awscdk.services.efs.PerformanceMode getPerformanceMode() {
            return this.performanceMode;
        }

        @Override
        public software.amazon.awscdk.core.Size getProvisionedThroughputPerSecond() {
            return this.provisionedThroughputPerSecond;
        }

        @Override
        public software.amazon.awscdk.core.RemovalPolicy getRemovalPolicy() {
            return this.removalPolicy;
        }

        @Override
        public software.amazon.awscdk.services.ec2.ISecurityGroup getSecurityGroup() {
            return this.securityGroup;
        }

        @Override
        public software.amazon.awscdk.services.efs.ThroughputMode getThroughputMode() {
            return this.throughputMode;
        }

        @Override
        public software.amazon.awscdk.services.ec2.SubnetSelection getVpcSubnets() {
            return this.vpcSubnets;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("vpc", om.valueToTree(this.getVpc()));
            if (this.getEncrypted() != null) {
                data.set("encrypted", om.valueToTree(this.getEncrypted()));
            }
            if (this.getFileSystemName() != null) {
                data.set("fileSystemName", om.valueToTree(this.getFileSystemName()));
            }
            if (this.getKmsKey() != null) {
                data.set("kmsKey", om.valueToTree(this.getKmsKey()));
            }
            if (this.getLifecyclePolicy() != null) {
                data.set("lifecyclePolicy", om.valueToTree(this.getLifecyclePolicy()));
            }
            if (this.getPerformanceMode() != null) {
                data.set("performanceMode", om.valueToTree(this.getPerformanceMode()));
            }
            if (this.getProvisionedThroughputPerSecond() != null) {
                data.set("provisionedThroughputPerSecond", om.valueToTree(this.getProvisionedThroughputPerSecond()));
            }
            if (this.getRemovalPolicy() != null) {
                data.set("removalPolicy", om.valueToTree(this.getRemovalPolicy()));
            }
            if (this.getSecurityGroup() != null) {
                data.set("securityGroup", om.valueToTree(this.getSecurityGroup()));
            }
            if (this.getThroughputMode() != null) {
                data.set("throughputMode", om.valueToTree(this.getThroughputMode()));
            }
            if (this.getVpcSubnets() != null) {
                data.set("vpcSubnets", om.valueToTree(this.getVpcSubnets()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-efs.FileSystemProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            FileSystemProps.Jsii$Proxy that = (FileSystemProps.Jsii$Proxy) o;

            if (!vpc.equals(that.vpc)) return false;
            if (this.encrypted != null ? !this.encrypted.equals(that.encrypted) : that.encrypted != null) return false;
            if (this.fileSystemName != null ? !this.fileSystemName.equals(that.fileSystemName) : that.fileSystemName != null) return false;
            if (this.kmsKey != null ? !this.kmsKey.equals(that.kmsKey) : that.kmsKey != null) return false;
            if (this.lifecyclePolicy != null ? !this.lifecyclePolicy.equals(that.lifecyclePolicy) : that.lifecyclePolicy != null) return false;
            if (this.performanceMode != null ? !this.performanceMode.equals(that.performanceMode) : that.performanceMode != null) return false;
            if (this.provisionedThroughputPerSecond != null ? !this.provisionedThroughputPerSecond.equals(that.provisionedThroughputPerSecond) : that.provisionedThroughputPerSecond != null) return false;
            if (this.removalPolicy != null ? !this.removalPolicy.equals(that.removalPolicy) : that.removalPolicy != null) return false;
            if (this.securityGroup != null ? !this.securityGroup.equals(that.securityGroup) : that.securityGroup != null) return false;
            if (this.throughputMode != null ? !this.throughputMode.equals(that.throughputMode) : that.throughputMode != null) return false;
            return this.vpcSubnets != null ? this.vpcSubnets.equals(that.vpcSubnets) : that.vpcSubnets == null;
        }

        @Override
        public int hashCode() {
            int result = this.vpc.hashCode();
            result = 31 * result + (this.encrypted != null ? this.encrypted.hashCode() : 0);
            result = 31 * result + (this.fileSystemName != null ? this.fileSystemName.hashCode() : 0);
            result = 31 * result + (this.kmsKey != null ? this.kmsKey.hashCode() : 0);
            result = 31 * result + (this.lifecyclePolicy != null ? this.lifecyclePolicy.hashCode() : 0);
            result = 31 * result + (this.performanceMode != null ? this.performanceMode.hashCode() : 0);
            result = 31 * result + (this.provisionedThroughputPerSecond != null ? this.provisionedThroughputPerSecond.hashCode() : 0);
            result = 31 * result + (this.removalPolicy != null ? this.removalPolicy.hashCode() : 0);
            result = 31 * result + (this.securityGroup != null ? this.securityGroup.hashCode() : 0);
            result = 31 * result + (this.throughputMode != null ? this.throughputMode.hashCode() : 0);
            result = 31 * result + (this.vpcSubnets != null ? this.vpcSubnets.hashCode() : 0);
            return result;
        }
    }
}
