package software.amazon.awscdk.services.efs;

/**
 * The Elastic File System implementation of IFileSystem.
 * <p>
 * It creates a new, empty file system in Amazon Elastic File System (Amazon EFS).
 * It also creates mount target (AWS::EFS::MountTarget) implicitly to mount the
 * EFS file system on an Amazon Elastic Compute Cloud (Amazon EC2) instance or another resource.
 * <p>
 * EXPERIMENTAL
 * <p>
 * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:15.231Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.efs.$Module.class, fqn = "@aws-cdk/aws-efs.FileSystem")
public class FileSystem extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.efs.IFileSystem {

    protected FileSystem(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected FileSystem(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Constructor for creating a new EFS FileSystem.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public FileSystem(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.efs.FileSystemProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Import an existing File System from the given properties.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param attrs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.efs.IFileSystem fromFileSystemAttributes(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.efs.FileSystemAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.efs.FileSystem.class, "fromFileSystemAttributes", software.amazon.awscdk.services.efs.IFileSystem.class, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * create access point from this filesystem.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @param id This parameter is required.
     * @param accessPointOptions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.efs.AccessPoint addAccessPoint(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.efs.AccessPointOptions accessPointOptions) {
        return this.jsiiCall("addAccessPoint", software.amazon.awscdk.services.efs.AccessPoint.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), accessPointOptions });
    }

    /**
     * create access point from this filesystem.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.efs.AccessPoint addAccessPoint(final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return this.jsiiCall("addAccessPoint", software.amazon.awscdk.services.efs.AccessPoint.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * The security groups/rules used to allow network connections to the file system.
     * <p>
     * EXPERIMENTAL
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Connections getConnections() {
        return this.jsiiGet("connections", software.amazon.awscdk.services.ec2.Connections.class);
    }

    /**
     * The ID of the file system, assigned by Amazon EFS.
     * <p>
     * EXPERIMENTAL
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getFileSystemId() {
        return this.jsiiGet("fileSystemId", java.lang.String.class);
    }

    /**
     * Dependable that can be depended upon to ensure the mount targets of the filesystem are ready.
     * <p>
     * EXPERIMENTAL
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IDependable getMountTargetsAvailable() {
        return this.jsiiGet("mountTargetsAvailable", software.amazon.awscdk.core.IDependable.class);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.efs.FileSystem}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.efs.FileSystem> {
        /**
         * EXPERIMENTAL
         * <p>
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.efs.FileSystemProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.efs.FileSystemProps.Builder();
        }

        /**
         * VPC to launch the file system in.
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param vpc VPC to launch the file system in. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder vpc(final software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        /**
         * Defines if the data at rest in the file system is encrypted or not.
         * <p>
         * Default: - false
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param encrypted Defines if the data at rest in the file system is encrypted or not. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder encrypted(final java.lang.Boolean encrypted) {
            this.props.encrypted(encrypted);
            return this;
        }

        /**
         * The filesystem's name.
         * <p>
         * Default: - CDK generated name
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param fileSystemName The filesystem's name. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder fileSystemName(final java.lang.String fileSystemName) {
            this.props.fileSystemName(fileSystemName);
            return this;
        }

        /**
         * The KMS key used for encryption.
         * <p>
         * This is required to encrypt the data at rest if &#64;encrypted is set to true.
         * <p>
         * Default: - if
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param kmsKey The KMS key used for encryption. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder kmsKey(final software.amazon.awscdk.services.kms.IKey kmsKey) {
            this.props.kmsKey(kmsKey);
            return this;
        }

        /**
         * A policy used by EFS lifecycle management to transition files to the Infrequent Access (IA) storage class.
         * <p>
         * Default: - none
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param lifecyclePolicy A policy used by EFS lifecycle management to transition files to the Infrequent Access (IA) storage class. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder lifecyclePolicy(final software.amazon.awscdk.services.efs.LifecyclePolicy lifecyclePolicy) {
            this.props.lifecyclePolicy(lifecyclePolicy);
            return this;
        }

        /**
         * Enum to mention the performance mode of the file system.
         * <p>
         * Default: - GENERAL_PURPOSE
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param performanceMode Enum to mention the performance mode of the file system. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder performanceMode(final software.amazon.awscdk.services.efs.PerformanceMode performanceMode) {
            this.props.performanceMode(performanceMode);
            return this;
        }

        /**
         * Provisioned throughput for the file system.
         * <p>
         * This is a required property if the throughput mode is set to PROVISIONED.
         * Must be at least 1MiB/s.
         * <p>
         * Default: - none, errors out
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param provisionedThroughputPerSecond Provisioned throughput for the file system. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder provisionedThroughputPerSecond(final software.amazon.awscdk.core.Size provisionedThroughputPerSecond) {
            this.props.provisionedThroughputPerSecond(provisionedThroughputPerSecond);
            return this;
        }

        /**
         * The removal policy to apply to the file system.
         * <p>
         * Default: RemovalPolicy.RETAIN
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param removalPolicy The removal policy to apply to the file system. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder removalPolicy(final software.amazon.awscdk.core.RemovalPolicy removalPolicy) {
            this.props.removalPolicy(removalPolicy);
            return this;
        }

        /**
         * Security Group to assign to this file system.
         * <p>
         * Default: - creates new security group which allow all out bound traffic
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param securityGroup Security Group to assign to this file system. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder securityGroup(final software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup) {
            this.props.securityGroup(securityGroup);
            return this;
        }

        /**
         * Enum to mention the throughput mode of the file system.
         * <p>
         * Default: - BURSTING
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param throughputMode Enum to mention the throughput mode of the file system. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder throughputMode(final software.amazon.awscdk.services.efs.ThroughputMode throughputMode) {
            this.props.throughputMode(throughputMode);
            return this;
        }

        /**
         * Which subnets to place the mount target in the VPC.
         * <p>
         * Default: - the Vpc default strategy if not specified
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param vpcSubnets Which subnets to place the mount target in the VPC. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder vpcSubnets(final software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets) {
            this.props.vpcSubnets(vpcSubnets);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.efs.FileSystem}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.efs.FileSystem build() {
            return new software.amazon.awscdk.services.efs.FileSystem(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
