package software.amazon.awscdk.services.efs;

/**
 * Properties for defining a `AWS::EFS::MountTarget`.
 * <p>
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-mounttarget.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:15.231Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.efs.$Module.class, fqn = "@aws-cdk/aws-efs.CfnMountTargetProps")
@software.amazon.jsii.Jsii.Proxy(CfnMountTargetProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnMountTargetProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::EFS::MountTarget.FileSystemId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-mounttarget.html#cfn-efs-mounttarget-filesystemid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getFileSystemId();

    /**
     * `AWS::EFS::MountTarget.SecurityGroups`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-mounttarget.html#cfn-efs-mounttarget-securitygroups
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSecurityGroups();

    /**
     * `AWS::EFS::MountTarget.SubnetId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-mounttarget.html#cfn-efs-mounttarget-subnetid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSubnetId();

    /**
     * `AWS::EFS::MountTarget.IpAddress`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-mounttarget.html#cfn-efs-mounttarget-ipaddress
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getIpAddress() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnMountTargetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnMountTargetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnMountTargetProps> {
        private java.lang.String fileSystemId;
        private java.util.List<java.lang.String> securityGroups;
        private java.lang.String subnetId;
        private java.lang.String ipAddress;

        /**
         * Sets the value of {@link CfnMountTargetProps#getFileSystemId}
         * @param fileSystemId `AWS::EFS::MountTarget.FileSystemId`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fileSystemId(java.lang.String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        /**
         * Sets the value of {@link CfnMountTargetProps#getSecurityGroups}
         * @param securityGroups `AWS::EFS::MountTarget.SecurityGroups`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroups(java.util.List<java.lang.String> securityGroups) {
            this.securityGroups = securityGroups;
            return this;
        }

        /**
         * Sets the value of {@link CfnMountTargetProps#getSubnetId}
         * @param subnetId `AWS::EFS::MountTarget.SubnetId`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetId(java.lang.String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        /**
         * Sets the value of {@link CfnMountTargetProps#getIpAddress}
         * @param ipAddress `AWS::EFS::MountTarget.IpAddress`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipAddress(java.lang.String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnMountTargetProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnMountTargetProps build() {
            return new Jsii$Proxy(fileSystemId, securityGroups, subnetId, ipAddress);
        }
    }

    /**
     * An implementation for {@link CfnMountTargetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnMountTargetProps {
        private final java.lang.String fileSystemId;
        private final java.util.List<java.lang.String> securityGroups;
        private final java.lang.String subnetId;
        private final java.lang.String ipAddress;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.fileSystemId = this.jsiiGet("fileSystemId", java.lang.String.class);
            this.securityGroups = this.jsiiGet("securityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.subnetId = this.jsiiGet("subnetId", java.lang.String.class);
            this.ipAddress = this.jsiiGet("ipAddress", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String fileSystemId, final java.util.List<java.lang.String> securityGroups, final java.lang.String subnetId, final java.lang.String ipAddress) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.fileSystemId = java.util.Objects.requireNonNull(fileSystemId, "fileSystemId is required");
            this.securityGroups = java.util.Objects.requireNonNull(securityGroups, "securityGroups is required");
            this.subnetId = java.util.Objects.requireNonNull(subnetId, "subnetId is required");
            this.ipAddress = ipAddress;
        }

        @Override
        public java.lang.String getFileSystemId() {
            return this.fileSystemId;
        }

        @Override
        public java.util.List<java.lang.String> getSecurityGroups() {
            return this.securityGroups;
        }

        @Override
        public java.lang.String getSubnetId() {
            return this.subnetId;
        }

        @Override
        public java.lang.String getIpAddress() {
            return this.ipAddress;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("fileSystemId", om.valueToTree(this.getFileSystemId()));
            data.set("securityGroups", om.valueToTree(this.getSecurityGroups()));
            data.set("subnetId", om.valueToTree(this.getSubnetId()));
            if (this.getIpAddress() != null) {
                data.set("ipAddress", om.valueToTree(this.getIpAddress()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-efs.CfnMountTargetProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnMountTargetProps.Jsii$Proxy that = (CfnMountTargetProps.Jsii$Proxy) o;

            if (!fileSystemId.equals(that.fileSystemId)) return false;
            if (!securityGroups.equals(that.securityGroups)) return false;
            if (!subnetId.equals(that.subnetId)) return false;
            return this.ipAddress != null ? this.ipAddress.equals(that.ipAddress) : that.ipAddress == null;
        }

        @Override
        public int hashCode() {
            int result = this.fileSystemId.hashCode();
            result = 31 * result + (this.securityGroups.hashCode());
            result = 31 * result + (this.subnetId.hashCode());
            result = 31 * result + (this.ipAddress != null ? this.ipAddress.hashCode() : 0);
            return result;
        }
    }
}
