package software.amazon.awscdk.services.efs;

/**
 * Properties for defining a `AWS::EFS::FileSystem`.
 * <p>
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:15.230Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.efs.$Module.class, fqn = "@aws-cdk/aws-efs.CfnFileSystemProps")
@software.amazon.jsii.Jsii.Proxy(CfnFileSystemProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnFileSystemProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::EFS::FileSystem.BackupPolicy`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-backuppolicy
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getBackupPolicy() {
        return null;
    }

    /**
     * `AWS::EFS::FileSystem.Encrypted`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-encrypted
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEncrypted() {
        return null;
    }

    /**
     * `AWS::EFS::FileSystem.FileSystemPolicy`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-filesystempolicy
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getFileSystemPolicy() {
        return null;
    }

    /**
     * `AWS::EFS::FileSystem.FileSystemTags`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-filesystemtags
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.efs.CfnFileSystem.ElasticFileSystemTagProperty> getFileSystemTags() {
        return null;
    }

    /**
     * `AWS::EFS::FileSystem.KmsKeyId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-kmskeyid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
        return null;
    }

    /**
     * `AWS::EFS::FileSystem.LifecyclePolicies`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-lifecyclepolicies
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getLifecyclePolicies() {
        return null;
    }

    /**
     * `AWS::EFS::FileSystem.PerformanceMode`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-performancemode
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPerformanceMode() {
        return null;
    }

    /**
     * `AWS::EFS::FileSystem.ProvisionedThroughputInMibps`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-provisionedthroughputinmibps
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getProvisionedThroughputInMibps() {
        return null;
    }

    /**
     * `AWS::EFS::FileSystem.ThroughputMode`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-throughputmode
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getThroughputMode() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnFileSystemProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnFileSystemProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnFileSystemProps> {
        private java.lang.Object backupPolicy;
        private java.lang.Object encrypted;
        private java.lang.Object fileSystemPolicy;
        private java.util.List<software.amazon.awscdk.services.efs.CfnFileSystem.ElasticFileSystemTagProperty> fileSystemTags;
        private java.lang.String kmsKeyId;
        private java.lang.Object lifecyclePolicies;
        private java.lang.String performanceMode;
        private java.lang.Number provisionedThroughputInMibps;
        private java.lang.String throughputMode;

        /**
         * Sets the value of {@link CfnFileSystemProps#getBackupPolicy}
         * @param backupPolicy `AWS::EFS::FileSystem.BackupPolicy`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backupPolicy(software.amazon.awscdk.services.efs.CfnFileSystem.BackupPolicyProperty backupPolicy) {
            this.backupPolicy = backupPolicy;
            return this;
        }

        /**
         * Sets the value of {@link CfnFileSystemProps#getBackupPolicy}
         * @param backupPolicy `AWS::EFS::FileSystem.BackupPolicy`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backupPolicy(software.amazon.awscdk.core.IResolvable backupPolicy) {
            this.backupPolicy = backupPolicy;
            return this;
        }

        /**
         * Sets the value of {@link CfnFileSystemProps#getEncrypted}
         * @param encrypted `AWS::EFS::FileSystem.Encrypted`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encrypted(java.lang.Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        /**
         * Sets the value of {@link CfnFileSystemProps#getEncrypted}
         * @param encrypted `AWS::EFS::FileSystem.Encrypted`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encrypted(software.amazon.awscdk.core.IResolvable encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        /**
         * Sets the value of {@link CfnFileSystemProps#getFileSystemPolicy}
         * @param fileSystemPolicy `AWS::EFS::FileSystem.FileSystemPolicy`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fileSystemPolicy(java.lang.Object fileSystemPolicy) {
            this.fileSystemPolicy = fileSystemPolicy;
            return this;
        }

        /**
         * Sets the value of {@link CfnFileSystemProps#getFileSystemTags}
         * @param fileSystemTags `AWS::EFS::FileSystem.FileSystemTags`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fileSystemTags(java.util.List<software.amazon.awscdk.services.efs.CfnFileSystem.ElasticFileSystemTagProperty> fileSystemTags) {
            this.fileSystemTags = fileSystemTags;
            return this;
        }

        /**
         * Sets the value of {@link CfnFileSystemProps#getKmsKeyId}
         * @param kmsKeyId `AWS::EFS::FileSystem.KmsKeyId`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyId(java.lang.String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        /**
         * Sets the value of {@link CfnFileSystemProps#getLifecyclePolicies}
         * @param lifecyclePolicies `AWS::EFS::FileSystem.LifecyclePolicies`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lifecyclePolicies(software.amazon.awscdk.core.IResolvable lifecyclePolicies) {
            this.lifecyclePolicies = lifecyclePolicies;
            return this;
        }

        /**
         * Sets the value of {@link CfnFileSystemProps#getLifecyclePolicies}
         * @param lifecyclePolicies `AWS::EFS::FileSystem.LifecyclePolicies`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lifecyclePolicies(java.util.List<java.lang.Object> lifecyclePolicies) {
            this.lifecyclePolicies = lifecyclePolicies;
            return this;
        }

        /**
         * Sets the value of {@link CfnFileSystemProps#getPerformanceMode}
         * @param performanceMode `AWS::EFS::FileSystem.PerformanceMode`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder performanceMode(java.lang.String performanceMode) {
            this.performanceMode = performanceMode;
            return this;
        }

        /**
         * Sets the value of {@link CfnFileSystemProps#getProvisionedThroughputInMibps}
         * @param provisionedThroughputInMibps `AWS::EFS::FileSystem.ProvisionedThroughputInMibps`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder provisionedThroughputInMibps(java.lang.Number provisionedThroughputInMibps) {
            this.provisionedThroughputInMibps = provisionedThroughputInMibps;
            return this;
        }

        /**
         * Sets the value of {@link CfnFileSystemProps#getThroughputMode}
         * @param throughputMode `AWS::EFS::FileSystem.ThroughputMode`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder throughputMode(java.lang.String throughputMode) {
            this.throughputMode = throughputMode;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnFileSystemProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnFileSystemProps build() {
            return new Jsii$Proxy(backupPolicy, encrypted, fileSystemPolicy, fileSystemTags, kmsKeyId, lifecyclePolicies, performanceMode, provisionedThroughputInMibps, throughputMode);
        }
    }

    /**
     * An implementation for {@link CfnFileSystemProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnFileSystemProps {
        private final java.lang.Object backupPolicy;
        private final java.lang.Object encrypted;
        private final java.lang.Object fileSystemPolicy;
        private final java.util.List<software.amazon.awscdk.services.efs.CfnFileSystem.ElasticFileSystemTagProperty> fileSystemTags;
        private final java.lang.String kmsKeyId;
        private final java.lang.Object lifecyclePolicies;
        private final java.lang.String performanceMode;
        private final java.lang.Number provisionedThroughputInMibps;
        private final java.lang.String throughputMode;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.backupPolicy = this.jsiiGet("backupPolicy", java.lang.Object.class);
            this.encrypted = this.jsiiGet("encrypted", java.lang.Object.class);
            this.fileSystemPolicy = this.jsiiGet("fileSystemPolicy", java.lang.Object.class);
            this.fileSystemTags = this.jsiiGet("fileSystemTags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.efs.CfnFileSystem.ElasticFileSystemTagProperty.class)));
            this.kmsKeyId = this.jsiiGet("kmsKeyId", java.lang.String.class);
            this.lifecyclePolicies = this.jsiiGet("lifecyclePolicies", java.lang.Object.class);
            this.performanceMode = this.jsiiGet("performanceMode", java.lang.String.class);
            this.provisionedThroughputInMibps = this.jsiiGet("provisionedThroughputInMibps", java.lang.Number.class);
            this.throughputMode = this.jsiiGet("throughputMode", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.Object backupPolicy, final java.lang.Object encrypted, final java.lang.Object fileSystemPolicy, final java.util.List<software.amazon.awscdk.services.efs.CfnFileSystem.ElasticFileSystemTagProperty> fileSystemTags, final java.lang.String kmsKeyId, final java.lang.Object lifecyclePolicies, final java.lang.String performanceMode, final java.lang.Number provisionedThroughputInMibps, final java.lang.String throughputMode) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.backupPolicy = backupPolicy;
            this.encrypted = encrypted;
            this.fileSystemPolicy = fileSystemPolicy;
            this.fileSystemTags = fileSystemTags;
            this.kmsKeyId = kmsKeyId;
            this.lifecyclePolicies = lifecyclePolicies;
            this.performanceMode = performanceMode;
            this.provisionedThroughputInMibps = provisionedThroughputInMibps;
            this.throughputMode = throughputMode;
        }

        @Override
        public java.lang.Object getBackupPolicy() {
            return this.backupPolicy;
        }

        @Override
        public java.lang.Object getEncrypted() {
            return this.encrypted;
        }

        @Override
        public java.lang.Object getFileSystemPolicy() {
            return this.fileSystemPolicy;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.efs.CfnFileSystem.ElasticFileSystemTagProperty> getFileSystemTags() {
            return this.fileSystemTags;
        }

        @Override
        public java.lang.String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public java.lang.Object getLifecyclePolicies() {
            return this.lifecyclePolicies;
        }

        @Override
        public java.lang.String getPerformanceMode() {
            return this.performanceMode;
        }

        @Override
        public java.lang.Number getProvisionedThroughputInMibps() {
            return this.provisionedThroughputInMibps;
        }

        @Override
        public java.lang.String getThroughputMode() {
            return this.throughputMode;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getBackupPolicy() != null) {
                data.set("backupPolicy", om.valueToTree(this.getBackupPolicy()));
            }
            if (this.getEncrypted() != null) {
                data.set("encrypted", om.valueToTree(this.getEncrypted()));
            }
            if (this.getFileSystemPolicy() != null) {
                data.set("fileSystemPolicy", om.valueToTree(this.getFileSystemPolicy()));
            }
            if (this.getFileSystemTags() != null) {
                data.set("fileSystemTags", om.valueToTree(this.getFileSystemTags()));
            }
            if (this.getKmsKeyId() != null) {
                data.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
            }
            if (this.getLifecyclePolicies() != null) {
                data.set("lifecyclePolicies", om.valueToTree(this.getLifecyclePolicies()));
            }
            if (this.getPerformanceMode() != null) {
                data.set("performanceMode", om.valueToTree(this.getPerformanceMode()));
            }
            if (this.getProvisionedThroughputInMibps() != null) {
                data.set("provisionedThroughputInMibps", om.valueToTree(this.getProvisionedThroughputInMibps()));
            }
            if (this.getThroughputMode() != null) {
                data.set("throughputMode", om.valueToTree(this.getThroughputMode()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-efs.CfnFileSystemProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnFileSystemProps.Jsii$Proxy that = (CfnFileSystemProps.Jsii$Proxy) o;

            if (this.backupPolicy != null ? !this.backupPolicy.equals(that.backupPolicy) : that.backupPolicy != null) return false;
            if (this.encrypted != null ? !this.encrypted.equals(that.encrypted) : that.encrypted != null) return false;
            if (this.fileSystemPolicy != null ? !this.fileSystemPolicy.equals(that.fileSystemPolicy) : that.fileSystemPolicy != null) return false;
            if (this.fileSystemTags != null ? !this.fileSystemTags.equals(that.fileSystemTags) : that.fileSystemTags != null) return false;
            if (this.kmsKeyId != null ? !this.kmsKeyId.equals(that.kmsKeyId) : that.kmsKeyId != null) return false;
            if (this.lifecyclePolicies != null ? !this.lifecyclePolicies.equals(that.lifecyclePolicies) : that.lifecyclePolicies != null) return false;
            if (this.performanceMode != null ? !this.performanceMode.equals(that.performanceMode) : that.performanceMode != null) return false;
            if (this.provisionedThroughputInMibps != null ? !this.provisionedThroughputInMibps.equals(that.provisionedThroughputInMibps) : that.provisionedThroughputInMibps != null) return false;
            return this.throughputMode != null ? this.throughputMode.equals(that.throughputMode) : that.throughputMode == null;
        }

        @Override
        public int hashCode() {
            int result = this.backupPolicy != null ? this.backupPolicy.hashCode() : 0;
            result = 31 * result + (this.encrypted != null ? this.encrypted.hashCode() : 0);
            result = 31 * result + (this.fileSystemPolicy != null ? this.fileSystemPolicy.hashCode() : 0);
            result = 31 * result + (this.fileSystemTags != null ? this.fileSystemTags.hashCode() : 0);
            result = 31 * result + (this.kmsKeyId != null ? this.kmsKeyId.hashCode() : 0);
            result = 31 * result + (this.lifecyclePolicies != null ? this.lifecyclePolicies.hashCode() : 0);
            result = 31 * result + (this.performanceMode != null ? this.performanceMode.hashCode() : 0);
            result = 31 * result + (this.provisionedThroughputInMibps != null ? this.provisionedThroughputInMibps.hashCode() : 0);
            result = 31 * result + (this.throughputMode != null ? this.throughputMode.hashCode() : 0);
            return result;
        }
    }
}
