/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ecs;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.Duration;
import software.amazon.awscdk.services.ecs.;
import software.amazon.awscdk.services.ecs.CfnTaskDefinition;
import software.amazon.awscdk.services.ecs.ContainerDefinitionProps;
import software.amazon.awscdk.services.ecs.ContainerDependency;
import software.amazon.awscdk.services.ecs.ContainerImage;
import software.amazon.awscdk.services.ecs.HealthCheck;
import software.amazon.awscdk.services.ecs.LinuxParameters;
import software.amazon.awscdk.services.ecs.LogDriver;
import software.amazon.awscdk.services.ecs.LogDriverConfig;
import software.amazon.awscdk.services.ecs.MountPoint;
import software.amazon.awscdk.services.ecs.PortMapping;
import software.amazon.awscdk.services.ecs.Protocol;
import software.amazon.awscdk.services.ecs.ScratchSpace;
import software.amazon.awscdk.services.ecs.Secret;
import software.amazon.awscdk.services.ecs.TaskDefinition;
import software.amazon.awscdk.services.ecs.Ulimit;
import software.amazon.awscdk.services.ecs.VolumeFrom;
import software.amazon.awscdk.services.iam.PolicyStatement;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-ecs.ContainerDefinition")
public class ContainerDefinition
extends Construct {
    protected ContainerDefinition(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ContainerDefinition(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public ContainerDefinition(@NotNull Construct scope, @NotNull String id, @NotNull ContainerDefinitionProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    public void addContainerDependencies(ContainerDependency ... containerDependencies) {
        this.jsiiCall("addContainerDependencies", NativeType.VOID, Arrays.stream(containerDependencies).toArray(Object[]::new));
    }

    public void addLink(@NotNull ContainerDefinition container, @Nullable String alias) {
        this.jsiiCall("addLink", NativeType.VOID, new Object[]{Objects.requireNonNull(container, "container is required"), alias});
    }

    public void addLink(@NotNull ContainerDefinition container) {
        this.jsiiCall("addLink", NativeType.VOID, new Object[]{Objects.requireNonNull(container, "container is required")});
    }

    public void addMountPoints(MountPoint ... mountPoints) {
        this.jsiiCall("addMountPoints", NativeType.VOID, Arrays.stream(mountPoints).toArray(Object[]::new));
    }

    public void addPortMappings(PortMapping ... portMappings) {
        this.jsiiCall("addPortMappings", NativeType.VOID, Arrays.stream(portMappings).toArray(Object[]::new));
    }

    public void addScratch(@NotNull ScratchSpace scratch) {
        this.jsiiCall("addScratch", NativeType.VOID, new Object[]{Objects.requireNonNull(scratch, "scratch is required")});
    }

    public void addToExecutionPolicy(@NotNull PolicyStatement statement) {
        this.jsiiCall("addToExecutionPolicy", NativeType.VOID, new Object[]{Objects.requireNonNull(statement, "statement is required")});
    }

    public void addUlimits(Ulimit ... ulimits) {
        this.jsiiCall("addUlimits", NativeType.VOID, Arrays.stream(ulimits).toArray(Object[]::new));
    }

    public void addVolumesFrom(VolumeFrom ... volumesFrom) {
        this.jsiiCall("addVolumesFrom", NativeType.VOID, Arrays.stream(volumesFrom).toArray(Object[]::new));
    }

    @Nullable
    public PortMapping findPortMapping(@NotNull Number containerPort, @NotNull Protocol protocol) {
        return (PortMapping)this.jsiiCall("findPortMapping", PortMapping.class, new Object[]{Objects.requireNonNull(containerPort, "containerPort is required"), Objects.requireNonNull(protocol, "protocol is required")});
    }

    @NotNull
    public CfnTaskDefinition.ContainerDefinitionProperty renderContainerDefinition(@Nullable TaskDefinition _taskDefinition) {
        return (CfnTaskDefinition.ContainerDefinitionProperty)this.jsiiCall("renderContainerDefinition", CfnTaskDefinition.ContainerDefinitionProperty.class, new Object[]{_taskDefinition});
    }

    @NotNull
    public CfnTaskDefinition.ContainerDefinitionProperty renderContainerDefinition() {
        return (CfnTaskDefinition.ContainerDefinitionProperty)this.jsiiCall("renderContainerDefinition", CfnTaskDefinition.ContainerDefinitionProperty.class, new Object[0]);
    }

    @NotNull
    public List<ContainerDependency> getContainerDependencies() {
        return Collections.unmodifiableList((List)this.jsiiGet("containerDependencies", NativeType.listOf((NativeType)NativeType.forClass(ContainerDependency.class))));
    }

    @NotNull
    public String getContainerName() {
        return (String)this.jsiiGet("containerName", String.class);
    }

    @NotNull
    public Number getContainerPort() {
        return (Number)this.jsiiGet("containerPort", Number.class);
    }

    @NotNull
    public Boolean getEssential() {
        return (Boolean)this.jsiiGet("essential", Boolean.class);
    }

    @NotNull
    public Number getIngressPort() {
        return (Number)this.jsiiGet("ingressPort", Number.class);
    }

    @NotNull
    public Boolean getMemoryLimitSpecified() {
        return (Boolean)this.jsiiGet("memoryLimitSpecified", Boolean.class);
    }

    @NotNull
    public List<MountPoint> getMountPoints() {
        return Collections.unmodifiableList((List)this.jsiiGet("mountPoints", NativeType.listOf((NativeType)NativeType.forClass(MountPoint.class))));
    }

    @NotNull
    public List<PortMapping> getPortMappings() {
        return Collections.unmodifiableList((List)this.jsiiGet("portMappings", NativeType.listOf((NativeType)NativeType.forClass(PortMapping.class))));
    }

    @NotNull
    public TaskDefinition getTaskDefinition() {
        return (TaskDefinition)this.jsiiGet("taskDefinition", TaskDefinition.class);
    }

    @NotNull
    public List<Ulimit> getUlimits() {
        return Collections.unmodifiableList((List)this.jsiiGet("ulimits", NativeType.listOf((NativeType)NativeType.forClass(Ulimit.class))));
    }

    @NotNull
    public List<VolumeFrom> getVolumesFrom() {
        return Collections.unmodifiableList((List)this.jsiiGet("volumesFrom", NativeType.listOf((NativeType)NativeType.forClass(VolumeFrom.class))));
    }

    @Nullable
    public LinuxParameters getLinuxParameters() {
        return (LinuxParameters)((Object)this.jsiiGet("linuxParameters", LinuxParameters.class));
    }

    @Nullable
    public LogDriverConfig getLogDriverConfig() {
        return (LogDriverConfig)this.jsiiGet("logDriverConfig", LogDriverConfig.class);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<ContainerDefinition> {
        private final Construct scope;
        private final String id;
        private final ContainerDefinitionProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new ContainerDefinitionProps.Builder();
        }

        public Builder image(ContainerImage image) {
            this.props.image(image);
            return this;
        }

        public Builder command(List<String> command) {
            this.props.command(command);
            return this;
        }

        public Builder cpu(Number cpu) {
            this.props.cpu(cpu);
            return this;
        }

        public Builder disableNetworking(Boolean disableNetworking) {
            this.props.disableNetworking(disableNetworking);
            return this;
        }

        public Builder dnsSearchDomains(List<String> dnsSearchDomains) {
            this.props.dnsSearchDomains(dnsSearchDomains);
            return this;
        }

        public Builder dnsServers(List<String> dnsServers) {
            this.props.dnsServers(dnsServers);
            return this;
        }

        public Builder dockerLabels(Map<String, String> dockerLabels) {
            this.props.dockerLabels(dockerLabels);
            return this;
        }

        public Builder dockerSecurityOptions(List<String> dockerSecurityOptions) {
            this.props.dockerSecurityOptions(dockerSecurityOptions);
            return this;
        }

        public Builder entryPoint(List<String> entryPoint) {
            this.props.entryPoint(entryPoint);
            return this;
        }

        public Builder environment(Map<String, String> environment) {
            this.props.environment(environment);
            return this;
        }

        public Builder essential(Boolean essential) {
            this.props.essential(essential);
            return this;
        }

        public Builder extraHosts(Map<String, String> extraHosts) {
            this.props.extraHosts(extraHosts);
            return this;
        }

        public Builder gpuCount(Number gpuCount) {
            this.props.gpuCount(gpuCount);
            return this;
        }

        public Builder healthCheck(HealthCheck healthCheck) {
            this.props.healthCheck(healthCheck);
            return this;
        }

        public Builder hostname(String hostname) {
            this.props.hostname(hostname);
            return this;
        }

        public Builder linuxParameters(LinuxParameters linuxParameters) {
            this.props.linuxParameters(linuxParameters);
            return this;
        }

        public Builder logging(LogDriver logging) {
            this.props.logging(logging);
            return this;
        }

        public Builder memoryLimitMiB(Number memoryLimitMiB) {
            this.props.memoryLimitMiB(memoryLimitMiB);
            return this;
        }

        public Builder memoryReservationMiB(Number memoryReservationMiB) {
            this.props.memoryReservationMiB(memoryReservationMiB);
            return this;
        }

        public Builder privileged(Boolean privileged) {
            this.props.privileged(privileged);
            return this;
        }

        public Builder readonlyRootFilesystem(Boolean readonlyRootFilesystem) {
            this.props.readonlyRootFilesystem(readonlyRootFilesystem);
            return this;
        }

        public Builder secrets(Map<String, Secret> secrets) {
            this.props.secrets(secrets);
            return this;
        }

        public Builder startTimeout(Duration startTimeout) {
            this.props.startTimeout(startTimeout);
            return this;
        }

        public Builder stopTimeout(Duration stopTimeout) {
            this.props.stopTimeout(stopTimeout);
            return this;
        }

        public Builder user(String user) {
            this.props.user(user);
            return this;
        }

        public Builder workingDirectory(String workingDirectory) {
            this.props.workingDirectory(workingDirectory);
            return this;
        }

        public Builder taskDefinition(TaskDefinition taskDefinition) {
            this.props.taskDefinition(taskDefinition);
            return this;
        }

        public ContainerDefinition build() {
            return new ContainerDefinition(this.scope, this.id, this.props.build());
        }
    }
}

