/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ecs;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.ecs.;
import software.amazon.awscdk.services.ecs.CfnTaskSet;
import software.amazon.awscdk.services.ecs.CfnTaskSetProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-ecs.CfnTaskSet")
public class CfnTaskSet
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnTaskSet.class, (String)"CFN_RESOURCE_TYPE_NAME", String.class);

    protected CfnTaskSet(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnTaskSet(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnTaskSet(@NotNull Construct scope, @NotNull String id, @NotNull CfnTaskSetProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    public void inspect(@NotNull TreeInspector inspector) {
        this.jsiiCall("inspect", NativeType.VOID, new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)this.jsiiCall("renderProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrId() {
        return (String)this.jsiiGet("attrId", String.class);
    }

    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)this.jsiiGet("cfnProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public String getCluster() {
        return (String)this.jsiiGet("cluster", String.class);
    }

    public void setCluster(@NotNull String value) {
        this.jsiiSet("cluster", Objects.requireNonNull(value, "cluster is required"));
    }

    @NotNull
    public String getService() {
        return (String)this.jsiiGet("service", String.class);
    }

    public void setService(@NotNull String value) {
        this.jsiiSet("service", Objects.requireNonNull(value, "service is required"));
    }

    @NotNull
    public String getTaskDefinition() {
        return (String)this.jsiiGet("taskDefinition", String.class);
    }

    public void setTaskDefinition(@NotNull String value) {
        this.jsiiSet("taskDefinition", Objects.requireNonNull(value, "taskDefinition is required"));
    }

    @Nullable
    public String getExternalId() {
        return (String)this.jsiiGet("externalId", String.class);
    }

    public void setExternalId(@Nullable String value) {
        this.jsiiSet("externalId", value);
    }

    @Nullable
    public String getLaunchType() {
        return (String)this.jsiiGet("launchType", String.class);
    }

    public void setLaunchType(@Nullable String value) {
        this.jsiiSet("launchType", value);
    }

    @Nullable
    public Object getLoadBalancers() {
        return this.jsiiGet("loadBalancers", Object.class);
    }

    public void setLoadBalancers(@Nullable IResolvable value) {
        this.jsiiSet("loadBalancers", value);
    }

    public void setLoadBalancers(@Nullable List<Object> value) {
        this.jsiiSet("loadBalancers", value);
    }

    @Nullable
    public Object getNetworkConfiguration() {
        return this.jsiiGet("networkConfiguration", Object.class);
    }

    public void setNetworkConfiguration(@Nullable IResolvable value) {
        this.jsiiSet("networkConfiguration", value);
    }

    public void setNetworkConfiguration(@Nullable NetworkConfigurationProperty value) {
        this.jsiiSet("networkConfiguration", value);
    }

    @Nullable
    public String getPlatformVersion() {
        return (String)this.jsiiGet("platformVersion", String.class);
    }

    public void setPlatformVersion(@Nullable String value) {
        this.jsiiSet("platformVersion", value);
    }

    @Nullable
    public Object getScale() {
        return this.jsiiGet("scale", Object.class);
    }

    public void setScale(@Nullable IResolvable value) {
        this.jsiiSet("scale", value);
    }

    public void setScale(@Nullable ScaleProperty value) {
        this.jsiiSet("scale", value);
    }

    @Nullable
    public Object getServiceRegistries() {
        return this.jsiiGet("serviceRegistries", Object.class);
    }

    public void setServiceRegistries(@Nullable IResolvable value) {
        this.jsiiSet("serviceRegistries", value);
    }

    public void setServiceRegistries(@Nullable List<Object> value) {
        this.jsiiSet("serviceRegistries", value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnTaskSet> {
        private final Construct scope;
        private final String id;
        private final CfnTaskSetProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnTaskSetProps.Builder();
        }

        public Builder cluster(String cluster) {
            this.props.cluster(cluster);
            return this;
        }

        public Builder service(String service) {
            this.props.service(service);
            return this;
        }

        public Builder taskDefinition(String taskDefinition) {
            this.props.taskDefinition(taskDefinition);
            return this;
        }

        public Builder externalId(String externalId) {
            this.props.externalId(externalId);
            return this;
        }

        public Builder launchType(String launchType) {
            this.props.launchType(launchType);
            return this;
        }

        public Builder loadBalancers(IResolvable loadBalancers) {
            this.props.loadBalancers(loadBalancers);
            return this;
        }

        public Builder loadBalancers(List<Object> loadBalancers) {
            this.props.loadBalancers(loadBalancers);
            return this;
        }

        public Builder networkConfiguration(IResolvable networkConfiguration) {
            this.props.networkConfiguration(networkConfiguration);
            return this;
        }

        public Builder networkConfiguration(NetworkConfigurationProperty networkConfiguration) {
            this.props.networkConfiguration(networkConfiguration);
            return this;
        }

        public Builder platformVersion(String platformVersion) {
            this.props.platformVersion(platformVersion);
            return this;
        }

        public Builder scale(IResolvable scale) {
            this.props.scale(scale);
            return this;
        }

        public Builder scale(ScaleProperty scale) {
            this.props.scale(scale);
            return this;
        }

        public Builder serviceRegistries(IResolvable serviceRegistries) {
            this.props.serviceRegistries(serviceRegistries);
            return this;
        }

        public Builder serviceRegistries(List<Object> serviceRegistries) {
            this.props.serviceRegistries(serviceRegistries);
            return this;
        }

        public CfnTaskSet build() {
            return new CfnTaskSet(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-ecs.CfnTaskSet.ServiceRegistryProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ServiceRegistryProperty
    extends JsiiSerializable {
        @Nullable
        default public String getContainerName() {
            return null;
        }

        @Nullable
        default public Number getContainerPort() {
            return null;
        }

        @Nullable
        default public Number getPort() {
            return null;
        }

        @Nullable
        default public String getRegistryArn() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ServiceRegistryProperty> {
            private String containerName;
            private Number containerPort;
            private Number port;
            private String registryArn;

            public Builder containerName(String containerName) {
                this.containerName = containerName;
                return this;
            }

            public Builder containerPort(Number containerPort) {
                this.containerPort = containerPort;
                return this;
            }

            public Builder port(Number port) {
                this.port = port;
                return this;
            }

            public Builder registryArn(String registryArn) {
                this.registryArn = registryArn;
                return this;
            }

            public ServiceRegistryProperty build() {
                return new Jsii.Proxy(this.containerName, this.containerPort, this.port, this.registryArn, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-ecs.CfnTaskSet.ScaleProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ScaleProperty
    extends JsiiSerializable {
        @Nullable
        default public String getUnit() {
            return null;
        }

        @Nullable
        default public Number getValue() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ScaleProperty> {
            private String unit;
            private Number value;

            public Builder unit(String unit) {
                this.unit = unit;
                return this;
            }

            public Builder value(Number value) {
                this.value = value;
                return this;
            }

            public ScaleProperty build() {
                return new Jsii.Proxy(this.unit, this.value, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-ecs.CfnTaskSet.NetworkConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface NetworkConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getAwsVpcConfiguration() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<NetworkConfigurationProperty> {
            private Object awsVpcConfiguration;

            public Builder awsVpcConfiguration(IResolvable awsVpcConfiguration) {
                this.awsVpcConfiguration = awsVpcConfiguration;
                return this;
            }

            public Builder awsVpcConfiguration(AwsVpcConfigurationProperty awsVpcConfiguration) {
                this.awsVpcConfiguration = awsVpcConfiguration;
                return this;
            }

            public NetworkConfigurationProperty build() {
                return new Jsii.Proxy(this.awsVpcConfiguration, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-ecs.CfnTaskSet.LoadBalancerProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LoadBalancerProperty
    extends JsiiSerializable {
        @Nullable
        default public String getContainerName() {
            return null;
        }

        @Nullable
        default public Number getContainerPort() {
            return null;
        }

        @Nullable
        default public String getLoadBalancerName() {
            return null;
        }

        @Nullable
        default public String getTargetGroupArn() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LoadBalancerProperty> {
            private String containerName;
            private Number containerPort;
            private String loadBalancerName;
            private String targetGroupArn;

            public Builder containerName(String containerName) {
                this.containerName = containerName;
                return this;
            }

            public Builder containerPort(Number containerPort) {
                this.containerPort = containerPort;
                return this;
            }

            public Builder loadBalancerName(String loadBalancerName) {
                this.loadBalancerName = loadBalancerName;
                return this;
            }

            public Builder targetGroupArn(String targetGroupArn) {
                this.targetGroupArn = targetGroupArn;
                return this;
            }

            public LoadBalancerProperty build() {
                return new Jsii.Proxy(this.containerName, this.containerPort, this.loadBalancerName, this.targetGroupArn, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-ecs.CfnTaskSet.AwsVpcConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AwsVpcConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public List<String> getSubnets();

        @Nullable
        default public String getAssignPublicIp() {
            return null;
        }

        @Nullable
        default public List<String> getSecurityGroups() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AwsVpcConfigurationProperty> {
            private List<String> subnets;
            private String assignPublicIp;
            private List<String> securityGroups;

            public Builder subnets(List<String> subnets) {
                this.subnets = subnets;
                return this;
            }

            public Builder assignPublicIp(String assignPublicIp) {
                this.assignPublicIp = assignPublicIp;
                return this;
            }

            public Builder securityGroups(List<String> securityGroups) {
                this.securityGroups = securityGroups;
                return this;
            }

            public AwsVpcConfigurationProperty build() {
                return new Jsii.Proxy(this.subnets, this.assignPublicIp, this.securityGroups, null);
            }
        }
    }
}

