package software.amazon.awscdk.services.ecs;

/**
 * The details on a data volume from another container in the same task definition.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:33.052Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ecs.$Module.class, fqn = "@aws-cdk/aws-ecs.VolumeFrom")
@software.amazon.jsii.Jsii.Proxy(VolumeFrom.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface VolumeFrom extends software.amazon.jsii.JsiiSerializable {

    /**
     * Specifies whether the container has read-only access to the volume.
     * <p>
     * If this value is true, the container has read-only access to the volume.
     * If this value is false, then the container can write to the volume.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Boolean getReadOnly();

    /**
     * The name of another container within the same task definition from which to mount volumes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSourceContainer();

    /**
     * @return a {@link Builder} of {@link VolumeFrom}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link VolumeFrom}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<VolumeFrom> {
        private java.lang.Boolean readOnly;
        private java.lang.String sourceContainer;

        /**
         * Sets the value of {@link VolumeFrom#getReadOnly}
         * @param readOnly Specifies whether the container has read-only access to the volume. This parameter is required.
         *                 If this value is true, the container has read-only access to the volume.
         *                 If this value is false, then the container can write to the volume.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder readOnly(java.lang.Boolean readOnly) {
            this.readOnly = readOnly;
            return this;
        }

        /**
         * Sets the value of {@link VolumeFrom#getSourceContainer}
         * @param sourceContainer The name of another container within the same task definition from which to mount volumes. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceContainer(java.lang.String sourceContainer) {
            this.sourceContainer = sourceContainer;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link VolumeFrom}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public VolumeFrom build() {
            return new Jsii$Proxy(readOnly, sourceContainer);
        }
    }

    /**
     * An implementation for {@link VolumeFrom}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VolumeFrom {
        private final java.lang.Boolean readOnly;
        private final java.lang.String sourceContainer;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.readOnly = this.jsiiGet("readOnly", java.lang.Boolean.class);
            this.sourceContainer = this.jsiiGet("sourceContainer", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.Boolean readOnly, final java.lang.String sourceContainer) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.readOnly = java.util.Objects.requireNonNull(readOnly, "readOnly is required");
            this.sourceContainer = java.util.Objects.requireNonNull(sourceContainer, "sourceContainer is required");
        }

        @Override
        public java.lang.Boolean getReadOnly() {
            return this.readOnly;
        }

        @Override
        public java.lang.String getSourceContainer() {
            return this.sourceContainer;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("readOnly", om.valueToTree(this.getReadOnly()));
            data.set("sourceContainer", om.valueToTree(this.getSourceContainer()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ecs.VolumeFrom"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            VolumeFrom.Jsii$Proxy that = (VolumeFrom.Jsii$Proxy) o;

            if (!readOnly.equals(that.readOnly)) return false;
            return this.sourceContainer.equals(that.sourceContainer);
        }

        @Override
        public int hashCode() {
            int result = this.readOnly.hashCode();
            result = 31 * result + (this.sourceContainer.hashCode());
            return result;
        }
    }
}
