package software.amazon.awscdk.services.ecs;

/**
 * The properties for task definitions.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:33.049Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ecs.$Module.class, fqn = "@aws-cdk/aws-ecs.TaskDefinitionProps")
@software.amazon.jsii.Jsii.Proxy(TaskDefinitionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface TaskDefinitionProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.ecs.CommonTaskDefinitionProps {

    /**
     * The task launch type compatiblity requirement.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.Compatibility getCompatibility();

    /**
     * The number of cpu units used by the task.
     * <p>
     * If you are using the EC2 launch type, this field is optional and any value can be used.
     * If you are using the Fargate launch type, this field is required and you must use one of the following values,
     * which determines your range of valid values for the memory parameter:
     * <p>
     * 256 (.25 vCPU) - Available memory values: 512 (0.5 GB), 1024 (1 GB), 2048 (2 GB)
     * 512 (.5 vCPU) - Available memory values: 1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB)
     * 1024 (1 vCPU) - Available memory values: 2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB)
     * 2048 (2 vCPU) - Available memory values: Between 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB)
     * 4096 (4 vCPU) - Available memory values: Between 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB)
     * <p>
     * Default: - CPU units are not specified.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCpu() {
        return null;
    }

    /**
     * The IPC resource namespace to use for the containers in the task.
     * <p>
     * Not supported in Fargate and Windows containers.
     * <p>
     * Default: - IpcMode used by the task is not specified
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.IpcMode getIpcMode() {
        return null;
    }

    /**
     * The amount (in MiB) of memory used by the task.
     * <p>
     * If using the EC2 launch type, this field is optional and any value can be used.
     * If using the Fargate launch type, this field is required and you must use one of the following values,
     * which determines your range of valid values for the cpu parameter:
     * <p>
     * 512 (0.5 GB), 1024 (1 GB), 2048 (2 GB) - Available cpu values: 256 (.25 vCPU)
     * 1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB) - Available cpu values: 512 (.5 vCPU)
     * 2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB) - Available cpu values: 1024 (1 vCPU)
     * Between 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB) - Available cpu values: 2048 (2 vCPU)
     * Between 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB) - Available cpu values: 4096 (4 vCPU)
     * <p>
     * Default: - Memory used by task is not specified.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMemoryMiB() {
        return null;
    }

    /**
     * The networking mode to use for the containers in the task.
     * <p>
     * On Fargate, the only supported networking mode is AwsVpc.
     * <p>
     * Default: - NetworkMode.Bridge for EC2 tasks, AwsVpc for Fargate tasks.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.NetworkMode getNetworkMode() {
        return null;
    }

    /**
     * The process namespace to use for the containers in the task.
     * <p>
     * Not supported in Fargate and Windows containers.
     * <p>
     * Default: - PidMode used by the task is not specified
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.PidMode getPidMode() {
        return null;
    }

    /**
     * The placement constraints to use for tasks in the service.
     * <p>
     * You can specify a maximum of 10 constraints per task (this limit includes
     * constraints in the task definition and those specified at run time).
     * <p>
     * Not supported in Fargate.
     * <p>
     * Default: - No placement constraints.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ecs.PlacementConstraint> getPlacementConstraints() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link TaskDefinitionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link TaskDefinitionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<TaskDefinitionProps> {
        private software.amazon.awscdk.services.ecs.Compatibility compatibility;
        private java.lang.String cpu;
        private software.amazon.awscdk.services.ecs.IpcMode ipcMode;
        private java.lang.String memoryMiB;
        private software.amazon.awscdk.services.ecs.NetworkMode networkMode;
        private software.amazon.awscdk.services.ecs.PidMode pidMode;
        private java.util.List<software.amazon.awscdk.services.ecs.PlacementConstraint> placementConstraints;
        private software.amazon.awscdk.services.iam.IRole executionRole;
        private java.lang.String family;
        private software.amazon.awscdk.services.ecs.ProxyConfiguration proxyConfiguration;
        private software.amazon.awscdk.services.iam.IRole taskRole;
        private java.util.List<software.amazon.awscdk.services.ecs.Volume> volumes;

        /**
         * Sets the value of {@link TaskDefinitionProps#getCompatibility}
         * @param compatibility The task launch type compatiblity requirement. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder compatibility(software.amazon.awscdk.services.ecs.Compatibility compatibility) {
            this.compatibility = compatibility;
            return this;
        }

        /**
         * Sets the value of {@link TaskDefinitionProps#getCpu}
         * @param cpu The number of cpu units used by the task.
         *            If you are using the EC2 launch type, this field is optional and any value can be used.
         *            If you are using the Fargate launch type, this field is required and you must use one of the following values,
         *            which determines your range of valid values for the memory parameter:
         *            <p>
         *            256 (.25 vCPU) - Available memory values: 512 (0.5 GB), 1024 (1 GB), 2048 (2 GB)
         *            512 (.5 vCPU) - Available memory values: 1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB)
         *            1024 (1 vCPU) - Available memory values: 2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB)
         *            2048 (2 vCPU) - Available memory values: Between 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB)
         *            4096 (4 vCPU) - Available memory values: Between 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB)
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cpu(java.lang.String cpu) {
            this.cpu = cpu;
            return this;
        }

        /**
         * Sets the value of {@link TaskDefinitionProps#getIpcMode}
         * @param ipcMode The IPC resource namespace to use for the containers in the task.
         *                Not supported in Fargate and Windows containers.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipcMode(software.amazon.awscdk.services.ecs.IpcMode ipcMode) {
            this.ipcMode = ipcMode;
            return this;
        }

        /**
         * Sets the value of {@link TaskDefinitionProps#getMemoryMiB}
         * @param memoryMiB The amount (in MiB) of memory used by the task.
         *                  If using the EC2 launch type, this field is optional and any value can be used.
         *                  If using the Fargate launch type, this field is required and you must use one of the following values,
         *                  which determines your range of valid values for the cpu parameter:
         *                  <p>
         *                  512 (0.5 GB), 1024 (1 GB), 2048 (2 GB) - Available cpu values: 256 (.25 vCPU)
         *                  1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB) - Available cpu values: 512 (.5 vCPU)
         *                  2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB) - Available cpu values: 1024 (1 vCPU)
         *                  Between 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB) - Available cpu values: 2048 (2 vCPU)
         *                  Between 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB) - Available cpu values: 4096 (4 vCPU)
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder memoryMiB(java.lang.String memoryMiB) {
            this.memoryMiB = memoryMiB;
            return this;
        }

        /**
         * Sets the value of {@link TaskDefinitionProps#getNetworkMode}
         * @param networkMode The networking mode to use for the containers in the task.
         *                    On Fargate, the only supported networking mode is AwsVpc.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkMode(software.amazon.awscdk.services.ecs.NetworkMode networkMode) {
            this.networkMode = networkMode;
            return this;
        }

        /**
         * Sets the value of {@link TaskDefinitionProps#getPidMode}
         * @param pidMode The process namespace to use for the containers in the task.
         *                Not supported in Fargate and Windows containers.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pidMode(software.amazon.awscdk.services.ecs.PidMode pidMode) {
            this.pidMode = pidMode;
            return this;
        }

        /**
         * Sets the value of {@link TaskDefinitionProps#getPlacementConstraints}
         * @param placementConstraints The placement constraints to use for tasks in the service.
         *                             You can specify a maximum of 10 constraints per task (this limit includes
         *                             constraints in the task definition and those specified at run time).
         *                             <p>
         *                             Not supported in Fargate.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder placementConstraints(java.util.List<software.amazon.awscdk.services.ecs.PlacementConstraint> placementConstraints) {
            this.placementConstraints = placementConstraints;
            return this;
        }

        /**
         * Sets the value of {@link TaskDefinitionProps#getExecutionRole}
         * @param executionRole The name of the IAM task execution role that grants the ECS agent to call AWS APIs on your behalf.
         *                      The role will be used to retrieve container images from ECR and create CloudWatch log groups.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder executionRole(software.amazon.awscdk.services.iam.IRole executionRole) {
            this.executionRole = executionRole;
            return this;
        }

        /**
         * Sets the value of {@link TaskDefinitionProps#getFamily}
         * @param family The name of a family that this task definition is registered to.
         *               A family groups multiple versions of a task definition.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder family(java.lang.String family) {
            this.family = family;
            return this;
        }

        /**
         * Sets the value of {@link TaskDefinitionProps#getProxyConfiguration}
         * @param proxyConfiguration The configuration details for the App Mesh proxy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder proxyConfiguration(software.amazon.awscdk.services.ecs.ProxyConfiguration proxyConfiguration) {
            this.proxyConfiguration = proxyConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link TaskDefinitionProps#getTaskRole}
         * @param taskRole The name of the IAM role that grants containers in the task permission to call AWS APIs on your behalf.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskRole(software.amazon.awscdk.services.iam.IRole taskRole) {
            this.taskRole = taskRole;
            return this;
        }

        /**
         * Sets the value of {@link TaskDefinitionProps#getVolumes}
         * @param volumes The list of volume definitions for the task.
         *                For more information, see
         *                <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide//task_definition_parameters.html#volumes">Task Definition Parameter Volumes</a>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder volumes(java.util.List<software.amazon.awscdk.services.ecs.Volume> volumes) {
            this.volumes = volumes;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link TaskDefinitionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public TaskDefinitionProps build() {
            return new Jsii$Proxy(compatibility, cpu, ipcMode, memoryMiB, networkMode, pidMode, placementConstraints, executionRole, family, proxyConfiguration, taskRole, volumes);
        }
    }

    /**
     * An implementation for {@link TaskDefinitionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TaskDefinitionProps {
        private final software.amazon.awscdk.services.ecs.Compatibility compatibility;
        private final java.lang.String cpu;
        private final software.amazon.awscdk.services.ecs.IpcMode ipcMode;
        private final java.lang.String memoryMiB;
        private final software.amazon.awscdk.services.ecs.NetworkMode networkMode;
        private final software.amazon.awscdk.services.ecs.PidMode pidMode;
        private final java.util.List<software.amazon.awscdk.services.ecs.PlacementConstraint> placementConstraints;
        private final software.amazon.awscdk.services.iam.IRole executionRole;
        private final java.lang.String family;
        private final software.amazon.awscdk.services.ecs.ProxyConfiguration proxyConfiguration;
        private final software.amazon.awscdk.services.iam.IRole taskRole;
        private final java.util.List<software.amazon.awscdk.services.ecs.Volume> volumes;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.compatibility = this.jsiiGet("compatibility", software.amazon.awscdk.services.ecs.Compatibility.class);
            this.cpu = this.jsiiGet("cpu", java.lang.String.class);
            this.ipcMode = this.jsiiGet("ipcMode", software.amazon.awscdk.services.ecs.IpcMode.class);
            this.memoryMiB = this.jsiiGet("memoryMiB", java.lang.String.class);
            this.networkMode = this.jsiiGet("networkMode", software.amazon.awscdk.services.ecs.NetworkMode.class);
            this.pidMode = this.jsiiGet("pidMode", software.amazon.awscdk.services.ecs.PidMode.class);
            this.placementConstraints = this.jsiiGet("placementConstraints", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.PlacementConstraint.class)));
            this.executionRole = this.jsiiGet("executionRole", software.amazon.awscdk.services.iam.IRole.class);
            this.family = this.jsiiGet("family", java.lang.String.class);
            this.proxyConfiguration = this.jsiiGet("proxyConfiguration", software.amazon.awscdk.services.ecs.ProxyConfiguration.class);
            this.taskRole = this.jsiiGet("taskRole", software.amazon.awscdk.services.iam.IRole.class);
            this.volumes = this.jsiiGet("volumes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.Volume.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.services.ecs.Compatibility compatibility, final java.lang.String cpu, final software.amazon.awscdk.services.ecs.IpcMode ipcMode, final java.lang.String memoryMiB, final software.amazon.awscdk.services.ecs.NetworkMode networkMode, final software.amazon.awscdk.services.ecs.PidMode pidMode, final java.util.List<software.amazon.awscdk.services.ecs.PlacementConstraint> placementConstraints, final software.amazon.awscdk.services.iam.IRole executionRole, final java.lang.String family, final software.amazon.awscdk.services.ecs.ProxyConfiguration proxyConfiguration, final software.amazon.awscdk.services.iam.IRole taskRole, final java.util.List<software.amazon.awscdk.services.ecs.Volume> volumes) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.compatibility = java.util.Objects.requireNonNull(compatibility, "compatibility is required");
            this.cpu = cpu;
            this.ipcMode = ipcMode;
            this.memoryMiB = memoryMiB;
            this.networkMode = networkMode;
            this.pidMode = pidMode;
            this.placementConstraints = placementConstraints;
            this.executionRole = executionRole;
            this.family = family;
            this.proxyConfiguration = proxyConfiguration;
            this.taskRole = taskRole;
            this.volumes = volumes;
        }

        @Override
        public software.amazon.awscdk.services.ecs.Compatibility getCompatibility() {
            return this.compatibility;
        }

        @Override
        public java.lang.String getCpu() {
            return this.cpu;
        }

        @Override
        public software.amazon.awscdk.services.ecs.IpcMode getIpcMode() {
            return this.ipcMode;
        }

        @Override
        public java.lang.String getMemoryMiB() {
            return this.memoryMiB;
        }

        @Override
        public software.amazon.awscdk.services.ecs.NetworkMode getNetworkMode() {
            return this.networkMode;
        }

        @Override
        public software.amazon.awscdk.services.ecs.PidMode getPidMode() {
            return this.pidMode;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.ecs.PlacementConstraint> getPlacementConstraints() {
            return this.placementConstraints;
        }

        @Override
        public software.amazon.awscdk.services.iam.IRole getExecutionRole() {
            return this.executionRole;
        }

        @Override
        public java.lang.String getFamily() {
            return this.family;
        }

        @Override
        public software.amazon.awscdk.services.ecs.ProxyConfiguration getProxyConfiguration() {
            return this.proxyConfiguration;
        }

        @Override
        public software.amazon.awscdk.services.iam.IRole getTaskRole() {
            return this.taskRole;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.ecs.Volume> getVolumes() {
            return this.volumes;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("compatibility", om.valueToTree(this.getCompatibility()));
            if (this.getCpu() != null) {
                data.set("cpu", om.valueToTree(this.getCpu()));
            }
            if (this.getIpcMode() != null) {
                data.set("ipcMode", om.valueToTree(this.getIpcMode()));
            }
            if (this.getMemoryMiB() != null) {
                data.set("memoryMiB", om.valueToTree(this.getMemoryMiB()));
            }
            if (this.getNetworkMode() != null) {
                data.set("networkMode", om.valueToTree(this.getNetworkMode()));
            }
            if (this.getPidMode() != null) {
                data.set("pidMode", om.valueToTree(this.getPidMode()));
            }
            if (this.getPlacementConstraints() != null) {
                data.set("placementConstraints", om.valueToTree(this.getPlacementConstraints()));
            }
            if (this.getExecutionRole() != null) {
                data.set("executionRole", om.valueToTree(this.getExecutionRole()));
            }
            if (this.getFamily() != null) {
                data.set("family", om.valueToTree(this.getFamily()));
            }
            if (this.getProxyConfiguration() != null) {
                data.set("proxyConfiguration", om.valueToTree(this.getProxyConfiguration()));
            }
            if (this.getTaskRole() != null) {
                data.set("taskRole", om.valueToTree(this.getTaskRole()));
            }
            if (this.getVolumes() != null) {
                data.set("volumes", om.valueToTree(this.getVolumes()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ecs.TaskDefinitionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            TaskDefinitionProps.Jsii$Proxy that = (TaskDefinitionProps.Jsii$Proxy) o;

            if (!compatibility.equals(that.compatibility)) return false;
            if (this.cpu != null ? !this.cpu.equals(that.cpu) : that.cpu != null) return false;
            if (this.ipcMode != null ? !this.ipcMode.equals(that.ipcMode) : that.ipcMode != null) return false;
            if (this.memoryMiB != null ? !this.memoryMiB.equals(that.memoryMiB) : that.memoryMiB != null) return false;
            if (this.networkMode != null ? !this.networkMode.equals(that.networkMode) : that.networkMode != null) return false;
            if (this.pidMode != null ? !this.pidMode.equals(that.pidMode) : that.pidMode != null) return false;
            if (this.placementConstraints != null ? !this.placementConstraints.equals(that.placementConstraints) : that.placementConstraints != null) return false;
            if (this.executionRole != null ? !this.executionRole.equals(that.executionRole) : that.executionRole != null) return false;
            if (this.family != null ? !this.family.equals(that.family) : that.family != null) return false;
            if (this.proxyConfiguration != null ? !this.proxyConfiguration.equals(that.proxyConfiguration) : that.proxyConfiguration != null) return false;
            if (this.taskRole != null ? !this.taskRole.equals(that.taskRole) : that.taskRole != null) return false;
            return this.volumes != null ? this.volumes.equals(that.volumes) : that.volumes == null;
        }

        @Override
        public int hashCode() {
            int result = this.compatibility.hashCode();
            result = 31 * result + (this.cpu != null ? this.cpu.hashCode() : 0);
            result = 31 * result + (this.ipcMode != null ? this.ipcMode.hashCode() : 0);
            result = 31 * result + (this.memoryMiB != null ? this.memoryMiB.hashCode() : 0);
            result = 31 * result + (this.networkMode != null ? this.networkMode.hashCode() : 0);
            result = 31 * result + (this.pidMode != null ? this.pidMode.hashCode() : 0);
            result = 31 * result + (this.placementConstraints != null ? this.placementConstraints.hashCode() : 0);
            result = 31 * result + (this.executionRole != null ? this.executionRole.hashCode() : 0);
            result = 31 * result + (this.family != null ? this.family.hashCode() : 0);
            result = 31 * result + (this.proxyConfiguration != null ? this.proxyConfiguration.hashCode() : 0);
            result = 31 * result + (this.taskRole != null ? this.taskRole.hashCode() : 0);
            result = 31 * result + (this.volumes != null ? this.volumes.hashCode() : 0);
            return result;
        }
    }
}
