package software.amazon.awscdk.services.ecs;

/**
 * The base class for all task definitions.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:33.039Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ecs.$Module.class, fqn = "@aws-cdk/aws-ecs.TaskDefinition")
public class TaskDefinition extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.ecs.ITaskDefinition {

    protected TaskDefinition(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected TaskDefinition(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Constructs a new instance of the TaskDefinition class.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public TaskDefinition(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.TaskDefinitionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Imports a task definition from the specified task definition ARN.
     * <p>
     * The task will have a compatibility of EC2+Fargate.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param taskDefinitionArn This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.ITaskDefinition fromTaskDefinitionArn(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String taskDefinitionArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecs.TaskDefinition.class, "fromTaskDefinitionArn", software.amazon.awscdk.services.ecs.ITaskDefinition.class, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(taskDefinitionArn, "taskDefinitionArn is required") });
    }

    /**
     * Adds a new container to the task definition.
     * <p>
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.ContainerDefinition addContainer(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.ContainerDefinitionOptions props) {
        return this.jsiiCall("addContainer", software.amazon.awscdk.services.ecs.ContainerDefinition.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Adds the specified extention to the task definition.
     * <p>
     * Extension can be used to apply a packaged modification to
     * a task definition.
     * <p>
     * @param extension This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addExtension(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.ITaskDefinitionExtension extension) {
        this.jsiiCall("addExtension", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(extension, "extension is required") });
    }

    /**
     * Adds a firelens log router to the task definition.
     * <p>
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.FirelensLogRouter addFirelensLogRouter(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.FirelensLogRouterDefinitionOptions props) {
        return this.jsiiCall("addFirelensLogRouter", software.amazon.awscdk.services.ecs.FirelensLogRouter.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Adds the specified placement constraint to the task definition.
     * <p>
     * @param constraint This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addPlacementConstraint(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.PlacementConstraint constraint) {
        this.jsiiCall("addPlacementConstraint", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(constraint, "constraint is required") });
    }

    /**
     * Adds a policy statement to the task execution IAM role.
     * <p>
     * @param statement This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addToExecutionRolePolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyStatement statement) {
        this.jsiiCall("addToExecutionRolePolicy", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(statement, "statement is required") });
    }

    /**
     * Adds a policy statement to the task IAM role.
     * <p>
     * @param statement This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addToTaskRolePolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyStatement statement) {
        this.jsiiCall("addToTaskRolePolicy", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(statement, "statement is required") });
    }

    /**
     * Adds a volume to the task definition.
     * <p>
     * @param volume This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addVolume(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.Volume volume) {
        this.jsiiCall("addVolume", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(volume, "volume is required") });
    }

    /**
     * Creates the task execution IAM role if it doesn't already exist.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole obtainExecutionRole() {
        return this.jsiiCall("obtainExecutionRole", software.amazon.awscdk.services.iam.IRole.class);
    }

    /**
     * Validates the task definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> validate() {
        return java.util.Collections.unmodifiableList(this.jsiiCall("validate", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * The task launch type compatiblity requirement.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.Compatibility getCompatibility() {
        return this.jsiiGet("compatibility", software.amazon.awscdk.services.ecs.Compatibility.class);
    }

    /**
     * The container definitions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.ecs.ContainerDefinition> getContainers() {
        return java.util.Collections.unmodifiableList(this.jsiiGet("containers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.ContainerDefinition.class))));
    }

    /**
     * The name of a family that this task definition is registered to.
     * <p>
     * A family groups multiple versions of a task definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getFamily() {
        return this.jsiiGet("family", java.lang.String.class);
    }

    /**
     * Return true if the task definition can be run on an EC2 cluster.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getIsEc2Compatible() {
        return this.jsiiGet("isEc2Compatible", java.lang.Boolean.class);
    }

    /**
     * Return true if the task definition can be run on a Fargate cluster.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getIsFargateCompatible() {
        return this.jsiiGet("isFargateCompatible", java.lang.Boolean.class);
    }

    /**
     * The networking mode to use for the containers in the task.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.NetworkMode getNetworkMode() {
        return this.jsiiGet("networkMode", software.amazon.awscdk.services.ecs.NetworkMode.class);
    }

    /**
     * The full Amazon Resource Name (ARN) of the task definition.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getTaskDefinitionArn() {
        return this.jsiiGet("taskDefinitionArn", java.lang.String.class);
    }

    /**
     * The name of the IAM role that grants containers in the task permission to call AWS APIs on your behalf.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole getTaskRole() {
        return this.jsiiGet("taskRole", software.amazon.awscdk.services.iam.IRole.class);
    }

    /**
     * Execution role for this task definition.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getExecutionRole() {
        return this.jsiiGet("executionRole", software.amazon.awscdk.services.iam.IRole.class);
    }

    /**
     * Default container for this task.
     * <p>
     * Load balancers will send traffic to this container. The first
     * essential container that is added to this task will become the default
     * container.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.ContainerDefinition getDefaultContainer() {
        return this.jsiiGet("defaultContainer", software.amazon.awscdk.services.ecs.ContainerDefinition.class);
    }

    /**
     * Default container for this task.
     * <p>
     * Load balancers will send traffic to this container. The first
     * essential container that is added to this task will become the default
     * container.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefaultContainer(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.ContainerDefinition value) {
        this.jsiiSet("defaultContainer", value);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ecs.TaskDefinition}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ecs.TaskDefinition> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ecs.TaskDefinitionProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ecs.TaskDefinitionProps.Builder();
        }

        /**
         * The name of the IAM task execution role that grants the ECS agent to call AWS APIs on your behalf.
         * <p>
         * The role will be used to retrieve container images from ECR and create CloudWatch log groups.
         * <p>
         * Default: - An execution role will be automatically created if you use ECR images in your task definition.
         * <p>
         * @return {@code this}
         * @param executionRole The name of the IAM task execution role that grants the ECS agent to call AWS APIs on your behalf. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder executionRole(final software.amazon.awscdk.services.iam.IRole executionRole) {
            this.props.executionRole(executionRole);
            return this;
        }

        /**
         * The name of a family that this task definition is registered to.
         * <p>
         * A family groups multiple versions of a task definition.
         * <p>
         * Default: - Automatically generated name.
         * <p>
         * @return {@code this}
         * @param family The name of a family that this task definition is registered to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder family(final java.lang.String family) {
            this.props.family(family);
            return this;
        }

        /**
         * The configuration details for the App Mesh proxy.
         * <p>
         * Default: - No proxy configuration.
         * <p>
         * @return {@code this}
         * @param proxyConfiguration The configuration details for the App Mesh proxy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder proxyConfiguration(final software.amazon.awscdk.services.ecs.ProxyConfiguration proxyConfiguration) {
            this.props.proxyConfiguration(proxyConfiguration);
            return this;
        }

        /**
         * The name of the IAM role that grants containers in the task permission to call AWS APIs on your behalf.
         * <p>
         * Default: - A task role is automatically created for you.
         * <p>
         * @return {@code this}
         * @param taskRole The name of the IAM role that grants containers in the task permission to call AWS APIs on your behalf. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskRole(final software.amazon.awscdk.services.iam.IRole taskRole) {
            this.props.taskRole(taskRole);
            return this;
        }

        /**
         * The list of volume definitions for the task.
         * <p>
         * For more information, see
         * <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide//task_definition_parameters.html#volumes">Task Definition Parameter Volumes</a>.
         * <p>
         * Default: - No volumes are passed to the Docker daemon on a container instance.
         * <p>
         * @return {@code this}
         * @param volumes The list of volume definitions for the task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder volumes(final java.util.List<software.amazon.awscdk.services.ecs.Volume> volumes) {
            this.props.volumes(volumes);
            return this;
        }

        /**
         * The task launch type compatiblity requirement.
         * <p>
         * @return {@code this}
         * @param compatibility The task launch type compatiblity requirement. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder compatibility(final software.amazon.awscdk.services.ecs.Compatibility compatibility) {
            this.props.compatibility(compatibility);
            return this;
        }

        /**
         * The number of cpu units used by the task.
         * <p>
         * If you are using the EC2 launch type, this field is optional and any value can be used.
         * If you are using the Fargate launch type, this field is required and you must use one of the following values,
         * which determines your range of valid values for the memory parameter:
         * <p>
         * 256 (.25 vCPU) - Available memory values: 512 (0.5 GB), 1024 (1 GB), 2048 (2 GB)
         * 512 (.5 vCPU) - Available memory values: 1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB)
         * 1024 (1 vCPU) - Available memory values: 2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB)
         * 2048 (2 vCPU) - Available memory values: Between 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB)
         * 4096 (4 vCPU) - Available memory values: Between 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB)
         * <p>
         * Default: - CPU units are not specified.
         * <p>
         * @return {@code this}
         * @param cpu The number of cpu units used by the task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cpu(final java.lang.String cpu) {
            this.props.cpu(cpu);
            return this;
        }

        /**
         * The IPC resource namespace to use for the containers in the task.
         * <p>
         * Not supported in Fargate and Windows containers.
         * <p>
         * Default: - IpcMode used by the task is not specified
         * <p>
         * @return {@code this}
         * @param ipcMode The IPC resource namespace to use for the containers in the task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipcMode(final software.amazon.awscdk.services.ecs.IpcMode ipcMode) {
            this.props.ipcMode(ipcMode);
            return this;
        }

        /**
         * The amount (in MiB) of memory used by the task.
         * <p>
         * If using the EC2 launch type, this field is optional and any value can be used.
         * If using the Fargate launch type, this field is required and you must use one of the following values,
         * which determines your range of valid values for the cpu parameter:
         * <p>
         * 512 (0.5 GB), 1024 (1 GB), 2048 (2 GB) - Available cpu values: 256 (.25 vCPU)
         * 1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB) - Available cpu values: 512 (.5 vCPU)
         * 2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB) - Available cpu values: 1024 (1 vCPU)
         * Between 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB) - Available cpu values: 2048 (2 vCPU)
         * Between 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB) - Available cpu values: 4096 (4 vCPU)
         * <p>
         * Default: - Memory used by task is not specified.
         * <p>
         * @return {@code this}
         * @param memoryMiB The amount (in MiB) of memory used by the task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder memoryMiB(final java.lang.String memoryMiB) {
            this.props.memoryMiB(memoryMiB);
            return this;
        }

        /**
         * The networking mode to use for the containers in the task.
         * <p>
         * On Fargate, the only supported networking mode is AwsVpc.
         * <p>
         * Default: - NetworkMode.Bridge for EC2 tasks, AwsVpc for Fargate tasks.
         * <p>
         * @return {@code this}
         * @param networkMode The networking mode to use for the containers in the task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkMode(final software.amazon.awscdk.services.ecs.NetworkMode networkMode) {
            this.props.networkMode(networkMode);
            return this;
        }

        /**
         * The process namespace to use for the containers in the task.
         * <p>
         * Not supported in Fargate and Windows containers.
         * <p>
         * Default: - PidMode used by the task is not specified
         * <p>
         * @return {@code this}
         * @param pidMode The process namespace to use for the containers in the task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pidMode(final software.amazon.awscdk.services.ecs.PidMode pidMode) {
            this.props.pidMode(pidMode);
            return this;
        }

        /**
         * The placement constraints to use for tasks in the service.
         * <p>
         * You can specify a maximum of 10 constraints per task (this limit includes
         * constraints in the task definition and those specified at run time).
         * <p>
         * Not supported in Fargate.
         * <p>
         * Default: - No placement constraints.
         * <p>
         * @return {@code this}
         * @param placementConstraints The placement constraints to use for tasks in the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder placementConstraints(final java.util.List<software.amazon.awscdk.services.ecs.PlacementConstraint> placementConstraints) {
            this.props.placementConstraints(placementConstraints);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ecs.TaskDefinition}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ecs.TaskDefinition build() {
            return new software.amazon.awscdk.services.ecs.TaskDefinition(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
