package software.amazon.awscdk.services.ecs;

/**
 * The configuration to use when creating a log driver.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:33.032Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ecs.$Module.class, fqn = "@aws-cdk/aws-ecs.LogDriverConfig")
@software.amazon.jsii.Jsii.Proxy(LogDriverConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface LogDriverConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * The log driver to use for the container.
     * <p>
     * The valid values listed for this parameter are log drivers
     * that the Amazon ECS container agent can communicate with by default.
     * <p>
     * For tasks using the Fargate launch type, the supported log drivers are awslogs, splunk, and awsfirelens.
     * For tasks using the EC2 launch type, the supported log drivers are awslogs, fluentd, gelf, json-file, journald,
     * logentries,syslog, splunk, and awsfirelens.
     * <p>
     * For more information about using the awslogs log driver, see
     * <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_awslogs.html">Using the awslogs Log Driver</a>
     * in the Amazon Elastic Container Service Developer Guide.
     * <p>
     * For more information about using the awsfirelens log driver, see
     * <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_firelens.html">Custom Log Routing</a>
     * in the Amazon Elastic Container Service Developer Guide.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getLogDriver();

    /**
     * The configuration options to send to the log driver.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getOptions() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link LogDriverConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LogDriverConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<LogDriverConfig> {
        private java.lang.String logDriver;
        private java.util.Map<java.lang.String, java.lang.String> options;

        /**
         * Sets the value of {@link LogDriverConfig#getLogDriver}
         * @param logDriver The log driver to use for the container. This parameter is required.
         *                  The valid values listed for this parameter are log drivers
         *                  that the Amazon ECS container agent can communicate with by default.
         *                  <p>
         *                  For tasks using the Fargate launch type, the supported log drivers are awslogs, splunk, and awsfirelens.
         *                  For tasks using the EC2 launch type, the supported log drivers are awslogs, fluentd, gelf, json-file, journald,
         *                  logentries,syslog, splunk, and awsfirelens.
         *                  <p>
         *                  For more information about using the awslogs log driver, see
         *                  <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_awslogs.html">Using the awslogs Log Driver</a>
         *                  in the Amazon Elastic Container Service Developer Guide.
         *                  <p>
         *                  For more information about using the awsfirelens log driver, see
         *                  <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_firelens.html">Custom Log Routing</a>
         *                  in the Amazon Elastic Container Service Developer Guide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logDriver(java.lang.String logDriver) {
            this.logDriver = logDriver;
            return this;
        }

        /**
         * Sets the value of {@link LogDriverConfig#getOptions}
         * @param options The configuration options to send to the log driver.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder options(java.util.Map<java.lang.String, java.lang.String> options) {
            this.options = options;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LogDriverConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public LogDriverConfig build() {
            return new Jsii$Proxy(logDriver, options);
        }
    }

    /**
     * An implementation for {@link LogDriverConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LogDriverConfig {
        private final java.lang.String logDriver;
        private final java.util.Map<java.lang.String, java.lang.String> options;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.logDriver = this.jsiiGet("logDriver", java.lang.String.class);
            this.options = this.jsiiGet("options", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String logDriver, final java.util.Map<java.lang.String, java.lang.String> options) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.logDriver = java.util.Objects.requireNonNull(logDriver, "logDriver is required");
            this.options = options;
        }

        @Override
        public java.lang.String getLogDriver() {
            return this.logDriver;
        }

        @Override
        public java.util.Map<java.lang.String, java.lang.String> getOptions() {
            return this.options;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("logDriver", om.valueToTree(this.getLogDriver()));
            if (this.getOptions() != null) {
                data.set("options", om.valueToTree(this.getOptions()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ecs.LogDriverConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LogDriverConfig.Jsii$Proxy that = (LogDriverConfig.Jsii$Proxy) o;

            if (!logDriver.equals(that.logDriver)) return false;
            return this.options != null ? this.options.equals(that.options) : that.options == null;
        }

        @Override
        public int hashCode() {
            int result = this.logDriver.hashCode();
            result = 31 * result + (this.options != null ? this.options.hashCode() : 0);
            return result;
        }
    }
}
