package software.amazon.awscdk.services.ecs;

/**
 * The properties for defining Linux-specific options that are applied to the container.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:33.032Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ecs.$Module.class, fqn = "@aws-cdk/aws-ecs.LinuxParametersProps")
@software.amazon.jsii.Jsii.Proxy(LinuxParametersProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface LinuxParametersProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Specifies whether to run an init process inside the container that forwards signals and reaps processes.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getInitProcessEnabled() {
        return null;
    }

    /**
     * The value for the size (in MiB) of the /dev/shm volume.
     * <p>
     * Default: No shared memory.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getSharedMemorySize() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link LinuxParametersProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LinuxParametersProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<LinuxParametersProps> {
        private java.lang.Boolean initProcessEnabled;
        private java.lang.Number sharedMemorySize;

        /**
         * Sets the value of {@link LinuxParametersProps#getInitProcessEnabled}
         * @param initProcessEnabled Specifies whether to run an init process inside the container that forwards signals and reaps processes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder initProcessEnabled(java.lang.Boolean initProcessEnabled) {
            this.initProcessEnabled = initProcessEnabled;
            return this;
        }

        /**
         * Sets the value of {@link LinuxParametersProps#getSharedMemorySize}
         * @param sharedMemorySize The value for the size (in MiB) of the /dev/shm volume.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sharedMemorySize(java.lang.Number sharedMemorySize) {
            this.sharedMemorySize = sharedMemorySize;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LinuxParametersProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public LinuxParametersProps build() {
            return new Jsii$Proxy(initProcessEnabled, sharedMemorySize);
        }
    }

    /**
     * An implementation for {@link LinuxParametersProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LinuxParametersProps {
        private final java.lang.Boolean initProcessEnabled;
        private final java.lang.Number sharedMemorySize;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.initProcessEnabled = this.jsiiGet("initProcessEnabled", java.lang.Boolean.class);
            this.sharedMemorySize = this.jsiiGet("sharedMemorySize", java.lang.Number.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.Boolean initProcessEnabled, final java.lang.Number sharedMemorySize) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.initProcessEnabled = initProcessEnabled;
            this.sharedMemorySize = sharedMemorySize;
        }

        @Override
        public java.lang.Boolean getInitProcessEnabled() {
            return this.initProcessEnabled;
        }

        @Override
        public java.lang.Number getSharedMemorySize() {
            return this.sharedMemorySize;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getInitProcessEnabled() != null) {
                data.set("initProcessEnabled", om.valueToTree(this.getInitProcessEnabled()));
            }
            if (this.getSharedMemorySize() != null) {
                data.set("sharedMemorySize", om.valueToTree(this.getSharedMemorySize()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ecs.LinuxParametersProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LinuxParametersProps.Jsii$Proxy that = (LinuxParametersProps.Jsii$Proxy) o;

            if (this.initProcessEnabled != null ? !this.initProcessEnabled.equals(that.initProcessEnabled) : that.initProcessEnabled != null) return false;
            return this.sharedMemorySize != null ? this.sharedMemorySize.equals(that.sharedMemorySize) : that.sharedMemorySize == null;
        }

        @Override
        public int hashCode() {
            int result = this.initProcessEnabled != null ? this.initProcessEnabled.hashCode() : 0;
            result = 31 * result + (this.sharedMemorySize != null ? this.sharedMemorySize.hashCode() : 0);
            return result;
        }
    }
}
