package software.amazon.awscdk.services.ecs;

/**
 * An extension for Task Definitions.
 * <p>
 * Classes that want to make changes to a TaskDefinition (such as
 * adding helper containers) can implement this interface, and can
 * then be "added" to a TaskDefinition like so:
 * <p>
 * <blockquote><pre>
 * taskDefinition.addExtension(new MyExtension("some_parameter"));
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:33.029Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ecs.$Module.class, fqn = "@aws-cdk/aws-ecs.ITaskDefinitionExtension")
@software.amazon.jsii.Jsii.Proxy(ITaskDefinitionExtension.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ITaskDefinitionExtension extends software.amazon.jsii.JsiiSerializable {

    /**
     * Apply the extension to the given TaskDefinition.
     * <p>
     * @param taskDefinition [disable-awslint:ref-via-interface]. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    void extend(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.TaskDefinition taskDefinition);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ecs.ITaskDefinitionExtension {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * Apply the extension to the given TaskDefinition.
         * <p>
         * @param taskDefinition [disable-awslint:ref-via-interface]. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public void extend(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.TaskDefinition taskDefinition) {
            this.jsiiCall("extend", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(taskDefinition, "taskDefinition is required") });
        }
    }
}
