package software.amazon.awscdk.services.ecs;

/**
 * The options for firelens log router https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_firelens.html#firelens-taskdef-customconfig.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:33.022Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ecs.$Module.class, fqn = "@aws-cdk/aws-ecs.FirelensOptions")
@software.amazon.jsii.Jsii.Proxy(FirelensOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface FirelensOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * Custom configuration file, S3 ARN or a file path.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getConfigFileValue();

    /**
     * Custom configuration file, s3 or file.
     * <p>
     * Default: - determined by checking configFileValue with S3 ARN.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.FirelensConfigFileType getConfigFileType() {
        return null;
    }

    /**
     * By default, Amazon ECS adds additional fields in your log entries that help identify the source of the logs.
     * <p>
     * You can disable this action by setting enable-ecs-log-metadata to false.
     * <p>
     * Default: - true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnableEcsLogMetadata() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link FirelensOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link FirelensOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<FirelensOptions> {
        private java.lang.String configFileValue;
        private software.amazon.awscdk.services.ecs.FirelensConfigFileType configFileType;
        private java.lang.Boolean enableEcsLogMetadata;

        /**
         * Sets the value of {@link FirelensOptions#getConfigFileValue}
         * @param configFileValue Custom configuration file, S3 ARN or a file path. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configFileValue(java.lang.String configFileValue) {
            this.configFileValue = configFileValue;
            return this;
        }

        /**
         * Sets the value of {@link FirelensOptions#getConfigFileType}
         * @param configFileType Custom configuration file, s3 or file.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configFileType(software.amazon.awscdk.services.ecs.FirelensConfigFileType configFileType) {
            this.configFileType = configFileType;
            return this;
        }

        /**
         * Sets the value of {@link FirelensOptions#getEnableEcsLogMetadata}
         * @param enableEcsLogMetadata By default, Amazon ECS adds additional fields in your log entries that help identify the source of the logs.
         *                             You can disable this action by setting enable-ecs-log-metadata to false.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableEcsLogMetadata(java.lang.Boolean enableEcsLogMetadata) {
            this.enableEcsLogMetadata = enableEcsLogMetadata;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link FirelensOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public FirelensOptions build() {
            return new Jsii$Proxy(configFileValue, configFileType, enableEcsLogMetadata);
        }
    }

    /**
     * An implementation for {@link FirelensOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FirelensOptions {
        private final java.lang.String configFileValue;
        private final software.amazon.awscdk.services.ecs.FirelensConfigFileType configFileType;
        private final java.lang.Boolean enableEcsLogMetadata;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.configFileValue = this.jsiiGet("configFileValue", java.lang.String.class);
            this.configFileType = this.jsiiGet("configFileType", software.amazon.awscdk.services.ecs.FirelensConfigFileType.class);
            this.enableEcsLogMetadata = this.jsiiGet("enableECSLogMetadata", java.lang.Boolean.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String configFileValue, final software.amazon.awscdk.services.ecs.FirelensConfigFileType configFileType, final java.lang.Boolean enableEcsLogMetadata) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.configFileValue = java.util.Objects.requireNonNull(configFileValue, "configFileValue is required");
            this.configFileType = configFileType;
            this.enableEcsLogMetadata = enableEcsLogMetadata;
        }

        @Override
        public java.lang.String getConfigFileValue() {
            return this.configFileValue;
        }

        @Override
        public software.amazon.awscdk.services.ecs.FirelensConfigFileType getConfigFileType() {
            return this.configFileType;
        }

        @Override
        public java.lang.Boolean getEnableEcsLogMetadata() {
            return this.enableEcsLogMetadata;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("configFileValue", om.valueToTree(this.getConfigFileValue()));
            if (this.getConfigFileType() != null) {
                data.set("configFileType", om.valueToTree(this.getConfigFileType()));
            }
            if (this.getEnableEcsLogMetadata() != null) {
                data.set("enableECSLogMetadata", om.valueToTree(this.getEnableEcsLogMetadata()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ecs.FirelensOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            FirelensOptions.Jsii$Proxy that = (FirelensOptions.Jsii$Proxy) o;

            if (!configFileValue.equals(that.configFileValue)) return false;
            if (this.configFileType != null ? !this.configFileType.equals(that.configFileType) : that.configFileType != null) return false;
            return this.enableEcsLogMetadata != null ? this.enableEcsLogMetadata.equals(that.enableEcsLogMetadata) : that.enableEcsLogMetadata == null;
        }

        @Override
        public int hashCode() {
            int result = this.configFileValue.hashCode();
            result = 31 * result + (this.configFileType != null ? this.configFileType.hashCode() : 0);
            result = 31 * result + (this.enableEcsLogMetadata != null ? this.enableEcsLogMetadata.hashCode() : 0);
            return result;
        }
    }
}
