package software.amazon.awscdk.services.ecs;

/**
 * The options for creating a firelens log router.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:33.010Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ecs.$Module.class, fqn = "@aws-cdk/aws-ecs.FirelensLogRouterDefinitionOptions")
@software.amazon.jsii.Jsii.Proxy(FirelensLogRouterDefinitionOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface FirelensLogRouterDefinitionOptions extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.ecs.ContainerDefinitionOptions {

    /**
     * Firelens configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.FirelensConfig getFirelensConfig();

    /**
     * @return a {@link Builder} of {@link FirelensLogRouterDefinitionOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link FirelensLogRouterDefinitionOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<FirelensLogRouterDefinitionOptions> {
        private software.amazon.awscdk.services.ecs.FirelensConfig firelensConfig;
        private software.amazon.awscdk.services.ecs.ContainerImage image;
        private java.util.List<java.lang.String> command;
        private java.lang.Number cpu;
        private java.lang.Boolean disableNetworking;
        private java.util.List<java.lang.String> dnsSearchDomains;
        private java.util.List<java.lang.String> dnsServers;
        private java.util.Map<java.lang.String, java.lang.String> dockerLabels;
        private java.util.List<java.lang.String> dockerSecurityOptions;
        private java.util.List<java.lang.String> entryPoint;
        private java.util.Map<java.lang.String, java.lang.String> environment;
        private java.lang.Boolean essential;
        private java.util.Map<java.lang.String, java.lang.String> extraHosts;
        private java.lang.Number gpuCount;
        private software.amazon.awscdk.services.ecs.HealthCheck healthCheck;
        private java.lang.String hostname;
        private software.amazon.awscdk.services.ecs.LinuxParameters linuxParameters;
        private software.amazon.awscdk.services.ecs.LogDriver logging;
        private java.lang.Number memoryLimitMiB;
        private java.lang.Number memoryReservationMiB;
        private java.lang.Boolean privileged;
        private java.lang.Boolean readonlyRootFilesystem;
        private java.util.Map<java.lang.String, software.amazon.awscdk.services.ecs.Secret> secrets;
        private software.amazon.awscdk.core.Duration startTimeout;
        private software.amazon.awscdk.core.Duration stopTimeout;
        private java.lang.String user;
        private java.lang.String workingDirectory;

        /**
         * Sets the value of {@link FirelensLogRouterDefinitionOptions#getFirelensConfig}
         * @param firelensConfig Firelens configuration. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder firelensConfig(software.amazon.awscdk.services.ecs.FirelensConfig firelensConfig) {
            this.firelensConfig = firelensConfig;
            return this;
        }

        /**
         * Sets the value of {@link FirelensLogRouterDefinitionOptions#getImage}
         * @param image The image used to start a container. This parameter is required.
         *              This string is passed directly to the Docker daemon.
         *              Images in the Docker Hub registry are available by default.
         *              Other repositories are specified with either repository-url/image:tag or repository-url/image&#64;digest.
         *              TODO: Update these to specify using classes of IContainerImage
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder image(software.amazon.awscdk.services.ecs.ContainerImage image) {
            this.image = image;
            return this;
        }

        /**
         * Sets the value of {@link FirelensLogRouterDefinitionOptions#getCommand}
         * @param command The command that is passed to the container.
         *                If you provide a shell command as a single string, you have to quote command-line arguments.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder command(java.util.List<java.lang.String> command) {
            this.command = command;
            return this;
        }

        /**
         * Sets the value of {@link FirelensLogRouterDefinitionOptions#getCpu}
         * @param cpu The minimum number of CPU units to reserve for the container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cpu(java.lang.Number cpu) {
            this.cpu = cpu;
            return this;
        }

        /**
         * Sets the value of {@link FirelensLogRouterDefinitionOptions#getDisableNetworking}
         * @param disableNetworking Specifies whether networking is disabled within the container.
         *                          When this parameter is true, networking is disabled within the container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder disableNetworking(java.lang.Boolean disableNetworking) {
            this.disableNetworking = disableNetworking;
            return this;
        }

        /**
         * Sets the value of {@link FirelensLogRouterDefinitionOptions#getDnsSearchDomains}
         * @param dnsSearchDomains A list of DNS search domains that are presented to the container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dnsSearchDomains(java.util.List<java.lang.String> dnsSearchDomains) {
            this.dnsSearchDomains = dnsSearchDomains;
            return this;
        }

        /**
         * Sets the value of {@link FirelensLogRouterDefinitionOptions#getDnsServers}
         * @param dnsServers A list of DNS servers that are presented to the container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dnsServers(java.util.List<java.lang.String> dnsServers) {
            this.dnsServers = dnsServers;
            return this;
        }

        /**
         * Sets the value of {@link FirelensLogRouterDefinitionOptions#getDockerLabels}
         * @param dockerLabels A key/value map of labels to add to the container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dockerLabels(java.util.Map<java.lang.String, java.lang.String> dockerLabels) {
            this.dockerLabels = dockerLabels;
            return this;
        }

        /**
         * Sets the value of {@link FirelensLogRouterDefinitionOptions#getDockerSecurityOptions}
         * @param dockerSecurityOptions A list of strings to provide custom labels for SELinux and AppArmor multi-level security systems.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dockerSecurityOptions(java.util.List<java.lang.String> dockerSecurityOptions) {
            this.dockerSecurityOptions = dockerSecurityOptions;
            return this;
        }

        /**
         * Sets the value of {@link FirelensLogRouterDefinitionOptions#getEntryPoint}
         * @param entryPoint The ENTRYPOINT value to pass to the container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder entryPoint(java.util.List<java.lang.String> entryPoint) {
            this.entryPoint = entryPoint;
            return this;
        }

        /**
         * Sets the value of {@link FirelensLogRouterDefinitionOptions#getEnvironment}
         * @param environment The environment variables to pass to the container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environment(java.util.Map<java.lang.String, java.lang.String> environment) {
            this.environment = environment;
            return this;
        }

        /**
         * Sets the value of {@link FirelensLogRouterDefinitionOptions#getEssential}
         * @param essential Specifies whether the container is marked essential.
         *                  If the essential parameter of a container is marked as true, and that container fails
         *                  or stops for any reason, all other containers that are part of the task are stopped.
         *                  If the essential parameter of a container is marked as false, then its failure does not
         *                  affect the rest of the containers in a task. All tasks must have at least one essential container.
         *                  <p>
         *                  If this parameter is omitted, a container is assumed to be essential.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder essential(java.lang.Boolean essential) {
            this.essential = essential;
            return this;
        }

        /**
         * Sets the value of {@link FirelensLogRouterDefinitionOptions#getExtraHosts}
         * @param extraHosts A list of hostnames and IP address mappings to append to the /etc/hosts file on the container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder extraHosts(java.util.Map<java.lang.String, java.lang.String> extraHosts) {
            this.extraHosts = extraHosts;
            return this;
        }

        /**
         * Sets the value of {@link FirelensLogRouterDefinitionOptions#getGpuCount}
         * @param gpuCount The number of GPUs assigned to the container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder gpuCount(java.lang.Number gpuCount) {
            this.gpuCount = gpuCount;
            return this;
        }

        /**
         * Sets the value of {@link FirelensLogRouterDefinitionOptions#getHealthCheck}
         * @param healthCheck The health check command and associated configuration parameters for the container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthCheck(software.amazon.awscdk.services.ecs.HealthCheck healthCheck) {
            this.healthCheck = healthCheck;
            return this;
        }

        /**
         * Sets the value of {@link FirelensLogRouterDefinitionOptions#getHostname}
         * @param hostname The hostname to use for your container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostname(java.lang.String hostname) {
            this.hostname = hostname;
            return this;
        }

        /**
         * Sets the value of {@link FirelensLogRouterDefinitionOptions#getLinuxParameters}
         * @param linuxParameters Linux-specific modifications that are applied to the container, such as Linux kernel capabilities.
         *                        For more information see <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_KernelCapabilities.html">KernelCapabilities</a>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder linuxParameters(software.amazon.awscdk.services.ecs.LinuxParameters linuxParameters) {
            this.linuxParameters = linuxParameters;
            return this;
        }

        /**
         * Sets the value of {@link FirelensLogRouterDefinitionOptions#getLogging}
         * @param logging The log configuration specification for the container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logging(software.amazon.awscdk.services.ecs.LogDriver logging) {
            this.logging = logging;
            return this;
        }

        /**
         * Sets the value of {@link FirelensLogRouterDefinitionOptions#getMemoryLimitMiB}
         * @param memoryLimitMiB The amount (in MiB) of memory to present to the container.
         *                       If your container attempts to exceed the allocated memory, the container
         *                       is terminated.
         *                       <p>
         *                       At least one of memoryLimitMiB and memoryReservationMiB is required for non-Fargate services.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder memoryLimitMiB(java.lang.Number memoryLimitMiB) {
            this.memoryLimitMiB = memoryLimitMiB;
            return this;
        }

        /**
         * Sets the value of {@link FirelensLogRouterDefinitionOptions#getMemoryReservationMiB}
         * @param memoryReservationMiB The soft limit (in MiB) of memory to reserve for the container.
         *                             When system memory is under heavy contention, Docker attempts to keep the
         *                             container memory to this soft limit. However, your container can consume more
         *                             memory when it needs to, up to either the hard limit specified with the memory
         *                             parameter (if applicable), or all of the available memory on the container
         *                             instance, whichever comes first.
         *                             <p>
         *                             At least one of memoryLimitMiB and memoryReservationMiB is required for non-Fargate services.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder memoryReservationMiB(java.lang.Number memoryReservationMiB) {
            this.memoryReservationMiB = memoryReservationMiB;
            return this;
        }

        /**
         * Sets the value of {@link FirelensLogRouterDefinitionOptions#getPrivileged}
         * @param privileged Specifies whether the container is marked as privileged.
         *                   When this parameter is true, the container is given elevated privileges on the host container instance (similar to the root user).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder privileged(java.lang.Boolean privileged) {
            this.privileged = privileged;
            return this;
        }

        /**
         * Sets the value of {@link FirelensLogRouterDefinitionOptions#getReadonlyRootFilesystem}
         * @param readonlyRootFilesystem When this parameter is true, the container is given read-only access to its root file system.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder readonlyRootFilesystem(java.lang.Boolean readonlyRootFilesystem) {
            this.readonlyRootFilesystem = readonlyRootFilesystem;
            return this;
        }

        /**
         * Sets the value of {@link FirelensLogRouterDefinitionOptions#getSecrets}
         * @param secrets The secret environment variables to pass to the container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder secrets(java.util.Map<java.lang.String, software.amazon.awscdk.services.ecs.Secret> secrets) {
            this.secrets = secrets;
            return this;
        }

        /**
         * Sets the value of {@link FirelensLogRouterDefinitionOptions#getStartTimeout}
         * @param startTimeout Time duration (in seconds) to wait before giving up on resolving dependencies for a container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder startTimeout(software.amazon.awscdk.core.Duration startTimeout) {
            this.startTimeout = startTimeout;
            return this;
        }

        /**
         * Sets the value of {@link FirelensLogRouterDefinitionOptions#getStopTimeout}
         * @param stopTimeout Time duration (in seconds) to wait before the container is forcefully killed if it doesn't exit normally on its own.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stopTimeout(software.amazon.awscdk.core.Duration stopTimeout) {
            this.stopTimeout = stopTimeout;
            return this;
        }

        /**
         * Sets the value of {@link FirelensLogRouterDefinitionOptions#getUser}
         * @param user The user name to use inside the container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder user(java.lang.String user) {
            this.user = user;
            return this;
        }

        /**
         * Sets the value of {@link FirelensLogRouterDefinitionOptions#getWorkingDirectory}
         * @param workingDirectory The working directory in which to run commands inside the container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder workingDirectory(java.lang.String workingDirectory) {
            this.workingDirectory = workingDirectory;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link FirelensLogRouterDefinitionOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public FirelensLogRouterDefinitionOptions build() {
            return new Jsii$Proxy(firelensConfig, image, command, cpu, disableNetworking, dnsSearchDomains, dnsServers, dockerLabels, dockerSecurityOptions, entryPoint, environment, essential, extraHosts, gpuCount, healthCheck, hostname, linuxParameters, logging, memoryLimitMiB, memoryReservationMiB, privileged, readonlyRootFilesystem, secrets, startTimeout, stopTimeout, user, workingDirectory);
        }
    }

    /**
     * An implementation for {@link FirelensLogRouterDefinitionOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FirelensLogRouterDefinitionOptions {
        private final software.amazon.awscdk.services.ecs.FirelensConfig firelensConfig;
        private final software.amazon.awscdk.services.ecs.ContainerImage image;
        private final java.util.List<java.lang.String> command;
        private final java.lang.Number cpu;
        private final java.lang.Boolean disableNetworking;
        private final java.util.List<java.lang.String> dnsSearchDomains;
        private final java.util.List<java.lang.String> dnsServers;
        private final java.util.Map<java.lang.String, java.lang.String> dockerLabels;
        private final java.util.List<java.lang.String> dockerSecurityOptions;
        private final java.util.List<java.lang.String> entryPoint;
        private final java.util.Map<java.lang.String, java.lang.String> environment;
        private final java.lang.Boolean essential;
        private final java.util.Map<java.lang.String, java.lang.String> extraHosts;
        private final java.lang.Number gpuCount;
        private final software.amazon.awscdk.services.ecs.HealthCheck healthCheck;
        private final java.lang.String hostname;
        private final software.amazon.awscdk.services.ecs.LinuxParameters linuxParameters;
        private final software.amazon.awscdk.services.ecs.LogDriver logging;
        private final java.lang.Number memoryLimitMiB;
        private final java.lang.Number memoryReservationMiB;
        private final java.lang.Boolean privileged;
        private final java.lang.Boolean readonlyRootFilesystem;
        private final java.util.Map<java.lang.String, software.amazon.awscdk.services.ecs.Secret> secrets;
        private final software.amazon.awscdk.core.Duration startTimeout;
        private final software.amazon.awscdk.core.Duration stopTimeout;
        private final java.lang.String user;
        private final java.lang.String workingDirectory;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.firelensConfig = this.jsiiGet("firelensConfig", software.amazon.awscdk.services.ecs.FirelensConfig.class);
            this.image = this.jsiiGet("image", software.amazon.awscdk.services.ecs.ContainerImage.class);
            this.command = this.jsiiGet("command", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.cpu = this.jsiiGet("cpu", java.lang.Number.class);
            this.disableNetworking = this.jsiiGet("disableNetworking", java.lang.Boolean.class);
            this.dnsSearchDomains = this.jsiiGet("dnsSearchDomains", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.dnsServers = this.jsiiGet("dnsServers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.dockerLabels = this.jsiiGet("dockerLabels", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.dockerSecurityOptions = this.jsiiGet("dockerSecurityOptions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.entryPoint = this.jsiiGet("entryPoint", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.environment = this.jsiiGet("environment", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.essential = this.jsiiGet("essential", java.lang.Boolean.class);
            this.extraHosts = this.jsiiGet("extraHosts", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.gpuCount = this.jsiiGet("gpuCount", java.lang.Number.class);
            this.healthCheck = this.jsiiGet("healthCheck", software.amazon.awscdk.services.ecs.HealthCheck.class);
            this.hostname = this.jsiiGet("hostname", java.lang.String.class);
            this.linuxParameters = this.jsiiGet("linuxParameters", software.amazon.awscdk.services.ecs.LinuxParameters.class);
            this.logging = this.jsiiGet("logging", software.amazon.awscdk.services.ecs.LogDriver.class);
            this.memoryLimitMiB = this.jsiiGet("memoryLimitMiB", java.lang.Number.class);
            this.memoryReservationMiB = this.jsiiGet("memoryReservationMiB", java.lang.Number.class);
            this.privileged = this.jsiiGet("privileged", java.lang.Boolean.class);
            this.readonlyRootFilesystem = this.jsiiGet("readonlyRootFilesystem", java.lang.Boolean.class);
            this.secrets = this.jsiiGet("secrets", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.Secret.class)));
            this.startTimeout = this.jsiiGet("startTimeout", software.amazon.awscdk.core.Duration.class);
            this.stopTimeout = this.jsiiGet("stopTimeout", software.amazon.awscdk.core.Duration.class);
            this.user = this.jsiiGet("user", java.lang.String.class);
            this.workingDirectory = this.jsiiGet("workingDirectory", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.services.ecs.FirelensConfig firelensConfig, final software.amazon.awscdk.services.ecs.ContainerImage image, final java.util.List<java.lang.String> command, final java.lang.Number cpu, final java.lang.Boolean disableNetworking, final java.util.List<java.lang.String> dnsSearchDomains, final java.util.List<java.lang.String> dnsServers, final java.util.Map<java.lang.String, java.lang.String> dockerLabels, final java.util.List<java.lang.String> dockerSecurityOptions, final java.util.List<java.lang.String> entryPoint, final java.util.Map<java.lang.String, java.lang.String> environment, final java.lang.Boolean essential, final java.util.Map<java.lang.String, java.lang.String> extraHosts, final java.lang.Number gpuCount, final software.amazon.awscdk.services.ecs.HealthCheck healthCheck, final java.lang.String hostname, final software.amazon.awscdk.services.ecs.LinuxParameters linuxParameters, final software.amazon.awscdk.services.ecs.LogDriver logging, final java.lang.Number memoryLimitMiB, final java.lang.Number memoryReservationMiB, final java.lang.Boolean privileged, final java.lang.Boolean readonlyRootFilesystem, final java.util.Map<java.lang.String, software.amazon.awscdk.services.ecs.Secret> secrets, final software.amazon.awscdk.core.Duration startTimeout, final software.amazon.awscdk.core.Duration stopTimeout, final java.lang.String user, final java.lang.String workingDirectory) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.firelensConfig = java.util.Objects.requireNonNull(firelensConfig, "firelensConfig is required");
            this.image = java.util.Objects.requireNonNull(image, "image is required");
            this.command = command;
            this.cpu = cpu;
            this.disableNetworking = disableNetworking;
            this.dnsSearchDomains = dnsSearchDomains;
            this.dnsServers = dnsServers;
            this.dockerLabels = dockerLabels;
            this.dockerSecurityOptions = dockerSecurityOptions;
            this.entryPoint = entryPoint;
            this.environment = environment;
            this.essential = essential;
            this.extraHosts = extraHosts;
            this.gpuCount = gpuCount;
            this.healthCheck = healthCheck;
            this.hostname = hostname;
            this.linuxParameters = linuxParameters;
            this.logging = logging;
            this.memoryLimitMiB = memoryLimitMiB;
            this.memoryReservationMiB = memoryReservationMiB;
            this.privileged = privileged;
            this.readonlyRootFilesystem = readonlyRootFilesystem;
            this.secrets = secrets;
            this.startTimeout = startTimeout;
            this.stopTimeout = stopTimeout;
            this.user = user;
            this.workingDirectory = workingDirectory;
        }

        @Override
        public software.amazon.awscdk.services.ecs.FirelensConfig getFirelensConfig() {
            return this.firelensConfig;
        }

        @Override
        public software.amazon.awscdk.services.ecs.ContainerImage getImage() {
            return this.image;
        }

        @Override
        public java.util.List<java.lang.String> getCommand() {
            return this.command;
        }

        @Override
        public java.lang.Number getCpu() {
            return this.cpu;
        }

        @Override
        public java.lang.Boolean getDisableNetworking() {
            return this.disableNetworking;
        }

        @Override
        public java.util.List<java.lang.String> getDnsSearchDomains() {
            return this.dnsSearchDomains;
        }

        @Override
        public java.util.List<java.lang.String> getDnsServers() {
            return this.dnsServers;
        }

        @Override
        public java.util.Map<java.lang.String, java.lang.String> getDockerLabels() {
            return this.dockerLabels;
        }

        @Override
        public java.util.List<java.lang.String> getDockerSecurityOptions() {
            return this.dockerSecurityOptions;
        }

        @Override
        public java.util.List<java.lang.String> getEntryPoint() {
            return this.entryPoint;
        }

        @Override
        public java.util.Map<java.lang.String, java.lang.String> getEnvironment() {
            return this.environment;
        }

        @Override
        public java.lang.Boolean getEssential() {
            return this.essential;
        }

        @Override
        public java.util.Map<java.lang.String, java.lang.String> getExtraHosts() {
            return this.extraHosts;
        }

        @Override
        public java.lang.Number getGpuCount() {
            return this.gpuCount;
        }

        @Override
        public software.amazon.awscdk.services.ecs.HealthCheck getHealthCheck() {
            return this.healthCheck;
        }

        @Override
        public java.lang.String getHostname() {
            return this.hostname;
        }

        @Override
        public software.amazon.awscdk.services.ecs.LinuxParameters getLinuxParameters() {
            return this.linuxParameters;
        }

        @Override
        public software.amazon.awscdk.services.ecs.LogDriver getLogging() {
            return this.logging;
        }

        @Override
        public java.lang.Number getMemoryLimitMiB() {
            return this.memoryLimitMiB;
        }

        @Override
        public java.lang.Number getMemoryReservationMiB() {
            return this.memoryReservationMiB;
        }

        @Override
        public java.lang.Boolean getPrivileged() {
            return this.privileged;
        }

        @Override
        public java.lang.Boolean getReadonlyRootFilesystem() {
            return this.readonlyRootFilesystem;
        }

        @Override
        public java.util.Map<java.lang.String, software.amazon.awscdk.services.ecs.Secret> getSecrets() {
            return this.secrets;
        }

        @Override
        public software.amazon.awscdk.core.Duration getStartTimeout() {
            return this.startTimeout;
        }

        @Override
        public software.amazon.awscdk.core.Duration getStopTimeout() {
            return this.stopTimeout;
        }

        @Override
        public java.lang.String getUser() {
            return this.user;
        }

        @Override
        public java.lang.String getWorkingDirectory() {
            return this.workingDirectory;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("firelensConfig", om.valueToTree(this.getFirelensConfig()));
            data.set("image", om.valueToTree(this.getImage()));
            if (this.getCommand() != null) {
                data.set("command", om.valueToTree(this.getCommand()));
            }
            if (this.getCpu() != null) {
                data.set("cpu", om.valueToTree(this.getCpu()));
            }
            if (this.getDisableNetworking() != null) {
                data.set("disableNetworking", om.valueToTree(this.getDisableNetworking()));
            }
            if (this.getDnsSearchDomains() != null) {
                data.set("dnsSearchDomains", om.valueToTree(this.getDnsSearchDomains()));
            }
            if (this.getDnsServers() != null) {
                data.set("dnsServers", om.valueToTree(this.getDnsServers()));
            }
            if (this.getDockerLabels() != null) {
                data.set("dockerLabels", om.valueToTree(this.getDockerLabels()));
            }
            if (this.getDockerSecurityOptions() != null) {
                data.set("dockerSecurityOptions", om.valueToTree(this.getDockerSecurityOptions()));
            }
            if (this.getEntryPoint() != null) {
                data.set("entryPoint", om.valueToTree(this.getEntryPoint()));
            }
            if (this.getEnvironment() != null) {
                data.set("environment", om.valueToTree(this.getEnvironment()));
            }
            if (this.getEssential() != null) {
                data.set("essential", om.valueToTree(this.getEssential()));
            }
            if (this.getExtraHosts() != null) {
                data.set("extraHosts", om.valueToTree(this.getExtraHosts()));
            }
            if (this.getGpuCount() != null) {
                data.set("gpuCount", om.valueToTree(this.getGpuCount()));
            }
            if (this.getHealthCheck() != null) {
                data.set("healthCheck", om.valueToTree(this.getHealthCheck()));
            }
            if (this.getHostname() != null) {
                data.set("hostname", om.valueToTree(this.getHostname()));
            }
            if (this.getLinuxParameters() != null) {
                data.set("linuxParameters", om.valueToTree(this.getLinuxParameters()));
            }
            if (this.getLogging() != null) {
                data.set("logging", om.valueToTree(this.getLogging()));
            }
            if (this.getMemoryLimitMiB() != null) {
                data.set("memoryLimitMiB", om.valueToTree(this.getMemoryLimitMiB()));
            }
            if (this.getMemoryReservationMiB() != null) {
                data.set("memoryReservationMiB", om.valueToTree(this.getMemoryReservationMiB()));
            }
            if (this.getPrivileged() != null) {
                data.set("privileged", om.valueToTree(this.getPrivileged()));
            }
            if (this.getReadonlyRootFilesystem() != null) {
                data.set("readonlyRootFilesystem", om.valueToTree(this.getReadonlyRootFilesystem()));
            }
            if (this.getSecrets() != null) {
                data.set("secrets", om.valueToTree(this.getSecrets()));
            }
            if (this.getStartTimeout() != null) {
                data.set("startTimeout", om.valueToTree(this.getStartTimeout()));
            }
            if (this.getStopTimeout() != null) {
                data.set("stopTimeout", om.valueToTree(this.getStopTimeout()));
            }
            if (this.getUser() != null) {
                data.set("user", om.valueToTree(this.getUser()));
            }
            if (this.getWorkingDirectory() != null) {
                data.set("workingDirectory", om.valueToTree(this.getWorkingDirectory()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ecs.FirelensLogRouterDefinitionOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            FirelensLogRouterDefinitionOptions.Jsii$Proxy that = (FirelensLogRouterDefinitionOptions.Jsii$Proxy) o;

            if (!firelensConfig.equals(that.firelensConfig)) return false;
            if (!image.equals(that.image)) return false;
            if (this.command != null ? !this.command.equals(that.command) : that.command != null) return false;
            if (this.cpu != null ? !this.cpu.equals(that.cpu) : that.cpu != null) return false;
            if (this.disableNetworking != null ? !this.disableNetworking.equals(that.disableNetworking) : that.disableNetworking != null) return false;
            if (this.dnsSearchDomains != null ? !this.dnsSearchDomains.equals(that.dnsSearchDomains) : that.dnsSearchDomains != null) return false;
            if (this.dnsServers != null ? !this.dnsServers.equals(that.dnsServers) : that.dnsServers != null) return false;
            if (this.dockerLabels != null ? !this.dockerLabels.equals(that.dockerLabels) : that.dockerLabels != null) return false;
            if (this.dockerSecurityOptions != null ? !this.dockerSecurityOptions.equals(that.dockerSecurityOptions) : that.dockerSecurityOptions != null) return false;
            if (this.entryPoint != null ? !this.entryPoint.equals(that.entryPoint) : that.entryPoint != null) return false;
            if (this.environment != null ? !this.environment.equals(that.environment) : that.environment != null) return false;
            if (this.essential != null ? !this.essential.equals(that.essential) : that.essential != null) return false;
            if (this.extraHosts != null ? !this.extraHosts.equals(that.extraHosts) : that.extraHosts != null) return false;
            if (this.gpuCount != null ? !this.gpuCount.equals(that.gpuCount) : that.gpuCount != null) return false;
            if (this.healthCheck != null ? !this.healthCheck.equals(that.healthCheck) : that.healthCheck != null) return false;
            if (this.hostname != null ? !this.hostname.equals(that.hostname) : that.hostname != null) return false;
            if (this.linuxParameters != null ? !this.linuxParameters.equals(that.linuxParameters) : that.linuxParameters != null) return false;
            if (this.logging != null ? !this.logging.equals(that.logging) : that.logging != null) return false;
            if (this.memoryLimitMiB != null ? !this.memoryLimitMiB.equals(that.memoryLimitMiB) : that.memoryLimitMiB != null) return false;
            if (this.memoryReservationMiB != null ? !this.memoryReservationMiB.equals(that.memoryReservationMiB) : that.memoryReservationMiB != null) return false;
            if (this.privileged != null ? !this.privileged.equals(that.privileged) : that.privileged != null) return false;
            if (this.readonlyRootFilesystem != null ? !this.readonlyRootFilesystem.equals(that.readonlyRootFilesystem) : that.readonlyRootFilesystem != null) return false;
            if (this.secrets != null ? !this.secrets.equals(that.secrets) : that.secrets != null) return false;
            if (this.startTimeout != null ? !this.startTimeout.equals(that.startTimeout) : that.startTimeout != null) return false;
            if (this.stopTimeout != null ? !this.stopTimeout.equals(that.stopTimeout) : that.stopTimeout != null) return false;
            if (this.user != null ? !this.user.equals(that.user) : that.user != null) return false;
            return this.workingDirectory != null ? this.workingDirectory.equals(that.workingDirectory) : that.workingDirectory == null;
        }

        @Override
        public int hashCode() {
            int result = this.firelensConfig.hashCode();
            result = 31 * result + (this.image.hashCode());
            result = 31 * result + (this.command != null ? this.command.hashCode() : 0);
            result = 31 * result + (this.cpu != null ? this.cpu.hashCode() : 0);
            result = 31 * result + (this.disableNetworking != null ? this.disableNetworking.hashCode() : 0);
            result = 31 * result + (this.dnsSearchDomains != null ? this.dnsSearchDomains.hashCode() : 0);
            result = 31 * result + (this.dnsServers != null ? this.dnsServers.hashCode() : 0);
            result = 31 * result + (this.dockerLabels != null ? this.dockerLabels.hashCode() : 0);
            result = 31 * result + (this.dockerSecurityOptions != null ? this.dockerSecurityOptions.hashCode() : 0);
            result = 31 * result + (this.entryPoint != null ? this.entryPoint.hashCode() : 0);
            result = 31 * result + (this.environment != null ? this.environment.hashCode() : 0);
            result = 31 * result + (this.essential != null ? this.essential.hashCode() : 0);
            result = 31 * result + (this.extraHosts != null ? this.extraHosts.hashCode() : 0);
            result = 31 * result + (this.gpuCount != null ? this.gpuCount.hashCode() : 0);
            result = 31 * result + (this.healthCheck != null ? this.healthCheck.hashCode() : 0);
            result = 31 * result + (this.hostname != null ? this.hostname.hashCode() : 0);
            result = 31 * result + (this.linuxParameters != null ? this.linuxParameters.hashCode() : 0);
            result = 31 * result + (this.logging != null ? this.logging.hashCode() : 0);
            result = 31 * result + (this.memoryLimitMiB != null ? this.memoryLimitMiB.hashCode() : 0);
            result = 31 * result + (this.memoryReservationMiB != null ? this.memoryReservationMiB.hashCode() : 0);
            result = 31 * result + (this.privileged != null ? this.privileged.hashCode() : 0);
            result = 31 * result + (this.readonlyRootFilesystem != null ? this.readonlyRootFilesystem.hashCode() : 0);
            result = 31 * result + (this.secrets != null ? this.secrets.hashCode() : 0);
            result = 31 * result + (this.startTimeout != null ? this.startTimeout.hashCode() : 0);
            result = 31 * result + (this.stopTimeout != null ? this.stopTimeout.hashCode() : 0);
            result = 31 * result + (this.user != null ? this.user.hashCode() : 0);
            result = 31 * result + (this.workingDirectory != null ? this.workingDirectory.hashCode() : 0);
            return result;
        }
    }
}
