package software.amazon.awscdk.services.ecs;

/**
 * Firelens Configuration https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_firelens.html#firelens-taskdef.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:33.008Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ecs.$Module.class, fqn = "@aws-cdk/aws-ecs.FirelensConfig")
@software.amazon.jsii.Jsii.Proxy(FirelensConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface FirelensConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * The log router to use.
     * <p>
     * Default: - fluentbit
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.FirelensLogRouterType getType();

    /**
     * Firelens options.
     * <p>
     * Default: - no additional options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.FirelensOptions getOptions() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link FirelensConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link FirelensConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<FirelensConfig> {
        private software.amazon.awscdk.services.ecs.FirelensLogRouterType type;
        private software.amazon.awscdk.services.ecs.FirelensOptions options;

        /**
         * Sets the value of {@link FirelensConfig#getType}
         * @param type The log router to use. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(software.amazon.awscdk.services.ecs.FirelensLogRouterType type) {
            this.type = type;
            return this;
        }

        /**
         * Sets the value of {@link FirelensConfig#getOptions}
         * @param options Firelens options.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder options(software.amazon.awscdk.services.ecs.FirelensOptions options) {
            this.options = options;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link FirelensConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public FirelensConfig build() {
            return new Jsii$Proxy(type, options);
        }
    }

    /**
     * An implementation for {@link FirelensConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FirelensConfig {
        private final software.amazon.awscdk.services.ecs.FirelensLogRouterType type;
        private final software.amazon.awscdk.services.ecs.FirelensOptions options;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.type = this.jsiiGet("type", software.amazon.awscdk.services.ecs.FirelensLogRouterType.class);
            this.options = this.jsiiGet("options", software.amazon.awscdk.services.ecs.FirelensOptions.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.services.ecs.FirelensLogRouterType type, final software.amazon.awscdk.services.ecs.FirelensOptions options) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.type = java.util.Objects.requireNonNull(type, "type is required");
            this.options = options;
        }

        @Override
        public software.amazon.awscdk.services.ecs.FirelensLogRouterType getType() {
            return this.type;
        }

        @Override
        public software.amazon.awscdk.services.ecs.FirelensOptions getOptions() {
            return this.options;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("type", om.valueToTree(this.getType()));
            if (this.getOptions() != null) {
                data.set("options", om.valueToTree(this.getOptions()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ecs.FirelensConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            FirelensConfig.Jsii$Proxy that = (FirelensConfig.Jsii$Proxy) o;

            if (!type.equals(that.type)) return false;
            return this.options != null ? this.options.equals(that.options) : that.options == null;
        }

        @Override
        public int hashCode() {
            int result = this.type.hashCode();
            result = 31 * result + (this.options != null ? this.options.hashCode() : 0);
            return result;
        }
    }
}
