package software.amazon.awscdk.services.ecs;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:33.004Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ecs.$Module.class, fqn = "@aws-cdk/aws-ecs.EcsTarget")
@software.amazon.jsii.Jsii.Proxy(EcsTarget.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface EcsTarget extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the container.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getContainerName();

    /**
     * Listener and properties for adding target group to the listener.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.ListenerConfig getListener();

    /**
     * ID for a target group to be created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getNewTargetGroupId();

    /**
     * The port number of the container.
     * <p>
     * Only applicable when using application/network load balancers.
     * <p>
     * Default: - Container port of the first added port mapping.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getContainerPort() {
        return null;
    }

    /**
     * The protocol used for the port mapping.
     * <p>
     * Only applicable when using application load balancers.
     * <p>
     * Default: Protocol.TCP
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.Protocol getProtocol() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link EcsTarget}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link EcsTarget}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<EcsTarget> {
        private java.lang.String containerName;
        private software.amazon.awscdk.services.ecs.ListenerConfig listener;
        private java.lang.String newTargetGroupId;
        private java.lang.Number containerPort;
        private software.amazon.awscdk.services.ecs.Protocol protocol;

        /**
         * Sets the value of {@link EcsTarget#getContainerName}
         * @param containerName The name of the container. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder containerName(java.lang.String containerName) {
            this.containerName = containerName;
            return this;
        }

        /**
         * Sets the value of {@link EcsTarget#getListener}
         * @param listener Listener and properties for adding target group to the listener. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder listener(software.amazon.awscdk.services.ecs.ListenerConfig listener) {
            this.listener = listener;
            return this;
        }

        /**
         * Sets the value of {@link EcsTarget#getNewTargetGroupId}
         * @param newTargetGroupId ID for a target group to be created. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder newTargetGroupId(java.lang.String newTargetGroupId) {
            this.newTargetGroupId = newTargetGroupId;
            return this;
        }

        /**
         * Sets the value of {@link EcsTarget#getContainerPort}
         * @param containerPort The port number of the container.
         *                      Only applicable when using application/network load balancers.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder containerPort(java.lang.Number containerPort) {
            this.containerPort = containerPort;
            return this;
        }

        /**
         * Sets the value of {@link EcsTarget#getProtocol}
         * @param protocol The protocol used for the port mapping.
         *                 Only applicable when using application load balancers.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protocol(software.amazon.awscdk.services.ecs.Protocol protocol) {
            this.protocol = protocol;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link EcsTarget}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public EcsTarget build() {
            return new Jsii$Proxy(containerName, listener, newTargetGroupId, containerPort, protocol);
        }
    }

    /**
     * An implementation for {@link EcsTarget}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EcsTarget {
        private final java.lang.String containerName;
        private final software.amazon.awscdk.services.ecs.ListenerConfig listener;
        private final java.lang.String newTargetGroupId;
        private final java.lang.Number containerPort;
        private final software.amazon.awscdk.services.ecs.Protocol protocol;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.containerName = this.jsiiGet("containerName", java.lang.String.class);
            this.listener = this.jsiiGet("listener", software.amazon.awscdk.services.ecs.ListenerConfig.class);
            this.newTargetGroupId = this.jsiiGet("newTargetGroupId", java.lang.String.class);
            this.containerPort = this.jsiiGet("containerPort", java.lang.Number.class);
            this.protocol = this.jsiiGet("protocol", software.amazon.awscdk.services.ecs.Protocol.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String containerName, final software.amazon.awscdk.services.ecs.ListenerConfig listener, final java.lang.String newTargetGroupId, final java.lang.Number containerPort, final software.amazon.awscdk.services.ecs.Protocol protocol) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.containerName = java.util.Objects.requireNonNull(containerName, "containerName is required");
            this.listener = java.util.Objects.requireNonNull(listener, "listener is required");
            this.newTargetGroupId = java.util.Objects.requireNonNull(newTargetGroupId, "newTargetGroupId is required");
            this.containerPort = containerPort;
            this.protocol = protocol;
        }

        @Override
        public java.lang.String getContainerName() {
            return this.containerName;
        }

        @Override
        public software.amazon.awscdk.services.ecs.ListenerConfig getListener() {
            return this.listener;
        }

        @Override
        public java.lang.String getNewTargetGroupId() {
            return this.newTargetGroupId;
        }

        @Override
        public java.lang.Number getContainerPort() {
            return this.containerPort;
        }

        @Override
        public software.amazon.awscdk.services.ecs.Protocol getProtocol() {
            return this.protocol;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("containerName", om.valueToTree(this.getContainerName()));
            data.set("listener", om.valueToTree(this.getListener()));
            data.set("newTargetGroupId", om.valueToTree(this.getNewTargetGroupId()));
            if (this.getContainerPort() != null) {
                data.set("containerPort", om.valueToTree(this.getContainerPort()));
            }
            if (this.getProtocol() != null) {
                data.set("protocol", om.valueToTree(this.getProtocol()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ecs.EcsTarget"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            EcsTarget.Jsii$Proxy that = (EcsTarget.Jsii$Proxy) o;

            if (!containerName.equals(that.containerName)) return false;
            if (!listener.equals(that.listener)) return false;
            if (!newTargetGroupId.equals(that.newTargetGroupId)) return false;
            if (this.containerPort != null ? !this.containerPort.equals(that.containerPort) : that.containerPort != null) return false;
            return this.protocol != null ? this.protocol.equals(that.protocol) : that.protocol == null;
        }

        @Override
        public int hashCode() {
            int result = this.containerName.hashCode();
            result = 31 * result + (this.listener.hashCode());
            result = 31 * result + (this.newTargetGroupId.hashCode());
            result = 31 * result + (this.containerPort != null ? this.containerPort.hashCode() : 0);
            result = 31 * result + (this.protocol != null ? this.protocol.hashCode() : 0);
            return result;
        }
    }
}
