package software.amazon.awscdk.services.ecs;

/**
 * The configuration for creating a container image.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:32.998Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ecs.$Module.class, fqn = "@aws-cdk/aws-ecs.ContainerImageConfig")
@software.amazon.jsii.Jsii.Proxy(ContainerImageConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ContainerImageConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * Specifies the name of the container image.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getImageName();

    /**
     * Specifies the credentials used to access the image repository.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.CfnTaskDefinition.RepositoryCredentialsProperty getRepositoryCredentials() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ContainerImageConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ContainerImageConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ContainerImageConfig> {
        private java.lang.String imageName;
        private software.amazon.awscdk.services.ecs.CfnTaskDefinition.RepositoryCredentialsProperty repositoryCredentials;

        /**
         * Sets the value of {@link ContainerImageConfig#getImageName}
         * @param imageName Specifies the name of the container image. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder imageName(java.lang.String imageName) {
            this.imageName = imageName;
            return this;
        }

        /**
         * Sets the value of {@link ContainerImageConfig#getRepositoryCredentials}
         * @param repositoryCredentials Specifies the credentials used to access the image repository.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder repositoryCredentials(software.amazon.awscdk.services.ecs.CfnTaskDefinition.RepositoryCredentialsProperty repositoryCredentials) {
            this.repositoryCredentials = repositoryCredentials;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ContainerImageConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ContainerImageConfig build() {
            return new Jsii$Proxy(imageName, repositoryCredentials);
        }
    }

    /**
     * An implementation for {@link ContainerImageConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ContainerImageConfig {
        private final java.lang.String imageName;
        private final software.amazon.awscdk.services.ecs.CfnTaskDefinition.RepositoryCredentialsProperty repositoryCredentials;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.imageName = this.jsiiGet("imageName", java.lang.String.class);
            this.repositoryCredentials = this.jsiiGet("repositoryCredentials", software.amazon.awscdk.services.ecs.CfnTaskDefinition.RepositoryCredentialsProperty.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String imageName, final software.amazon.awscdk.services.ecs.CfnTaskDefinition.RepositoryCredentialsProperty repositoryCredentials) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.imageName = java.util.Objects.requireNonNull(imageName, "imageName is required");
            this.repositoryCredentials = repositoryCredentials;
        }

        @Override
        public java.lang.String getImageName() {
            return this.imageName;
        }

        @Override
        public software.amazon.awscdk.services.ecs.CfnTaskDefinition.RepositoryCredentialsProperty getRepositoryCredentials() {
            return this.repositoryCredentials;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("imageName", om.valueToTree(this.getImageName()));
            if (this.getRepositoryCredentials() != null) {
                data.set("repositoryCredentials", om.valueToTree(this.getRepositoryCredentials()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ecs.ContainerImageConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ContainerImageConfig.Jsii$Proxy that = (ContainerImageConfig.Jsii$Proxy) o;

            if (!imageName.equals(that.imageName)) return false;
            return this.repositoryCredentials != null ? this.repositoryCredentials.equals(that.repositoryCredentials) : that.repositoryCredentials == null;
        }

        @Override
        public int hashCode() {
            int result = this.imageName.hashCode();
            result = 31 * result + (this.repositoryCredentials != null ? this.repositoryCredentials.hashCode() : 0);
            return result;
        }
    }
}
