package software.amazon.awscdk.services.ecs;

/**
 * The properties used to define an ECS cluster.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:32.981Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ecs.$Module.class, fqn = "@aws-cdk/aws-ecs.ClusterProps")
@software.amazon.jsii.Jsii.Proxy(ClusterProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ClusterProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ec2 capacity to add to the cluster.
     * <p>
     * Default: - no EC2 capacity will be added, you can use `addCapacity` to add capacity later.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.AddCapacityOptions getCapacity() {
        return null;
    }

    /**
     * The name for the cluster.
     * <p>
     * Default: CloudFormation-generated name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getClusterName() {
        return null;
    }

    /**
     * If true CloudWatch Container Insights will be enabled for the cluster.
     * <p>
     * Default: - Container Insights will be disabled for this cluser.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getContainerInsights() {
        return null;
    }

    /**
     * The service discovery namespace created in this cluster.
     * <p>
     * Default: - no service discovery namespace created, you can use `addDefaultCloudMapNamespace` to add a
     * default service discovery namespace later.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.CloudMapNamespaceOptions getDefaultCloudMapNamespace() {
        return null;
    }

    /**
     * The VPC where your ECS instances will be running or your ENIs will be deployed.
     * <p>
     * Default: - creates a new VPC with two AZs
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.IVpc getVpc() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ClusterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ClusterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ClusterProps> {
        private software.amazon.awscdk.services.ecs.AddCapacityOptions capacity;
        private java.lang.String clusterName;
        private java.lang.Boolean containerInsights;
        private software.amazon.awscdk.services.ecs.CloudMapNamespaceOptions defaultCloudMapNamespace;
        private software.amazon.awscdk.services.ec2.IVpc vpc;

        /**
         * Sets the value of {@link ClusterProps#getCapacity}
         * @param capacity The ec2 capacity to add to the cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder capacity(software.amazon.awscdk.services.ecs.AddCapacityOptions capacity) {
            this.capacity = capacity;
            return this;
        }

        /**
         * Sets the value of {@link ClusterProps#getClusterName}
         * @param clusterName The name for the cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterName(java.lang.String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        /**
         * Sets the value of {@link ClusterProps#getContainerInsights}
         * @param containerInsights If true CloudWatch Container Insights will be enabled for the cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder containerInsights(java.lang.Boolean containerInsights) {
            this.containerInsights = containerInsights;
            return this;
        }

        /**
         * Sets the value of {@link ClusterProps#getDefaultCloudMapNamespace}
         * @param defaultCloudMapNamespace The service discovery namespace created in this cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultCloudMapNamespace(software.amazon.awscdk.services.ecs.CloudMapNamespaceOptions defaultCloudMapNamespace) {
            this.defaultCloudMapNamespace = defaultCloudMapNamespace;
            return this;
        }

        /**
         * Sets the value of {@link ClusterProps#getVpc}
         * @param vpc The VPC where your ECS instances will be running or your ENIs will be deployed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ClusterProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ClusterProps build() {
            return new Jsii$Proxy(capacity, clusterName, containerInsights, defaultCloudMapNamespace, vpc);
        }
    }

    /**
     * An implementation for {@link ClusterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ClusterProps {
        private final software.amazon.awscdk.services.ecs.AddCapacityOptions capacity;
        private final java.lang.String clusterName;
        private final java.lang.Boolean containerInsights;
        private final software.amazon.awscdk.services.ecs.CloudMapNamespaceOptions defaultCloudMapNamespace;
        private final software.amazon.awscdk.services.ec2.IVpc vpc;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.capacity = this.jsiiGet("capacity", software.amazon.awscdk.services.ecs.AddCapacityOptions.class);
            this.clusterName = this.jsiiGet("clusterName", java.lang.String.class);
            this.containerInsights = this.jsiiGet("containerInsights", java.lang.Boolean.class);
            this.defaultCloudMapNamespace = this.jsiiGet("defaultCloudMapNamespace", software.amazon.awscdk.services.ecs.CloudMapNamespaceOptions.class);
            this.vpc = this.jsiiGet("vpc", software.amazon.awscdk.services.ec2.IVpc.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.services.ecs.AddCapacityOptions capacity, final java.lang.String clusterName, final java.lang.Boolean containerInsights, final software.amazon.awscdk.services.ecs.CloudMapNamespaceOptions defaultCloudMapNamespace, final software.amazon.awscdk.services.ec2.IVpc vpc) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.capacity = capacity;
            this.clusterName = clusterName;
            this.containerInsights = containerInsights;
            this.defaultCloudMapNamespace = defaultCloudMapNamespace;
            this.vpc = vpc;
        }

        @Override
        public software.amazon.awscdk.services.ecs.AddCapacityOptions getCapacity() {
            return this.capacity;
        }

        @Override
        public java.lang.String getClusterName() {
            return this.clusterName;
        }

        @Override
        public java.lang.Boolean getContainerInsights() {
            return this.containerInsights;
        }

        @Override
        public software.amazon.awscdk.services.ecs.CloudMapNamespaceOptions getDefaultCloudMapNamespace() {
            return this.defaultCloudMapNamespace;
        }

        @Override
        public software.amazon.awscdk.services.ec2.IVpc getVpc() {
            return this.vpc;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getCapacity() != null) {
                data.set("capacity", om.valueToTree(this.getCapacity()));
            }
            if (this.getClusterName() != null) {
                data.set("clusterName", om.valueToTree(this.getClusterName()));
            }
            if (this.getContainerInsights() != null) {
                data.set("containerInsights", om.valueToTree(this.getContainerInsights()));
            }
            if (this.getDefaultCloudMapNamespace() != null) {
                data.set("defaultCloudMapNamespace", om.valueToTree(this.getDefaultCloudMapNamespace()));
            }
            if (this.getVpc() != null) {
                data.set("vpc", om.valueToTree(this.getVpc()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ecs.ClusterProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ClusterProps.Jsii$Proxy that = (ClusterProps.Jsii$Proxy) o;

            if (this.capacity != null ? !this.capacity.equals(that.capacity) : that.capacity != null) return false;
            if (this.clusterName != null ? !this.clusterName.equals(that.clusterName) : that.clusterName != null) return false;
            if (this.containerInsights != null ? !this.containerInsights.equals(that.containerInsights) : that.containerInsights != null) return false;
            if (this.defaultCloudMapNamespace != null ? !this.defaultCloudMapNamespace.equals(that.defaultCloudMapNamespace) : that.defaultCloudMapNamespace != null) return false;
            return this.vpc != null ? this.vpc.equals(that.vpc) : that.vpc == null;
        }

        @Override
        public int hashCode() {
            int result = this.capacity != null ? this.capacity.hashCode() : 0;
            result = 31 * result + (this.clusterName != null ? this.clusterName.hashCode() : 0);
            result = 31 * result + (this.containerInsights != null ? this.containerInsights.hashCode() : 0);
            result = 31 * result + (this.defaultCloudMapNamespace != null ? this.defaultCloudMapNamespace.hashCode() : 0);
            result = 31 * result + (this.vpc != null ? this.vpc.hashCode() : 0);
            return result;
        }
    }
}
