package software.amazon.awscdk.services.ecs;

/**
 * A CloudFormation `AWS::ECS::TaskSet`.
 * <p>
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskset.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:32.977Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ecs.$Module.class, fqn = "@aws-cdk/aws-ecs.CfnTaskSet")
public class CfnTaskSet extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnTaskSet(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnTaskSet(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ecs.CfnTaskSet.class, "CFN_RESOURCE_TYPE_NAME", java.lang.String.class);
    }

    /**
     * Create a new `AWS::ECS::TaskSet`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnTaskSet(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.CfnTaskSetProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        this.jsiiCall("inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(this.jsiiCall("renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return this.jsiiGet("attrId", java.lang.String.class);
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(this.jsiiGet("cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * `AWS::ECS::TaskSet.Cluster`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskset.html#cfn-ecs-taskset-cluster
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getCluster() {
        return this.jsiiGet("cluster", java.lang.String.class);
    }

    /**
     * `AWS::ECS::TaskSet.Cluster`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskset.html#cfn-ecs-taskset-cluster
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCluster(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        this.jsiiSet("cluster", java.util.Objects.requireNonNull(value, "cluster is required"));
    }

    /**
     * `AWS::ECS::TaskSet.Service`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskset.html#cfn-ecs-taskset-service
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getService() {
        return this.jsiiGet("service", java.lang.String.class);
    }

    /**
     * `AWS::ECS::TaskSet.Service`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskset.html#cfn-ecs-taskset-service
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setService(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        this.jsiiSet("service", java.util.Objects.requireNonNull(value, "service is required"));
    }

    /**
     * `AWS::ECS::TaskSet.TaskDefinition`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskset.html#cfn-ecs-taskset-taskdefinition
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getTaskDefinition() {
        return this.jsiiGet("taskDefinition", java.lang.String.class);
    }

    /**
     * `AWS::ECS::TaskSet.TaskDefinition`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskset.html#cfn-ecs-taskset-taskdefinition
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTaskDefinition(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        this.jsiiSet("taskDefinition", java.util.Objects.requireNonNull(value, "taskDefinition is required"));
    }

    /**
     * `AWS::ECS::TaskSet.ExternalId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskset.html#cfn-ecs-taskset-externalid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getExternalId() {
        return this.jsiiGet("externalId", java.lang.String.class);
    }

    /**
     * `AWS::ECS::TaskSet.ExternalId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskset.html#cfn-ecs-taskset-externalid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setExternalId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("externalId", value);
    }

    /**
     * `AWS::ECS::TaskSet.LaunchType`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskset.html#cfn-ecs-taskset-launchtype
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getLaunchType() {
        return this.jsiiGet("launchType", java.lang.String.class);
    }

    /**
     * `AWS::ECS::TaskSet.LaunchType`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskset.html#cfn-ecs-taskset-launchtype
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLaunchType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("launchType", value);
    }

    /**
     * `AWS::ECS::TaskSet.LoadBalancers`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskset.html#cfn-ecs-taskset-loadbalancers
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getLoadBalancers() {
        return this.jsiiGet("loadBalancers", java.lang.Object.class);
    }

    /**
     * `AWS::ECS::TaskSet.LoadBalancers`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskset.html#cfn-ecs-taskset-loadbalancers
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLoadBalancers(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("loadBalancers", value);
    }

    /**
     * `AWS::ECS::TaskSet.LoadBalancers`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskset.html#cfn-ecs-taskset-loadbalancers
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLoadBalancers(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        this.jsiiSet("loadBalancers", value);
    }

    /**
     * `AWS::ECS::TaskSet.NetworkConfiguration`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskset.html#cfn-ecs-taskset-networkconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getNetworkConfiguration() {
        return this.jsiiGet("networkConfiguration", java.lang.Object.class);
    }

    /**
     * `AWS::ECS::TaskSet.NetworkConfiguration`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskset.html#cfn-ecs-taskset-networkconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNetworkConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("networkConfiguration", value);
    }

    /**
     * `AWS::ECS::TaskSet.NetworkConfiguration`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskset.html#cfn-ecs-taskset-networkconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNetworkConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.CfnTaskSet.NetworkConfigurationProperty value) {
        this.jsiiSet("networkConfiguration", value);
    }

    /**
     * `AWS::ECS::TaskSet.PlatformVersion`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskset.html#cfn-ecs-taskset-platformversion
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPlatformVersion() {
        return this.jsiiGet("platformVersion", java.lang.String.class);
    }

    /**
     * `AWS::ECS::TaskSet.PlatformVersion`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskset.html#cfn-ecs-taskset-platformversion
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPlatformVersion(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("platformVersion", value);
    }

    /**
     * `AWS::ECS::TaskSet.Scale`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskset.html#cfn-ecs-taskset-scale
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getScale() {
        return this.jsiiGet("scale", java.lang.Object.class);
    }

    /**
     * `AWS::ECS::TaskSet.Scale`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskset.html#cfn-ecs-taskset-scale
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setScale(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("scale", value);
    }

    /**
     * `AWS::ECS::TaskSet.Scale`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskset.html#cfn-ecs-taskset-scale
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setScale(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.CfnTaskSet.ScaleProperty value) {
        this.jsiiSet("scale", value);
    }

    /**
     * `AWS::ECS::TaskSet.ServiceRegistries`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskset.html#cfn-ecs-taskset-serviceregistries
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getServiceRegistries() {
        return this.jsiiGet("serviceRegistries", java.lang.Object.class);
    }

    /**
     * `AWS::ECS::TaskSet.ServiceRegistries`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskset.html#cfn-ecs-taskset-serviceregistries
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setServiceRegistries(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("serviceRegistries", value);
    }

    /**
     * `AWS::ECS::TaskSet.ServiceRegistries`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskset.html#cfn-ecs-taskset-serviceregistries
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setServiceRegistries(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        this.jsiiSet("serviceRegistries", value);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskset-awsvpcconfiguration.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ecs.$Module.class, fqn = "@aws-cdk/aws-ecs.CfnTaskSet.AwsVpcConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(AwsVpcConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AwsVpcConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnTaskSet.AwsVpcConfigurationProperty.Subnets`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskset-awsvpcconfiguration.html#cfn-ecs-taskset-awsvpcconfiguration-subnets
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSubnets();

        /**
         * `CfnTaskSet.AwsVpcConfigurationProperty.AssignPublicIp`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskset-awsvpcconfiguration.html#cfn-ecs-taskset-awsvpcconfiguration-assignpublicip
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAssignPublicIp() {
            return null;
        }

        /**
         * `CfnTaskSet.AwsVpcConfigurationProperty.SecurityGroups`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskset-awsvpcconfiguration.html#cfn-ecs-taskset-awsvpcconfiguration-securitygroups
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSecurityGroups() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AwsVpcConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AwsVpcConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AwsVpcConfigurationProperty> {
            private java.util.List<java.lang.String> subnets;
            private java.lang.String assignPublicIp;
            private java.util.List<java.lang.String> securityGroups;

            /**
             * Sets the value of {@link AwsVpcConfigurationProperty#getSubnets}
             * @param subnets `CfnTaskSet.AwsVpcConfigurationProperty.Subnets`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subnets(java.util.List<java.lang.String> subnets) {
                this.subnets = subnets;
                return this;
            }

            /**
             * Sets the value of {@link AwsVpcConfigurationProperty#getAssignPublicIp}
             * @param assignPublicIp `CfnTaskSet.AwsVpcConfigurationProperty.AssignPublicIp`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder assignPublicIp(java.lang.String assignPublicIp) {
                this.assignPublicIp = assignPublicIp;
                return this;
            }

            /**
             * Sets the value of {@link AwsVpcConfigurationProperty#getSecurityGroups}
             * @param securityGroups `CfnTaskSet.AwsVpcConfigurationProperty.SecurityGroups`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityGroups(java.util.List<java.lang.String> securityGroups) {
                this.securityGroups = securityGroups;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AwsVpcConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AwsVpcConfigurationProperty build() {
                return new Jsii$Proxy(subnets, assignPublicIp, securityGroups);
            }
        }

        /**
         * An implementation for {@link AwsVpcConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AwsVpcConfigurationProperty {
            private final java.util.List<java.lang.String> subnets;
            private final java.lang.String assignPublicIp;
            private final java.util.List<java.lang.String> securityGroups;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.subnets = this.jsiiGet("subnets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.assignPublicIp = this.jsiiGet("assignPublicIp", java.lang.String.class);
                this.securityGroups = this.jsiiGet("securityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.util.List<java.lang.String> subnets, final java.lang.String assignPublicIp, final java.util.List<java.lang.String> securityGroups) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.subnets = java.util.Objects.requireNonNull(subnets, "subnets is required");
                this.assignPublicIp = assignPublicIp;
                this.securityGroups = securityGroups;
            }

            @Override
            public java.util.List<java.lang.String> getSubnets() {
                return this.subnets;
            }

            @Override
            public java.lang.String getAssignPublicIp() {
                return this.assignPublicIp;
            }

            @Override
            public java.util.List<java.lang.String> getSecurityGroups() {
                return this.securityGroups;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("subnets", om.valueToTree(this.getSubnets()));
                if (this.getAssignPublicIp() != null) {
                    data.set("assignPublicIp", om.valueToTree(this.getAssignPublicIp()));
                }
                if (this.getSecurityGroups() != null) {
                    data.set("securityGroups", om.valueToTree(this.getSecurityGroups()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ecs.CfnTaskSet.AwsVpcConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AwsVpcConfigurationProperty.Jsii$Proxy that = (AwsVpcConfigurationProperty.Jsii$Proxy) o;

                if (!subnets.equals(that.subnets)) return false;
                if (this.assignPublicIp != null ? !this.assignPublicIp.equals(that.assignPublicIp) : that.assignPublicIp != null) return false;
                return this.securityGroups != null ? this.securityGroups.equals(that.securityGroups) : that.securityGroups == null;
            }

            @Override
            public int hashCode() {
                int result = this.subnets.hashCode();
                result = 31 * result + (this.assignPublicIp != null ? this.assignPublicIp.hashCode() : 0);
                result = 31 * result + (this.securityGroups != null ? this.securityGroups.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskset-loadbalancer.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ecs.$Module.class, fqn = "@aws-cdk/aws-ecs.CfnTaskSet.LoadBalancerProperty")
    @software.amazon.jsii.Jsii.Proxy(LoadBalancerProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LoadBalancerProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnTaskSet.LoadBalancerProperty.ContainerName`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskset-loadbalancer.html#cfn-ecs-taskset-loadbalancer-containername
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getContainerName() {
            return null;
        }

        /**
         * `CfnTaskSet.LoadBalancerProperty.ContainerPort`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskset-loadbalancer.html#cfn-ecs-taskset-loadbalancer-containerport
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getContainerPort() {
            return null;
        }

        /**
         * `CfnTaskSet.LoadBalancerProperty.LoadBalancerName`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskset-loadbalancer.html#cfn-ecs-taskset-loadbalancer-loadbalancername
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLoadBalancerName() {
            return null;
        }

        /**
         * `CfnTaskSet.LoadBalancerProperty.TargetGroupArn`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskset-loadbalancer.html#cfn-ecs-taskset-loadbalancer-targetgrouparn
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTargetGroupArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LoadBalancerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LoadBalancerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LoadBalancerProperty> {
            private java.lang.String containerName;
            private java.lang.Number containerPort;
            private java.lang.String loadBalancerName;
            private java.lang.String targetGroupArn;

            /**
             * Sets the value of {@link LoadBalancerProperty#getContainerName}
             * @param containerName `CfnTaskSet.LoadBalancerProperty.ContainerName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containerName(java.lang.String containerName) {
                this.containerName = containerName;
                return this;
            }

            /**
             * Sets the value of {@link LoadBalancerProperty#getContainerPort}
             * @param containerPort `CfnTaskSet.LoadBalancerProperty.ContainerPort`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containerPort(java.lang.Number containerPort) {
                this.containerPort = containerPort;
                return this;
            }

            /**
             * Sets the value of {@link LoadBalancerProperty#getLoadBalancerName}
             * @param loadBalancerName `CfnTaskSet.LoadBalancerProperty.LoadBalancerName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder loadBalancerName(java.lang.String loadBalancerName) {
                this.loadBalancerName = loadBalancerName;
                return this;
            }

            /**
             * Sets the value of {@link LoadBalancerProperty#getTargetGroupArn}
             * @param targetGroupArn `CfnTaskSet.LoadBalancerProperty.TargetGroupArn`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetGroupArn(java.lang.String targetGroupArn) {
                this.targetGroupArn = targetGroupArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LoadBalancerProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LoadBalancerProperty build() {
                return new Jsii$Proxy(containerName, containerPort, loadBalancerName, targetGroupArn);
            }
        }

        /**
         * An implementation for {@link LoadBalancerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LoadBalancerProperty {
            private final java.lang.String containerName;
            private final java.lang.Number containerPort;
            private final java.lang.String loadBalancerName;
            private final java.lang.String targetGroupArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.containerName = this.jsiiGet("containerName", java.lang.String.class);
                this.containerPort = this.jsiiGet("containerPort", java.lang.Number.class);
                this.loadBalancerName = this.jsiiGet("loadBalancerName", java.lang.String.class);
                this.targetGroupArn = this.jsiiGet("targetGroupArn", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String containerName, final java.lang.Number containerPort, final java.lang.String loadBalancerName, final java.lang.String targetGroupArn) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.containerName = containerName;
                this.containerPort = containerPort;
                this.loadBalancerName = loadBalancerName;
                this.targetGroupArn = targetGroupArn;
            }

            @Override
            public java.lang.String getContainerName() {
                return this.containerName;
            }

            @Override
            public java.lang.Number getContainerPort() {
                return this.containerPort;
            }

            @Override
            public java.lang.String getLoadBalancerName() {
                return this.loadBalancerName;
            }

            @Override
            public java.lang.String getTargetGroupArn() {
                return this.targetGroupArn;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getContainerName() != null) {
                    data.set("containerName", om.valueToTree(this.getContainerName()));
                }
                if (this.getContainerPort() != null) {
                    data.set("containerPort", om.valueToTree(this.getContainerPort()));
                }
                if (this.getLoadBalancerName() != null) {
                    data.set("loadBalancerName", om.valueToTree(this.getLoadBalancerName()));
                }
                if (this.getTargetGroupArn() != null) {
                    data.set("targetGroupArn", om.valueToTree(this.getTargetGroupArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ecs.CfnTaskSet.LoadBalancerProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LoadBalancerProperty.Jsii$Proxy that = (LoadBalancerProperty.Jsii$Proxy) o;

                if (this.containerName != null ? !this.containerName.equals(that.containerName) : that.containerName != null) return false;
                if (this.containerPort != null ? !this.containerPort.equals(that.containerPort) : that.containerPort != null) return false;
                if (this.loadBalancerName != null ? !this.loadBalancerName.equals(that.loadBalancerName) : that.loadBalancerName != null) return false;
                return this.targetGroupArn != null ? this.targetGroupArn.equals(that.targetGroupArn) : that.targetGroupArn == null;
            }

            @Override
            public int hashCode() {
                int result = this.containerName != null ? this.containerName.hashCode() : 0;
                result = 31 * result + (this.containerPort != null ? this.containerPort.hashCode() : 0);
                result = 31 * result + (this.loadBalancerName != null ? this.loadBalancerName.hashCode() : 0);
                result = 31 * result + (this.targetGroupArn != null ? this.targetGroupArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskset-networkconfiguration.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ecs.$Module.class, fqn = "@aws-cdk/aws-ecs.CfnTaskSet.NetworkConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(NetworkConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NetworkConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnTaskSet.NetworkConfigurationProperty.AwsVpcConfiguration`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskset-networkconfiguration.html#cfn-ecs-taskset-networkconfiguration-awsvpcconfiguration
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAwsVpcConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link NetworkConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NetworkConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NetworkConfigurationProperty> {
            private java.lang.Object awsVpcConfiguration;

            /**
             * Sets the value of {@link NetworkConfigurationProperty#getAwsVpcConfiguration}
             * @param awsVpcConfiguration `CfnTaskSet.NetworkConfigurationProperty.AwsVpcConfiguration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder awsVpcConfiguration(software.amazon.awscdk.core.IResolvable awsVpcConfiguration) {
                this.awsVpcConfiguration = awsVpcConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link NetworkConfigurationProperty#getAwsVpcConfiguration}
             * @param awsVpcConfiguration `CfnTaskSet.NetworkConfigurationProperty.AwsVpcConfiguration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder awsVpcConfiguration(software.amazon.awscdk.services.ecs.CfnTaskSet.AwsVpcConfigurationProperty awsVpcConfiguration) {
                this.awsVpcConfiguration = awsVpcConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NetworkConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NetworkConfigurationProperty build() {
                return new Jsii$Proxy(awsVpcConfiguration);
            }
        }

        /**
         * An implementation for {@link NetworkConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NetworkConfigurationProperty {
            private final java.lang.Object awsVpcConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.awsVpcConfiguration = this.jsiiGet("awsVpcConfiguration", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Object awsVpcConfiguration) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.awsVpcConfiguration = awsVpcConfiguration;
            }

            @Override
            public java.lang.Object getAwsVpcConfiguration() {
                return this.awsVpcConfiguration;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAwsVpcConfiguration() != null) {
                    data.set("awsVpcConfiguration", om.valueToTree(this.getAwsVpcConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ecs.CfnTaskSet.NetworkConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NetworkConfigurationProperty.Jsii$Proxy that = (NetworkConfigurationProperty.Jsii$Proxy) o;

                return this.awsVpcConfiguration != null ? this.awsVpcConfiguration.equals(that.awsVpcConfiguration) : that.awsVpcConfiguration == null;
            }

            @Override
            public int hashCode() {
                int result = this.awsVpcConfiguration != null ? this.awsVpcConfiguration.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskset-scale.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ecs.$Module.class, fqn = "@aws-cdk/aws-ecs.CfnTaskSet.ScaleProperty")
    @software.amazon.jsii.Jsii.Proxy(ScaleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ScaleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnTaskSet.ScaleProperty.Unit`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskset-scale.html#cfn-ecs-taskset-scale-unit
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUnit() {
            return null;
        }

        /**
         * `CfnTaskSet.ScaleProperty.Value`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskset-scale.html#cfn-ecs-taskset-scale-value
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ScaleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ScaleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ScaleProperty> {
            private java.lang.String unit;
            private java.lang.Number value;

            /**
             * Sets the value of {@link ScaleProperty#getUnit}
             * @param unit `CfnTaskSet.ScaleProperty.Unit`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder unit(java.lang.String unit) {
                this.unit = unit;
                return this;
            }

            /**
             * Sets the value of {@link ScaleProperty#getValue}
             * @param value `CfnTaskSet.ScaleProperty.Value`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.Number value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ScaleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ScaleProperty build() {
                return new Jsii$Proxy(unit, value);
            }
        }

        /**
         * An implementation for {@link ScaleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScaleProperty {
            private final java.lang.String unit;
            private final java.lang.Number value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.unit = this.jsiiGet("unit", java.lang.String.class);
                this.value = this.jsiiGet("value", java.lang.Number.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String unit, final java.lang.Number value) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.unit = unit;
                this.value = value;
            }

            @Override
            public java.lang.String getUnit() {
                return this.unit;
            }

            @Override
            public java.lang.Number getValue() {
                return this.value;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getUnit() != null) {
                    data.set("unit", om.valueToTree(this.getUnit()));
                }
                if (this.getValue() != null) {
                    data.set("value", om.valueToTree(this.getValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ecs.CfnTaskSet.ScaleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ScaleProperty.Jsii$Proxy that = (ScaleProperty.Jsii$Proxy) o;

                if (this.unit != null ? !this.unit.equals(that.unit) : that.unit != null) return false;
                return this.value != null ? this.value.equals(that.value) : that.value == null;
            }

            @Override
            public int hashCode() {
                int result = this.unit != null ? this.unit.hashCode() : 0;
                result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskset-serviceregistry.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ecs.$Module.class, fqn = "@aws-cdk/aws-ecs.CfnTaskSet.ServiceRegistryProperty")
    @software.amazon.jsii.Jsii.Proxy(ServiceRegistryProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ServiceRegistryProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnTaskSet.ServiceRegistryProperty.ContainerName`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskset-serviceregistry.html#cfn-ecs-taskset-serviceregistry-containername
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getContainerName() {
            return null;
        }

        /**
         * `CfnTaskSet.ServiceRegistryProperty.ContainerPort`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskset-serviceregistry.html#cfn-ecs-taskset-serviceregistry-containerport
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getContainerPort() {
            return null;
        }

        /**
         * `CfnTaskSet.ServiceRegistryProperty.Port`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskset-serviceregistry.html#cfn-ecs-taskset-serviceregistry-port
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPort() {
            return null;
        }

        /**
         * `CfnTaskSet.ServiceRegistryProperty.RegistryArn`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskset-serviceregistry.html#cfn-ecs-taskset-serviceregistry-registryarn
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRegistryArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ServiceRegistryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ServiceRegistryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ServiceRegistryProperty> {
            private java.lang.String containerName;
            private java.lang.Number containerPort;
            private java.lang.Number port;
            private java.lang.String registryArn;

            /**
             * Sets the value of {@link ServiceRegistryProperty#getContainerName}
             * @param containerName `CfnTaskSet.ServiceRegistryProperty.ContainerName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containerName(java.lang.String containerName) {
                this.containerName = containerName;
                return this;
            }

            /**
             * Sets the value of {@link ServiceRegistryProperty#getContainerPort}
             * @param containerPort `CfnTaskSet.ServiceRegistryProperty.ContainerPort`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containerPort(java.lang.Number containerPort) {
                this.containerPort = containerPort;
                return this;
            }

            /**
             * Sets the value of {@link ServiceRegistryProperty#getPort}
             * @param port `CfnTaskSet.ServiceRegistryProperty.Port`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder port(java.lang.Number port) {
                this.port = port;
                return this;
            }

            /**
             * Sets the value of {@link ServiceRegistryProperty#getRegistryArn}
             * @param registryArn `CfnTaskSet.ServiceRegistryProperty.RegistryArn`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder registryArn(java.lang.String registryArn) {
                this.registryArn = registryArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ServiceRegistryProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ServiceRegistryProperty build() {
                return new Jsii$Proxy(containerName, containerPort, port, registryArn);
            }
        }

        /**
         * An implementation for {@link ServiceRegistryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ServiceRegistryProperty {
            private final java.lang.String containerName;
            private final java.lang.Number containerPort;
            private final java.lang.Number port;
            private final java.lang.String registryArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.containerName = this.jsiiGet("containerName", java.lang.String.class);
                this.containerPort = this.jsiiGet("containerPort", java.lang.Number.class);
                this.port = this.jsiiGet("port", java.lang.Number.class);
                this.registryArn = this.jsiiGet("registryArn", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String containerName, final java.lang.Number containerPort, final java.lang.Number port, final java.lang.String registryArn) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.containerName = containerName;
                this.containerPort = containerPort;
                this.port = port;
                this.registryArn = registryArn;
            }

            @Override
            public java.lang.String getContainerName() {
                return this.containerName;
            }

            @Override
            public java.lang.Number getContainerPort() {
                return this.containerPort;
            }

            @Override
            public java.lang.Number getPort() {
                return this.port;
            }

            @Override
            public java.lang.String getRegistryArn() {
                return this.registryArn;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getContainerName() != null) {
                    data.set("containerName", om.valueToTree(this.getContainerName()));
                }
                if (this.getContainerPort() != null) {
                    data.set("containerPort", om.valueToTree(this.getContainerPort()));
                }
                if (this.getPort() != null) {
                    data.set("port", om.valueToTree(this.getPort()));
                }
                if (this.getRegistryArn() != null) {
                    data.set("registryArn", om.valueToTree(this.getRegistryArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ecs.CfnTaskSet.ServiceRegistryProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ServiceRegistryProperty.Jsii$Proxy that = (ServiceRegistryProperty.Jsii$Proxy) o;

                if (this.containerName != null ? !this.containerName.equals(that.containerName) : that.containerName != null) return false;
                if (this.containerPort != null ? !this.containerPort.equals(that.containerPort) : that.containerPort != null) return false;
                if (this.port != null ? !this.port.equals(that.port) : that.port != null) return false;
                return this.registryArn != null ? this.registryArn.equals(that.registryArn) : that.registryArn == null;
            }

            @Override
            public int hashCode() {
                int result = this.containerName != null ? this.containerName.hashCode() : 0;
                result = 31 * result + (this.containerPort != null ? this.containerPort.hashCode() : 0);
                result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
                result = 31 * result + (this.registryArn != null ? this.registryArn.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ecs.CfnTaskSet}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ecs.CfnTaskSet> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ecs.CfnTaskSetProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ecs.CfnTaskSetProps.Builder();
        }

        /**
         * `AWS::ECS::TaskSet.Cluster`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskset.html#cfn-ecs-taskset-cluster
         * @param cluster `AWS::ECS::TaskSet.Cluster`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cluster(final java.lang.String cluster) {
            this.props.cluster(cluster);
            return this;
        }

        /**
         * `AWS::ECS::TaskSet.Service`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskset.html#cfn-ecs-taskset-service
         * @param service `AWS::ECS::TaskSet.Service`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder service(final java.lang.String service) {
            this.props.service(service);
            return this;
        }

        /**
         * `AWS::ECS::TaskSet.TaskDefinition`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskset.html#cfn-ecs-taskset-taskdefinition
         * @param taskDefinition `AWS::ECS::TaskSet.TaskDefinition`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskDefinition(final java.lang.String taskDefinition) {
            this.props.taskDefinition(taskDefinition);
            return this;
        }

        /**
         * `AWS::ECS::TaskSet.ExternalId`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskset.html#cfn-ecs-taskset-externalid
         * @param externalId `AWS::ECS::TaskSet.ExternalId`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder externalId(final java.lang.String externalId) {
            this.props.externalId(externalId);
            return this;
        }

        /**
         * `AWS::ECS::TaskSet.LaunchType`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskset.html#cfn-ecs-taskset-launchtype
         * @param launchType `AWS::ECS::TaskSet.LaunchType`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder launchType(final java.lang.String launchType) {
            this.props.launchType(launchType);
            return this;
        }

        /**
         * `AWS::ECS::TaskSet.LoadBalancers`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskset.html#cfn-ecs-taskset-loadbalancers
         * @param loadBalancers `AWS::ECS::TaskSet.LoadBalancers`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loadBalancers(final software.amazon.awscdk.core.IResolvable loadBalancers) {
            this.props.loadBalancers(loadBalancers);
            return this;
        }
        /**
         * `AWS::ECS::TaskSet.LoadBalancers`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskset.html#cfn-ecs-taskset-loadbalancers
         * @param loadBalancers `AWS::ECS::TaskSet.LoadBalancers`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loadBalancers(final java.util.List<java.lang.Object> loadBalancers) {
            this.props.loadBalancers(loadBalancers);
            return this;
        }

        /**
         * `AWS::ECS::TaskSet.NetworkConfiguration`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskset.html#cfn-ecs-taskset-networkconfiguration
         * @param networkConfiguration `AWS::ECS::TaskSet.NetworkConfiguration`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkConfiguration(final software.amazon.awscdk.core.IResolvable networkConfiguration) {
            this.props.networkConfiguration(networkConfiguration);
            return this;
        }
        /**
         * `AWS::ECS::TaskSet.NetworkConfiguration`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskset.html#cfn-ecs-taskset-networkconfiguration
         * @param networkConfiguration `AWS::ECS::TaskSet.NetworkConfiguration`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkConfiguration(final software.amazon.awscdk.services.ecs.CfnTaskSet.NetworkConfigurationProperty networkConfiguration) {
            this.props.networkConfiguration(networkConfiguration);
            return this;
        }

        /**
         * `AWS::ECS::TaskSet.PlatformVersion`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskset.html#cfn-ecs-taskset-platformversion
         * @param platformVersion `AWS::ECS::TaskSet.PlatformVersion`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder platformVersion(final java.lang.String platformVersion) {
            this.props.platformVersion(platformVersion);
            return this;
        }

        /**
         * `AWS::ECS::TaskSet.Scale`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskset.html#cfn-ecs-taskset-scale
         * @param scale `AWS::ECS::TaskSet.Scale`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scale(final software.amazon.awscdk.core.IResolvable scale) {
            this.props.scale(scale);
            return this;
        }
        /**
         * `AWS::ECS::TaskSet.Scale`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskset.html#cfn-ecs-taskset-scale
         * @param scale `AWS::ECS::TaskSet.Scale`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scale(final software.amazon.awscdk.services.ecs.CfnTaskSet.ScaleProperty scale) {
            this.props.scale(scale);
            return this;
        }

        /**
         * `AWS::ECS::TaskSet.ServiceRegistries`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskset.html#cfn-ecs-taskset-serviceregistries
         * @param serviceRegistries `AWS::ECS::TaskSet.ServiceRegistries`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceRegistries(final software.amazon.awscdk.core.IResolvable serviceRegistries) {
            this.props.serviceRegistries(serviceRegistries);
            return this;
        }
        /**
         * `AWS::ECS::TaskSet.ServiceRegistries`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskset.html#cfn-ecs-taskset-serviceregistries
         * @param serviceRegistries `AWS::ECS::TaskSet.ServiceRegistries`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceRegistries(final java.util.List<java.lang.Object> serviceRegistries) {
            this.props.serviceRegistries(serviceRegistries);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ecs.CfnTaskSet}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ecs.CfnTaskSet build() {
            return new software.amazon.awscdk.services.ecs.CfnTaskSet(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
