package software.amazon.awscdk.services.ecs;

/**
 * A CloudFormation `AWS::ECS::CapacityProvider`.
 * <p>
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-capacityprovider.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:32.956Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ecs.$Module.class, fqn = "@aws-cdk/aws-ecs.CfnCapacityProvider")
public class CfnCapacityProvider extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnCapacityProvider(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnCapacityProvider(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ecs.CfnCapacityProvider.class, "CFN_RESOURCE_TYPE_NAME", java.lang.String.class);
    }

    /**
     * Create a new `AWS::ECS::CapacityProvider`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnCapacityProvider(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.CfnCapacityProviderProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        this.jsiiCall("inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(this.jsiiCall("renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(this.jsiiGet("cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * `AWS::ECS::CapacityProvider.Tags`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-capacityprovider.html#cfn-ecs-capacityprovider-tags
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return this.jsiiGet("tags", software.amazon.awscdk.core.TagManager.class);
    }

    /**
     * `AWS::ECS::CapacityProvider.AutoScalingGroupProvider`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-capacityprovider.html#cfn-ecs-capacityprovider-autoscalinggroupprovider
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getAutoScalingGroupProvider() {
        return this.jsiiGet("autoScalingGroupProvider", java.lang.Object.class);
    }

    /**
     * `AWS::ECS::CapacityProvider.AutoScalingGroupProvider`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-capacityprovider.html#cfn-ecs-capacityprovider-autoscalinggroupprovider
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAutoScalingGroupProvider(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.CfnCapacityProvider.AutoScalingGroupProviderProperty value) {
        this.jsiiSet("autoScalingGroupProvider", java.util.Objects.requireNonNull(value, "autoScalingGroupProvider is required"));
    }

    /**
     * `AWS::ECS::CapacityProvider.AutoScalingGroupProvider`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-capacityprovider.html#cfn-ecs-capacityprovider-autoscalinggroupprovider
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAutoScalingGroupProvider(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("autoScalingGroupProvider", java.util.Objects.requireNonNull(value, "autoScalingGroupProvider is required"));
    }

    /**
     * `AWS::ECS::CapacityProvider.Name`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-capacityprovider.html#cfn-ecs-capacityprovider-name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return this.jsiiGet("name", java.lang.String.class);
    }

    /**
     * `AWS::ECS::CapacityProvider.Name`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-capacityprovider.html#cfn-ecs-capacityprovider-name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("name", value);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-autoscalinggroupprovider.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ecs.$Module.class, fqn = "@aws-cdk/aws-ecs.CfnCapacityProvider.AutoScalingGroupProviderProperty")
    @software.amazon.jsii.Jsii.Proxy(AutoScalingGroupProviderProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AutoScalingGroupProviderProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnCapacityProvider.AutoScalingGroupProviderProperty.AutoScalingGroupArn`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-autoscalinggroupprovider.html#cfn-ecs-capacityprovider-autoscalinggroupprovider-autoscalinggrouparn
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAutoScalingGroupArn();

        /**
         * `CfnCapacityProvider.AutoScalingGroupProviderProperty.ManagedScaling`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-autoscalinggroupprovider.html#cfn-ecs-capacityprovider-autoscalinggroupprovider-managedscaling
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getManagedScaling() {
            return null;
        }

        /**
         * `CfnCapacityProvider.AutoScalingGroupProviderProperty.ManagedTerminationProtection`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-autoscalinggroupprovider.html#cfn-ecs-capacityprovider-autoscalinggroupprovider-managedterminationprotection
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getManagedTerminationProtection() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AutoScalingGroupProviderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AutoScalingGroupProviderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AutoScalingGroupProviderProperty> {
            private java.lang.String autoScalingGroupArn;
            private java.lang.Object managedScaling;
            private java.lang.String managedTerminationProtection;

            /**
             * Sets the value of {@link AutoScalingGroupProviderProperty#getAutoScalingGroupArn}
             * @param autoScalingGroupArn `CfnCapacityProvider.AutoScalingGroupProviderProperty.AutoScalingGroupArn`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder autoScalingGroupArn(java.lang.String autoScalingGroupArn) {
                this.autoScalingGroupArn = autoScalingGroupArn;
                return this;
            }

            /**
             * Sets the value of {@link AutoScalingGroupProviderProperty#getManagedScaling}
             * @param managedScaling `CfnCapacityProvider.AutoScalingGroupProviderProperty.ManagedScaling`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder managedScaling(software.amazon.awscdk.core.IResolvable managedScaling) {
                this.managedScaling = managedScaling;
                return this;
            }

            /**
             * Sets the value of {@link AutoScalingGroupProviderProperty#getManagedScaling}
             * @param managedScaling `CfnCapacityProvider.AutoScalingGroupProviderProperty.ManagedScaling`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder managedScaling(software.amazon.awscdk.services.ecs.CfnCapacityProvider.ManagedScalingProperty managedScaling) {
                this.managedScaling = managedScaling;
                return this;
            }

            /**
             * Sets the value of {@link AutoScalingGroupProviderProperty#getManagedTerminationProtection}
             * @param managedTerminationProtection `CfnCapacityProvider.AutoScalingGroupProviderProperty.ManagedTerminationProtection`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder managedTerminationProtection(java.lang.String managedTerminationProtection) {
                this.managedTerminationProtection = managedTerminationProtection;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AutoScalingGroupProviderProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AutoScalingGroupProviderProperty build() {
                return new Jsii$Proxy(autoScalingGroupArn, managedScaling, managedTerminationProtection);
            }
        }

        /**
         * An implementation for {@link AutoScalingGroupProviderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AutoScalingGroupProviderProperty {
            private final java.lang.String autoScalingGroupArn;
            private final java.lang.Object managedScaling;
            private final java.lang.String managedTerminationProtection;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.autoScalingGroupArn = this.jsiiGet("autoScalingGroupArn", java.lang.String.class);
                this.managedScaling = this.jsiiGet("managedScaling", java.lang.Object.class);
                this.managedTerminationProtection = this.jsiiGet("managedTerminationProtection", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String autoScalingGroupArn, final java.lang.Object managedScaling, final java.lang.String managedTerminationProtection) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.autoScalingGroupArn = java.util.Objects.requireNonNull(autoScalingGroupArn, "autoScalingGroupArn is required");
                this.managedScaling = managedScaling;
                this.managedTerminationProtection = managedTerminationProtection;
            }

            @Override
            public java.lang.String getAutoScalingGroupArn() {
                return this.autoScalingGroupArn;
            }

            @Override
            public java.lang.Object getManagedScaling() {
                return this.managedScaling;
            }

            @Override
            public java.lang.String getManagedTerminationProtection() {
                return this.managedTerminationProtection;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("autoScalingGroupArn", om.valueToTree(this.getAutoScalingGroupArn()));
                if (this.getManagedScaling() != null) {
                    data.set("managedScaling", om.valueToTree(this.getManagedScaling()));
                }
                if (this.getManagedTerminationProtection() != null) {
                    data.set("managedTerminationProtection", om.valueToTree(this.getManagedTerminationProtection()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ecs.CfnCapacityProvider.AutoScalingGroupProviderProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AutoScalingGroupProviderProperty.Jsii$Proxy that = (AutoScalingGroupProviderProperty.Jsii$Proxy) o;

                if (!autoScalingGroupArn.equals(that.autoScalingGroupArn)) return false;
                if (this.managedScaling != null ? !this.managedScaling.equals(that.managedScaling) : that.managedScaling != null) return false;
                return this.managedTerminationProtection != null ? this.managedTerminationProtection.equals(that.managedTerminationProtection) : that.managedTerminationProtection == null;
            }

            @Override
            public int hashCode() {
                int result = this.autoScalingGroupArn.hashCode();
                result = 31 * result + (this.managedScaling != null ? this.managedScaling.hashCode() : 0);
                result = 31 * result + (this.managedTerminationProtection != null ? this.managedTerminationProtection.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-managedscaling.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ecs.$Module.class, fqn = "@aws-cdk/aws-ecs.CfnCapacityProvider.ManagedScalingProperty")
    @software.amazon.jsii.Jsii.Proxy(ManagedScalingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ManagedScalingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnCapacityProvider.ManagedScalingProperty.MaximumScalingStepSize`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-managedscaling.html#cfn-ecs-capacityprovider-managedscaling-maximumscalingstepsize
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaximumScalingStepSize() {
            return null;
        }

        /**
         * `CfnCapacityProvider.ManagedScalingProperty.MinimumScalingStepSize`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-managedscaling.html#cfn-ecs-capacityprovider-managedscaling-minimumscalingstepsize
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMinimumScalingStepSize() {
            return null;
        }

        /**
         * `CfnCapacityProvider.ManagedScalingProperty.Status`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-managedscaling.html#cfn-ecs-capacityprovider-managedscaling-status
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStatus() {
            return null;
        }

        /**
         * `CfnCapacityProvider.ManagedScalingProperty.TargetCapacity`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-managedscaling.html#cfn-ecs-capacityprovider-managedscaling-targetcapacity
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTargetCapacity() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ManagedScalingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ManagedScalingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ManagedScalingProperty> {
            private java.lang.Number maximumScalingStepSize;
            private java.lang.Number minimumScalingStepSize;
            private java.lang.String status;
            private java.lang.Number targetCapacity;

            /**
             * Sets the value of {@link ManagedScalingProperty#getMaximumScalingStepSize}
             * @param maximumScalingStepSize `CfnCapacityProvider.ManagedScalingProperty.MaximumScalingStepSize`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maximumScalingStepSize(java.lang.Number maximumScalingStepSize) {
                this.maximumScalingStepSize = maximumScalingStepSize;
                return this;
            }

            /**
             * Sets the value of {@link ManagedScalingProperty#getMinimumScalingStepSize}
             * @param minimumScalingStepSize `CfnCapacityProvider.ManagedScalingProperty.MinimumScalingStepSize`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minimumScalingStepSize(java.lang.Number minimumScalingStepSize) {
                this.minimumScalingStepSize = minimumScalingStepSize;
                return this;
            }

            /**
             * Sets the value of {@link ManagedScalingProperty#getStatus}
             * @param status `CfnCapacityProvider.ManagedScalingProperty.Status`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder status(java.lang.String status) {
                this.status = status;
                return this;
            }

            /**
             * Sets the value of {@link ManagedScalingProperty#getTargetCapacity}
             * @param targetCapacity `CfnCapacityProvider.ManagedScalingProperty.TargetCapacity`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetCapacity(java.lang.Number targetCapacity) {
                this.targetCapacity = targetCapacity;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ManagedScalingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ManagedScalingProperty build() {
                return new Jsii$Proxy(maximumScalingStepSize, minimumScalingStepSize, status, targetCapacity);
            }
        }

        /**
         * An implementation for {@link ManagedScalingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ManagedScalingProperty {
            private final java.lang.Number maximumScalingStepSize;
            private final java.lang.Number minimumScalingStepSize;
            private final java.lang.String status;
            private final java.lang.Number targetCapacity;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.maximumScalingStepSize = this.jsiiGet("maximumScalingStepSize", java.lang.Number.class);
                this.minimumScalingStepSize = this.jsiiGet("minimumScalingStepSize", java.lang.Number.class);
                this.status = this.jsiiGet("status", java.lang.String.class);
                this.targetCapacity = this.jsiiGet("targetCapacity", java.lang.Number.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Number maximumScalingStepSize, final java.lang.Number minimumScalingStepSize, final java.lang.String status, final java.lang.Number targetCapacity) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.maximumScalingStepSize = maximumScalingStepSize;
                this.minimumScalingStepSize = minimumScalingStepSize;
                this.status = status;
                this.targetCapacity = targetCapacity;
            }

            @Override
            public java.lang.Number getMaximumScalingStepSize() {
                return this.maximumScalingStepSize;
            }

            @Override
            public java.lang.Number getMinimumScalingStepSize() {
                return this.minimumScalingStepSize;
            }

            @Override
            public java.lang.String getStatus() {
                return this.status;
            }

            @Override
            public java.lang.Number getTargetCapacity() {
                return this.targetCapacity;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMaximumScalingStepSize() != null) {
                    data.set("maximumScalingStepSize", om.valueToTree(this.getMaximumScalingStepSize()));
                }
                if (this.getMinimumScalingStepSize() != null) {
                    data.set("minimumScalingStepSize", om.valueToTree(this.getMinimumScalingStepSize()));
                }
                if (this.getStatus() != null) {
                    data.set("status", om.valueToTree(this.getStatus()));
                }
                if (this.getTargetCapacity() != null) {
                    data.set("targetCapacity", om.valueToTree(this.getTargetCapacity()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ecs.CfnCapacityProvider.ManagedScalingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ManagedScalingProperty.Jsii$Proxy that = (ManagedScalingProperty.Jsii$Proxy) o;

                if (this.maximumScalingStepSize != null ? !this.maximumScalingStepSize.equals(that.maximumScalingStepSize) : that.maximumScalingStepSize != null) return false;
                if (this.minimumScalingStepSize != null ? !this.minimumScalingStepSize.equals(that.minimumScalingStepSize) : that.minimumScalingStepSize != null) return false;
                if (this.status != null ? !this.status.equals(that.status) : that.status != null) return false;
                return this.targetCapacity != null ? this.targetCapacity.equals(that.targetCapacity) : that.targetCapacity == null;
            }

            @Override
            public int hashCode() {
                int result = this.maximumScalingStepSize != null ? this.maximumScalingStepSize.hashCode() : 0;
                result = 31 * result + (this.minimumScalingStepSize != null ? this.minimumScalingStepSize.hashCode() : 0);
                result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
                result = 31 * result + (this.targetCapacity != null ? this.targetCapacity.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ecs.CfnCapacityProvider}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ecs.CfnCapacityProvider> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ecs.CfnCapacityProviderProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ecs.CfnCapacityProviderProps.Builder();
        }

        /**
         * `AWS::ECS::CapacityProvider.AutoScalingGroupProvider`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-capacityprovider.html#cfn-ecs-capacityprovider-autoscalinggroupprovider
         * @param autoScalingGroupProvider `AWS::ECS::CapacityProvider.AutoScalingGroupProvider`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoScalingGroupProvider(final software.amazon.awscdk.services.ecs.CfnCapacityProvider.AutoScalingGroupProviderProperty autoScalingGroupProvider) {
            this.props.autoScalingGroupProvider(autoScalingGroupProvider);
            return this;
        }
        /**
         * `AWS::ECS::CapacityProvider.AutoScalingGroupProvider`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-capacityprovider.html#cfn-ecs-capacityprovider-autoscalinggroupprovider
         * @param autoScalingGroupProvider `AWS::ECS::CapacityProvider.AutoScalingGroupProvider`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoScalingGroupProvider(final software.amazon.awscdk.core.IResolvable autoScalingGroupProvider) {
            this.props.autoScalingGroupProvider(autoScalingGroupProvider);
            return this;
        }

        /**
         * `AWS::ECS::CapacityProvider.Name`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-capacityprovider.html#cfn-ecs-capacityprovider-name
         * @param name `AWS::ECS::CapacityProvider.Name`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * `AWS::ECS::CapacityProvider.Tags`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-capacityprovider.html#cfn-ecs-capacityprovider-tags
         * @param tags `AWS::ECS::CapacityProvider.Tags`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<software.amazon.awscdk.core.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ecs.CfnCapacityProvider}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ecs.CfnCapacityProvider build() {
            return new software.amazon.awscdk.services.ecs.CfnCapacityProvider(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
