package software.amazon.awscdk.services.ecs;

/**
 * The base class for Ec2Service and FargateService services.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:32.952Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ecs.$Module.class, fqn = "@aws-cdk/aws-ecs.BaseService")
public abstract class BaseService extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.ecs.IBaseService,software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancerTarget,software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancerTarget,software.amazon.awscdk.services.elasticloadbalancing.ILoadBalancerTarget {

    protected BaseService(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected BaseService(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Constructs a new instance of the BaseService class.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     * @param additionalProps This parameter is required.
     * @param taskDefinition This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected BaseService(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.BaseServiceProps props, final @org.jetbrains.annotations.NotNull java.lang.Object additionalProps, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.TaskDefinition taskDefinition) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required"), additionalProps, java.util.Objects.requireNonNull(taskDefinition, "taskDefinition is required") });
    }

    /**
     * This method is called to attach this service to an Application Load Balancer.
     * <p>
     * Don't call this function directly. Instead, call <code>listener.addTargets()</code>
     * to add this service to a load balancer.
     * <p>
     * @param targetGroup This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.LoadBalancerTargetProps attachToApplicationTargetGroup(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup targetGroup) {
        return this.jsiiCall("attachToApplicationTargetGroup", software.amazon.awscdk.services.elasticloadbalancingv2.LoadBalancerTargetProps.class, new Object[] { java.util.Objects.requireNonNull(targetGroup, "targetGroup is required") });
    }

    /**
     * Registers the service as a target of a Classic Load Balancer (CLB).
     * <p>
     * Don't call this. Call <code>loadBalancer.addTarget()</code> instead.
     * <p>
     * @param loadBalancer This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void attachToClassicLB(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancing.LoadBalancer loadBalancer) {
        this.jsiiCall("attachToClassicLB", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(loadBalancer, "loadBalancer is required") });
    }

    /**
     * This method is called to attach this service to a Network Load Balancer.
     * <p>
     * Don't call this function directly. Instead, call <code>listener.addTargets()</code>
     * to add this service to a load balancer.
     * <p>
     * @param targetGroup This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.LoadBalancerTargetProps attachToNetworkTargetGroup(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.INetworkTargetGroup targetGroup) {
        return this.jsiiCall("attachToNetworkTargetGroup", software.amazon.awscdk.services.elasticloadbalancingv2.LoadBalancerTargetProps.class, new Object[] { java.util.Objects.requireNonNull(targetGroup, "targetGroup is required") });
    }

    /**
     * An attribute representing the minimum and maximum task count for an AutoScalingGroup.
     * <p>
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.ScalableTaskCount autoScaleTaskCount(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.applicationautoscaling.EnableScalingProps props) {
        return this.jsiiCall("autoScaleTaskCount", software.amazon.awscdk.services.ecs.ScalableTaskCount.class, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * This method is called to create a networkConfiguration.
     * <p>
     * @deprecated use configureAwsVpcNetworkingWithSecurityGroups instead.
     * @param vpc This parameter is required.
     * @param assignPublicIp
     * @param vpcSubnets
     * @param securityGroup
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    protected void configureAwsVpcNetworking(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IVpc vpc, final @org.jetbrains.annotations.Nullable java.lang.Boolean assignPublicIp, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup) {
        this.jsiiCall("configureAwsVpcNetworking", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(vpc, "vpc is required"), assignPublicIp, vpcSubnets, securityGroup });
    }

    /**
     * This method is called to create a networkConfiguration.
     * <p>
     * @deprecated use configureAwsVpcNetworkingWithSecurityGroups instead.
     * @param vpc This parameter is required.
     * @param assignPublicIp
     * @param vpcSubnets
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    protected void configureAwsVpcNetworking(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IVpc vpc, final @org.jetbrains.annotations.Nullable java.lang.Boolean assignPublicIp, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets) {
        this.jsiiCall("configureAwsVpcNetworking", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(vpc, "vpc is required"), assignPublicIp, vpcSubnets });
    }

    /**
     * This method is called to create a networkConfiguration.
     * <p>
     * @deprecated use configureAwsVpcNetworkingWithSecurityGroups instead.
     * @param vpc This parameter is required.
     * @param assignPublicIp
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    protected void configureAwsVpcNetworking(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IVpc vpc, final @org.jetbrains.annotations.Nullable java.lang.Boolean assignPublicIp) {
        this.jsiiCall("configureAwsVpcNetworking", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(vpc, "vpc is required"), assignPublicIp });
    }

    /**
     * This method is called to create a networkConfiguration.
     * <p>
     * @deprecated use configureAwsVpcNetworkingWithSecurityGroups instead.
     * @param vpc This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    protected void configureAwsVpcNetworking(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IVpc vpc) {
        this.jsiiCall("configureAwsVpcNetworking", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(vpc, "vpc is required") });
    }

    /**
     * This method is called to create a networkConfiguration.
     * <p>
     * @param vpc This parameter is required.
     * @param assignPublicIp
     * @param vpcSubnets
     * @param securityGroups
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void configureAwsVpcNetworkingWithSecurityGroups(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IVpc vpc, final @org.jetbrains.annotations.Nullable java.lang.Boolean assignPublicIp, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets, final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups) {
        this.jsiiCall("configureAwsVpcNetworkingWithSecurityGroups", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(vpc, "vpc is required"), assignPublicIp, vpcSubnets, securityGroups });
    }

    /**
     * This method is called to create a networkConfiguration.
     * <p>
     * @param vpc This parameter is required.
     * @param assignPublicIp
     * @param vpcSubnets
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void configureAwsVpcNetworkingWithSecurityGroups(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IVpc vpc, final @org.jetbrains.annotations.Nullable java.lang.Boolean assignPublicIp, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets) {
        this.jsiiCall("configureAwsVpcNetworkingWithSecurityGroups", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(vpc, "vpc is required"), assignPublicIp, vpcSubnets });
    }

    /**
     * This method is called to create a networkConfiguration.
     * <p>
     * @param vpc This parameter is required.
     * @param assignPublicIp
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void configureAwsVpcNetworkingWithSecurityGroups(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IVpc vpc, final @org.jetbrains.annotations.Nullable java.lang.Boolean assignPublicIp) {
        this.jsiiCall("configureAwsVpcNetworkingWithSecurityGroups", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(vpc, "vpc is required"), assignPublicIp });
    }

    /**
     * This method is called to create a networkConfiguration.
     * <p>
     * @param vpc This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void configureAwsVpcNetworkingWithSecurityGroups(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IVpc vpc) {
        this.jsiiCall("configureAwsVpcNetworkingWithSecurityGroups", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(vpc, "vpc is required") });
    }

    /**
     * Enable CloudMap service discovery for the service.
     * <p>
     * @return The created CloudMap service
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicediscovery.Service enableCloudMap(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.CloudMapOptions options) {
        return this.jsiiCall("enableCloudMap", software.amazon.awscdk.services.servicediscovery.Service.class, new Object[] { java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Return a load balancing target for a specific container and port.
     * <p>
     * Use this function to create a load balancer target if you want to load balance to
     * another container than the first essential container or the first mapped port on
     * the container.
     * <p>
     * Use the return value of this function where you would normally use a load balancer
     * target, instead of the <code>Service</code> object itself.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>{@code
     * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
     * listener.addTargets("ECS", Map.of(
     *         "port", 80,
     *         "targets", asList(service.loadBalancerTarget(Map.of(
     *                 "containerName", "MyContainer",
     *                 "containerPort", 1234)))));}</pre></blockquote>
     * <p>
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.IEcsLoadBalancerTarget loadBalancerTarget(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.LoadBalancerTargetOptions options) {
        return this.jsiiCall("loadBalancerTarget", software.amazon.awscdk.services.ecs.IEcsLoadBalancerTarget.class, new Object[] { java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * This method returns the specified CloudWatch metric name for this service.
     * <p>
     * @param metricName This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return this.jsiiCall("metric", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required"), props });
    }

    /**
     * This method returns the specified CloudWatch metric name for this service.
     * <p>
     * @param metricName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName) {
        return this.jsiiCall("metric", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required") });
    }

    /**
     * This method returns the CloudWatch metric for this clusters CPU utilization.
     * <p>
     * Default: average over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricCpuUtilization(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return this.jsiiCall("metricCpuUtilization", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
    }

    /**
     * This method returns the CloudWatch metric for this clusters CPU utilization.
     * <p>
     * Default: average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricCpuUtilization() {
        return this.jsiiCall("metricCpuUtilization", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * This method returns the CloudWatch metric for this clusters memory utilization.
     * <p>
     * Default: average over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricMemoryUtilization(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return this.jsiiCall("metricMemoryUtilization", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
    }

    /**
     * This method returns the CloudWatch metric for this clusters memory utilization.
     * <p>
     * Default: average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricMemoryUtilization() {
        return this.jsiiCall("metricMemoryUtilization", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * Use this function to create all load balancer targets to be registered in this service, add them to target groups, and attach target groups to listeners accordingly.
     * <p>
     * Alternatively, you can use <code>listener.addTargets()</code> to create targets and add them to target groups.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>{@code
     * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
     * service.registerLoadBalancerTargets(Map.of(
     *         "containerName", "web",
     *         "containerPort", 80,
     *         "newTargetGroupId", "ECS",
     *         "listener", ecs.ListenerConfig.applicationListener(listener, Map.of(
     *                 "protocol", elbv2.ApplicationProtocol.getHTTPS()))));}</pre></blockquote>
     * <p>
     * @param targets This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void registerLoadBalancerTargets(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.EcsTarget... targets) {
        this.jsiiCall("registerLoadBalancerTargets", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(targets).toArray(Object[]::new));
    }

    /**
     * The cluster that hosts the service.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.ICluster getCluster() {
        return this.jsiiGet("cluster", software.amazon.awscdk.services.ecs.ICluster.class);
    }

    /**
     * The security groups which manage the allowed network traffic for the service.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Connections getConnections() {
        return this.jsiiGet("connections", software.amazon.awscdk.services.ec2.Connections.class);
    }

    /**
     * The Amazon Resource Name (ARN) of the service.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getServiceArn() {
        return this.jsiiGet("serviceArn", java.lang.String.class);
    }

    /**
     * The name of the service.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getServiceName() {
        return this.jsiiGet("serviceName", java.lang.String.class);
    }

    /**
     * The task definition to use for tasks in the service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.TaskDefinition getTaskDefinition() {
        return this.jsiiGet("taskDefinition", software.amazon.awscdk.services.ecs.TaskDefinition.class);
    }

    /**
     * The CloudMap service created for this service, if any.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.servicediscovery.IService getCloudMapService() {
        return this.jsiiGet("cloudMapService", software.amazon.awscdk.services.servicediscovery.IService.class);
    }

    /**
     * A list of Elastic Load Balancing load balancer objects, containing the load balancer name, the container name (as it appears in a container definition), and the container port to access from the load balancer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.ecs.CfnService.LoadBalancerProperty> getLoadBalancers() {
        return java.util.Collections.unmodifiableList(this.jsiiGet("loadBalancers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.CfnService.LoadBalancerProperty.class))));
    }

    /**
     * A list of Elastic Load Balancing load balancer objects, containing the load balancer name, the container name (as it appears in a container definition), and the container port to access from the load balancer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void setLoadBalancers(final @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.ecs.CfnService.LoadBalancerProperty> value) {
        this.jsiiSet("loadBalancers", java.util.Objects.requireNonNull(value, "loadBalancers is required"));
    }

    /**
     * The details of the service discovery registries to assign to this service.
     * <p>
     * For more information, see Service Discovery.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.ecs.CfnService.ServiceRegistryProperty> getServiceRegistries() {
        return java.util.Collections.unmodifiableList(this.jsiiGet("serviceRegistries", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.CfnService.ServiceRegistryProperty.class))));
    }

    /**
     * The details of the service discovery registries to assign to this service.
     * <p>
     * For more information, see Service Discovery.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void setServiceRegistries(final @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.ecs.CfnService.ServiceRegistryProperty> value) {
        this.jsiiSet("serviceRegistries", java.util.Objects.requireNonNull(value, "serviceRegistries is required"));
    }

    /**
     * The details of the AWS Cloud Map service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.servicediscovery.Service getCloudmapService() {
        return this.jsiiGet("cloudmapService", software.amazon.awscdk.services.servicediscovery.Service.class);
    }

    /**
     * The details of the AWS Cloud Map service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void setCloudmapService(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.servicediscovery.Service value) {
        this.jsiiSet("cloudmapService", value);
    }

    /**
     * A list of Elastic Load Balancing load balancer objects, containing the load balancer name, the container name (as it appears in a container definition), and the container port to access from the load balancer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.CfnService.NetworkConfigurationProperty getNetworkConfiguration() {
        return this.jsiiGet("networkConfiguration", software.amazon.awscdk.services.ecs.CfnService.NetworkConfigurationProperty.class);
    }

    /**
     * A list of Elastic Load Balancing load balancer objects, containing the load balancer name, the container name (as it appears in a container definition), and the container port to access from the load balancer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void setNetworkConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.CfnService.NetworkConfigurationProperty value) {
        this.jsiiSet("networkConfiguration", value);
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.awscdk.services.ecs.BaseService {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * The cluster that hosts the service.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.ICluster getCluster() {
            return this.jsiiGet("cluster", software.amazon.awscdk.services.ecs.ICluster.class);
        }

        /**
         * The Amazon Resource Name (ARN) of the service.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull java.lang.String getServiceArn() {
            return this.jsiiGet("serviceArn", java.lang.String.class);
        }

        /**
         * The name of the service.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull java.lang.String getServiceName() {
            return this.jsiiGet("serviceName", java.lang.String.class);
        }

        /**
         * The environment this resource belongs to.
         * <p>
         * For resources that are created and managed by the CDK
         * (generally, those created by creating new class instances like Role, Bucket, etc.),
         * this is always the same as the environment of the stack they belong to;
         * however, for imported resources
         * (those obtained from static methods like fromRoleArn, fromBucketName, etc.),
         * that might be different than the stack they were imported into.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ResourceEnvironment getEnv() {
            return this.jsiiGet("env", software.amazon.awscdk.core.ResourceEnvironment.class);
        }

        /**
         * The stack in which this resource is defined.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Stack getStack() {
            return this.jsiiGet("stack", software.amazon.awscdk.core.Stack.class);
        }

        /**
         * The construct tree node for this construct.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ConstructNode getNode() {
            return this.jsiiGet("node", software.amazon.awscdk.core.ConstructNode.class);
        }

        /**
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Connections getConnections() {
            return this.jsiiGet("connections", software.amazon.awscdk.services.ec2.Connections.class);
        }

        /**
         * Attach load-balanced target to a TargetGroup.
         * <p>
         * May return JSON to directly add to the [Targets] list, or return undefined
         * if the target will register itself with the load balancer.
         * <p>
         * @param targetGroup This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.LoadBalancerTargetProps attachToApplicationTargetGroup(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup targetGroup) {
            return this.jsiiCall("attachToApplicationTargetGroup", software.amazon.awscdk.services.elasticloadbalancingv2.LoadBalancerTargetProps.class, new Object[] { java.util.Objects.requireNonNull(targetGroup, "targetGroup is required") });
        }

        /**
         * Attach load-balanced target to a TargetGroup.
         * <p>
         * May return JSON to directly add to the [Targets] list, or return undefined
         * if the target will register itself with the load balancer.
         * <p>
         * @param targetGroup This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.LoadBalancerTargetProps attachToNetworkTargetGroup(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.INetworkTargetGroup targetGroup) {
            return this.jsiiCall("attachToNetworkTargetGroup", software.amazon.awscdk.services.elasticloadbalancingv2.LoadBalancerTargetProps.class, new Object[] { java.util.Objects.requireNonNull(targetGroup, "targetGroup is required") });
        }

        /**
         * Attach load-balanced target to a classic ELB.
         * <p>
         * @param loadBalancer [disable-awslint:ref-via-interface] The load balancer to attach the target to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public void attachToClassicLB(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancing.LoadBalancer loadBalancer) {
            this.jsiiCall("attachToClassicLB", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(loadBalancer, "loadBalancer is required") });
        }
    }
}
