package software.amazon.awscdk.services.ecs;

/**
 * Specifies the awslogs log driver configuration options.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:32.951Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ecs.$Module.class, fqn = "@aws-cdk/aws-ecs.AwsLogDriverProps")
@software.amazon.jsii.Jsii.Proxy(AwsLogDriverProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AwsLogDriverProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Prefix for the log streams.
     * <p>
     * The awslogs-stream-prefix option allows you to associate a log stream
     * with the specified prefix, the container name, and the ID of the Amazon
     * ECS task to which the container belongs. If you specify a prefix with
     * this option, then the log stream takes the following format:
     * <p>
     * <blockquote><pre>
     *  prefix-name/container-name/ecs-task-id
     * </pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getStreamPrefix();

    /**
     * This option defines a multiline start pattern in Python strftime format.
     * <p>
     * A log message consists of a line that matches the pattern and any
     * following lines that don’t match the pattern. Thus the matched line is
     * the delimiter between log messages.
     * <p>
     * Default: - No multiline matching.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDatetimeFormat() {
        return null;
    }

    /**
     * The log group to log to.
     * <p>
     * Default: - A log group is automatically created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.ILogGroup getLogGroup() {
        return null;
    }

    /**
     * The number of days log events are kept in CloudWatch Logs when the log group is automatically created by this construct.
     * <p>
     * Default: - Logs never expire.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.RetentionDays getLogRetention() {
        return null;
    }

    /**
     * This option defines a multiline start pattern using a regular expression.
     * <p>
     * A log message consists of a line that matches the pattern and any
     * following lines that don’t match the pattern. Thus the matched line is
     * the delimiter between log messages.
     * <p>
     * This option is ignored if datetimeFormat is also configured.
     * <p>
     * Default: - No multiline matching.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMultilinePattern() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AwsLogDriverProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AwsLogDriverProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AwsLogDriverProps> {
        private java.lang.String streamPrefix;
        private java.lang.String datetimeFormat;
        private software.amazon.awscdk.services.logs.ILogGroup logGroup;
        private software.amazon.awscdk.services.logs.RetentionDays logRetention;
        private java.lang.String multilinePattern;

        /**
         * Sets the value of {@link AwsLogDriverProps#getStreamPrefix}
         * @param streamPrefix Prefix for the log streams. This parameter is required.
         *                     The awslogs-stream-prefix option allows you to associate a log stream
         *                     with the specified prefix, the container name, and the ID of the Amazon
         *                     ECS task to which the container belongs. If you specify a prefix with
         *                     this option, then the log stream takes the following format:
         *                     <p>
         *                     <blockquote><pre>
         *                      prefix-name/container-name/ecs-task-id
         *                     </pre></blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder streamPrefix(java.lang.String streamPrefix) {
            this.streamPrefix = streamPrefix;
            return this;
        }

        /**
         * Sets the value of {@link AwsLogDriverProps#getDatetimeFormat}
         * @param datetimeFormat This option defines a multiline start pattern in Python strftime format.
         *                       A log message consists of a line that matches the pattern and any
         *                       following lines that don’t match the pattern. Thus the matched line is
         *                       the delimiter between log messages.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder datetimeFormat(java.lang.String datetimeFormat) {
            this.datetimeFormat = datetimeFormat;
            return this;
        }

        /**
         * Sets the value of {@link AwsLogDriverProps#getLogGroup}
         * @param logGroup The log group to log to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logGroup(software.amazon.awscdk.services.logs.ILogGroup logGroup) {
            this.logGroup = logGroup;
            return this;
        }

        /**
         * Sets the value of {@link AwsLogDriverProps#getLogRetention}
         * @param logRetention The number of days log events are kept in CloudWatch Logs when the log group is automatically created by this construct.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logRetention(software.amazon.awscdk.services.logs.RetentionDays logRetention) {
            this.logRetention = logRetention;
            return this;
        }

        /**
         * Sets the value of {@link AwsLogDriverProps#getMultilinePattern}
         * @param multilinePattern This option defines a multiline start pattern using a regular expression.
         *                         A log message consists of a line that matches the pattern and any
         *                         following lines that don’t match the pattern. Thus the matched line is
         *                         the delimiter between log messages.
         *                         <p>
         *                         This option is ignored if datetimeFormat is also configured.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder multilinePattern(java.lang.String multilinePattern) {
            this.multilinePattern = multilinePattern;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AwsLogDriverProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AwsLogDriverProps build() {
            return new Jsii$Proxy(streamPrefix, datetimeFormat, logGroup, logRetention, multilinePattern);
        }
    }

    /**
     * An implementation for {@link AwsLogDriverProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AwsLogDriverProps {
        private final java.lang.String streamPrefix;
        private final java.lang.String datetimeFormat;
        private final software.amazon.awscdk.services.logs.ILogGroup logGroup;
        private final software.amazon.awscdk.services.logs.RetentionDays logRetention;
        private final java.lang.String multilinePattern;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.streamPrefix = this.jsiiGet("streamPrefix", java.lang.String.class);
            this.datetimeFormat = this.jsiiGet("datetimeFormat", java.lang.String.class);
            this.logGroup = this.jsiiGet("logGroup", software.amazon.awscdk.services.logs.ILogGroup.class);
            this.logRetention = this.jsiiGet("logRetention", software.amazon.awscdk.services.logs.RetentionDays.class);
            this.multilinePattern = this.jsiiGet("multilinePattern", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String streamPrefix, final java.lang.String datetimeFormat, final software.amazon.awscdk.services.logs.ILogGroup logGroup, final software.amazon.awscdk.services.logs.RetentionDays logRetention, final java.lang.String multilinePattern) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.streamPrefix = java.util.Objects.requireNonNull(streamPrefix, "streamPrefix is required");
            this.datetimeFormat = datetimeFormat;
            this.logGroup = logGroup;
            this.logRetention = logRetention;
            this.multilinePattern = multilinePattern;
        }

        @Override
        public java.lang.String getStreamPrefix() {
            return this.streamPrefix;
        }

        @Override
        public java.lang.String getDatetimeFormat() {
            return this.datetimeFormat;
        }

        @Override
        public software.amazon.awscdk.services.logs.ILogGroup getLogGroup() {
            return this.logGroup;
        }

        @Override
        public software.amazon.awscdk.services.logs.RetentionDays getLogRetention() {
            return this.logRetention;
        }

        @Override
        public java.lang.String getMultilinePattern() {
            return this.multilinePattern;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("streamPrefix", om.valueToTree(this.getStreamPrefix()));
            if (this.getDatetimeFormat() != null) {
                data.set("datetimeFormat", om.valueToTree(this.getDatetimeFormat()));
            }
            if (this.getLogGroup() != null) {
                data.set("logGroup", om.valueToTree(this.getLogGroup()));
            }
            if (this.getLogRetention() != null) {
                data.set("logRetention", om.valueToTree(this.getLogRetention()));
            }
            if (this.getMultilinePattern() != null) {
                data.set("multilinePattern", om.valueToTree(this.getMultilinePattern()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ecs.AwsLogDriverProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AwsLogDriverProps.Jsii$Proxy that = (AwsLogDriverProps.Jsii$Proxy) o;

            if (!streamPrefix.equals(that.streamPrefix)) return false;
            if (this.datetimeFormat != null ? !this.datetimeFormat.equals(that.datetimeFormat) : that.datetimeFormat != null) return false;
            if (this.logGroup != null ? !this.logGroup.equals(that.logGroup) : that.logGroup != null) return false;
            if (this.logRetention != null ? !this.logRetention.equals(that.logRetention) : that.logRetention != null) return false;
            return this.multilinePattern != null ? this.multilinePattern.equals(that.multilinePattern) : that.multilinePattern == null;
        }

        @Override
        public int hashCode() {
            int result = this.streamPrefix.hashCode();
            result = 31 * result + (this.datetimeFormat != null ? this.datetimeFormat.hashCode() : 0);
            result = 31 * result + (this.logGroup != null ? this.logGroup.hashCode() : 0);
            result = 31 * result + (this.logRetention != null ? this.logRetention.hashCode() : 0);
            result = 31 * result + (this.multilinePattern != null ? this.multilinePattern.hashCode() : 0);
            return result;
        }
    }
}
