package software.amazon.awscdk.services.ecs;

/**
 * The properties for building an AssetImage.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:32.950Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ecs.$Module.class, fqn = "@aws-cdk/aws-ecs.AssetImageProps")
@software.amazon.jsii.Jsii.Proxy(AssetImageProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AssetImageProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.ecr.assets.DockerImageAssetOptions {

    /**
     * @return a {@link Builder} of {@link AssetImageProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AssetImageProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AssetImageProps> {
        private java.util.Map<java.lang.String, java.lang.String> buildArgs;
        private java.lang.String file;
        private java.lang.String repositoryName;
        private java.lang.String target;
        private java.lang.String extraHash;
        private java.util.List<java.lang.String> exclude;
        private software.amazon.awscdk.assets.FollowMode follow;

        /**
         * Sets the value of {@link AssetImageProps#getBuildArgs}
         * @param buildArgs Build args to pass to the `docker build` command.
         *                  Since Docker build arguments are resolved before deployment, keys and
         *                  values cannot refer to unresolved tokens (such as <code>lambda.functionArn</code> or
         *                  <code>queue.queueUrl</code>).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder buildArgs(java.util.Map<java.lang.String, java.lang.String> buildArgs) {
            this.buildArgs = buildArgs;
            return this;
        }

        /**
         * Sets the value of {@link AssetImageProps#getFile}
         * @param file Path to the Dockerfile (relative to the directory).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder file(java.lang.String file) {
            this.file = file;
            return this;
        }

        /**
         * Sets the value of {@link AssetImageProps#getRepositoryName}
         * @param repositoryName ECR repository name.
         *                       Specify this property if you need to statically address the image, e.g.
         *                       from a Kubernetes Pod. Note, this is only the repository name, without the
         *                       registry and the tag parts.
         * @return {@code this}
         * @deprecated to control the location of docker image assets, please override
`Stack.addDockerImageAsset`. this feature will be removed in future
releases.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder repositoryName(java.lang.String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        /**
         * Sets the value of {@link AssetImageProps#getTarget}
         * @param target Docker target to build to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder target(java.lang.String target) {
            this.target = target;
            return this;
        }

        /**
         * Sets the value of {@link AssetImageProps#getExtraHash}
         * @param extraHash Extra information to encode into the fingerprint (e.g. build instructions and other inputs).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder extraHash(java.lang.String extraHash) {
            this.extraHash = extraHash;
            return this;
        }

        /**
         * Sets the value of {@link AssetImageProps#getExclude}
         * @param exclude Glob patterns to exclude from the copy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder exclude(java.util.List<java.lang.String> exclude) {
            this.exclude = exclude;
            return this;
        }

        /**
         * Sets the value of {@link AssetImageProps#getFollow}
         * @param follow A strategy for how to handle symlinks.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder follow(software.amazon.awscdk.assets.FollowMode follow) {
            this.follow = follow;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AssetImageProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AssetImageProps build() {
            return new Jsii$Proxy(buildArgs, file, repositoryName, target, extraHash, exclude, follow);
        }
    }

    /**
     * An implementation for {@link AssetImageProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AssetImageProps {
        private final java.util.Map<java.lang.String, java.lang.String> buildArgs;
        private final java.lang.String file;
        private final java.lang.String repositoryName;
        private final java.lang.String target;
        private final java.lang.String extraHash;
        private final java.util.List<java.lang.String> exclude;
        private final software.amazon.awscdk.assets.FollowMode follow;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.buildArgs = this.jsiiGet("buildArgs", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.file = this.jsiiGet("file", java.lang.String.class);
            this.repositoryName = this.jsiiGet("repositoryName", java.lang.String.class);
            this.target = this.jsiiGet("target", java.lang.String.class);
            this.extraHash = this.jsiiGet("extraHash", java.lang.String.class);
            this.exclude = this.jsiiGet("exclude", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.follow = this.jsiiGet("follow", software.amazon.awscdk.assets.FollowMode.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.util.Map<java.lang.String, java.lang.String> buildArgs, final java.lang.String file, final java.lang.String repositoryName, final java.lang.String target, final java.lang.String extraHash, final java.util.List<java.lang.String> exclude, final software.amazon.awscdk.assets.FollowMode follow) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.buildArgs = buildArgs;
            this.file = file;
            this.repositoryName = repositoryName;
            this.target = target;
            this.extraHash = extraHash;
            this.exclude = exclude;
            this.follow = follow;
        }

        @Override
        public java.util.Map<java.lang.String, java.lang.String> getBuildArgs() {
            return this.buildArgs;
        }

        @Override
        public java.lang.String getFile() {
            return this.file;
        }

        @Override
        public java.lang.String getRepositoryName() {
            return this.repositoryName;
        }

        @Override
        public java.lang.String getTarget() {
            return this.target;
        }

        @Override
        public java.lang.String getExtraHash() {
            return this.extraHash;
        }

        @Override
        public java.util.List<java.lang.String> getExclude() {
            return this.exclude;
        }

        @Override
        public software.amazon.awscdk.assets.FollowMode getFollow() {
            return this.follow;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getBuildArgs() != null) {
                data.set("buildArgs", om.valueToTree(this.getBuildArgs()));
            }
            if (this.getFile() != null) {
                data.set("file", om.valueToTree(this.getFile()));
            }
            if (this.getRepositoryName() != null) {
                data.set("repositoryName", om.valueToTree(this.getRepositoryName()));
            }
            if (this.getTarget() != null) {
                data.set("target", om.valueToTree(this.getTarget()));
            }
            if (this.getExtraHash() != null) {
                data.set("extraHash", om.valueToTree(this.getExtraHash()));
            }
            if (this.getExclude() != null) {
                data.set("exclude", om.valueToTree(this.getExclude()));
            }
            if (this.getFollow() != null) {
                data.set("follow", om.valueToTree(this.getFollow()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ecs.AssetImageProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AssetImageProps.Jsii$Proxy that = (AssetImageProps.Jsii$Proxy) o;

            if (this.buildArgs != null ? !this.buildArgs.equals(that.buildArgs) : that.buildArgs != null) return false;
            if (this.file != null ? !this.file.equals(that.file) : that.file != null) return false;
            if (this.repositoryName != null ? !this.repositoryName.equals(that.repositoryName) : that.repositoryName != null) return false;
            if (this.target != null ? !this.target.equals(that.target) : that.target != null) return false;
            if (this.extraHash != null ? !this.extraHash.equals(that.extraHash) : that.extraHash != null) return false;
            if (this.exclude != null ? !this.exclude.equals(that.exclude) : that.exclude != null) return false;
            return this.follow != null ? this.follow.equals(that.follow) : that.follow == null;
        }

        @Override
        public int hashCode() {
            int result = this.buildArgs != null ? this.buildArgs.hashCode() : 0;
            result = 31 * result + (this.file != null ? this.file.hashCode() : 0);
            result = 31 * result + (this.repositoryName != null ? this.repositoryName.hashCode() : 0);
            result = 31 * result + (this.target != null ? this.target.hashCode() : 0);
            result = 31 * result + (this.extraHash != null ? this.extraHash.hashCode() : 0);
            result = 31 * result + (this.exclude != null ? this.exclude.hashCode() : 0);
            result = 31 * result + (this.follow != null ? this.follow.hashCode() : 0);
            return result;
        }
    }
}
