package software.amazon.awscdk.services.ecs;

/**
 * Interface for setting the properties of proxy configuration.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:32.949Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ecs.$Module.class, fqn = "@aws-cdk/aws-ecs.AppMeshProxyConfigurationProps")
@software.amazon.jsii.Jsii.Proxy(AppMeshProxyConfigurationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AppMeshProxyConfigurationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The list of ports that the application uses.
     * <p>
     * Network traffic to these ports is forwarded to the ProxyIngressPort and ProxyEgressPort.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.Number> getAppPorts();

    /**
     * Specifies the port that outgoing traffic from the AppPorts is directed to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getProxyEgressPort();

    /**
     * Specifies the port that incoming traffic to the AppPorts is directed to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getProxyIngressPort();

    /**
     * The egress traffic going to these specified IP addresses is ignored and not redirected to the ProxyEgressPort.
     * <p>
     * It can be an empty list.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getEgressIgnoredIPs() {
        return null;
    }

    /**
     * The egress traffic going to these specified ports is ignored and not redirected to the ProxyEgressPort.
     * <p>
     * It can be an empty list.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.Number> getEgressIgnoredPorts() {
        return null;
    }

    /**
     * The group ID (GID) of the proxy container as defined by the user parameter in a container definition.
     * <p>
     * This is used to ensure the proxy ignores its own traffic. If IgnoredUID is specified, this field can be empty.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getIgnoredGid() {
        return null;
    }

    /**
     * The user ID (UID) of the proxy container as defined by the user parameter in a container definition.
     * <p>
     * This is used to ensure the proxy ignores its own traffic. If IgnoredGID is specified, this field can be empty.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getIgnoredUid() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AppMeshProxyConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AppMeshProxyConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AppMeshProxyConfigurationProps> {
        private java.util.List<java.lang.Number> appPorts;
        private java.lang.Number proxyEgressPort;
        private java.lang.Number proxyIngressPort;
        private java.util.List<java.lang.String> egressIgnoredIPs;
        private java.util.List<java.lang.Number> egressIgnoredPorts;
        private java.lang.Number ignoredGid;
        private java.lang.Number ignoredUid;

        /**
         * Sets the value of {@link AppMeshProxyConfigurationProps#getAppPorts}
         * @param appPorts The list of ports that the application uses. This parameter is required.
         *                 Network traffic to these ports is forwarded to the ProxyIngressPort and ProxyEgressPort.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder appPorts(java.util.List<java.lang.Number> appPorts) {
            this.appPorts = appPorts;
            return this;
        }

        /**
         * Sets the value of {@link AppMeshProxyConfigurationProps#getProxyEgressPort}
         * @param proxyEgressPort Specifies the port that outgoing traffic from the AppPorts is directed to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder proxyEgressPort(java.lang.Number proxyEgressPort) {
            this.proxyEgressPort = proxyEgressPort;
            return this;
        }

        /**
         * Sets the value of {@link AppMeshProxyConfigurationProps#getProxyIngressPort}
         * @param proxyIngressPort Specifies the port that incoming traffic to the AppPorts is directed to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder proxyIngressPort(java.lang.Number proxyIngressPort) {
            this.proxyIngressPort = proxyIngressPort;
            return this;
        }

        /**
         * Sets the value of {@link AppMeshProxyConfigurationProps#getEgressIgnoredIPs}
         * @param egressIgnoredIPs The egress traffic going to these specified IP addresses is ignored and not redirected to the ProxyEgressPort.
         *                         It can be an empty list.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder egressIgnoredIPs(java.util.List<java.lang.String> egressIgnoredIPs) {
            this.egressIgnoredIPs = egressIgnoredIPs;
            return this;
        }

        /**
         * Sets the value of {@link AppMeshProxyConfigurationProps#getEgressIgnoredPorts}
         * @param egressIgnoredPorts The egress traffic going to these specified ports is ignored and not redirected to the ProxyEgressPort.
         *                           It can be an empty list.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder egressIgnoredPorts(java.util.List<java.lang.Number> egressIgnoredPorts) {
            this.egressIgnoredPorts = egressIgnoredPorts;
            return this;
        }

        /**
         * Sets the value of {@link AppMeshProxyConfigurationProps#getIgnoredGid}
         * @param ignoredGid The group ID (GID) of the proxy container as defined by the user parameter in a container definition.
         *                   This is used to ensure the proxy ignores its own traffic. If IgnoredUID is specified, this field can be empty.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ignoredGid(java.lang.Number ignoredGid) {
            this.ignoredGid = ignoredGid;
            return this;
        }

        /**
         * Sets the value of {@link AppMeshProxyConfigurationProps#getIgnoredUid}
         * @param ignoredUid The user ID (UID) of the proxy container as defined by the user parameter in a container definition.
         *                   This is used to ensure the proxy ignores its own traffic. If IgnoredGID is specified, this field can be empty.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ignoredUid(java.lang.Number ignoredUid) {
            this.ignoredUid = ignoredUid;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AppMeshProxyConfigurationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AppMeshProxyConfigurationProps build() {
            return new Jsii$Proxy(appPorts, proxyEgressPort, proxyIngressPort, egressIgnoredIPs, egressIgnoredPorts, ignoredGid, ignoredUid);
        }
    }

    /**
     * An implementation for {@link AppMeshProxyConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AppMeshProxyConfigurationProps {
        private final java.util.List<java.lang.Number> appPorts;
        private final java.lang.Number proxyEgressPort;
        private final java.lang.Number proxyIngressPort;
        private final java.util.List<java.lang.String> egressIgnoredIPs;
        private final java.util.List<java.lang.Number> egressIgnoredPorts;
        private final java.lang.Number ignoredGid;
        private final java.lang.Number ignoredUid;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.appPorts = this.jsiiGet("appPorts", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.Number.class)));
            this.proxyEgressPort = this.jsiiGet("proxyEgressPort", java.lang.Number.class);
            this.proxyIngressPort = this.jsiiGet("proxyIngressPort", java.lang.Number.class);
            this.egressIgnoredIPs = this.jsiiGet("egressIgnoredIPs", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.egressIgnoredPorts = this.jsiiGet("egressIgnoredPorts", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.Number.class)));
            this.ignoredGid = this.jsiiGet("ignoredGID", java.lang.Number.class);
            this.ignoredUid = this.jsiiGet("ignoredUID", java.lang.Number.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.util.List<java.lang.Number> appPorts, final java.lang.Number proxyEgressPort, final java.lang.Number proxyIngressPort, final java.util.List<java.lang.String> egressIgnoredIPs, final java.util.List<java.lang.Number> egressIgnoredPorts, final java.lang.Number ignoredGid, final java.lang.Number ignoredUid) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.appPorts = java.util.Objects.requireNonNull(appPorts, "appPorts is required");
            this.proxyEgressPort = java.util.Objects.requireNonNull(proxyEgressPort, "proxyEgressPort is required");
            this.proxyIngressPort = java.util.Objects.requireNonNull(proxyIngressPort, "proxyIngressPort is required");
            this.egressIgnoredIPs = egressIgnoredIPs;
            this.egressIgnoredPorts = egressIgnoredPorts;
            this.ignoredGid = ignoredGid;
            this.ignoredUid = ignoredUid;
        }

        @Override
        public java.util.List<java.lang.Number> getAppPorts() {
            return this.appPorts;
        }

        @Override
        public java.lang.Number getProxyEgressPort() {
            return this.proxyEgressPort;
        }

        @Override
        public java.lang.Number getProxyIngressPort() {
            return this.proxyIngressPort;
        }

        @Override
        public java.util.List<java.lang.String> getEgressIgnoredIPs() {
            return this.egressIgnoredIPs;
        }

        @Override
        public java.util.List<java.lang.Number> getEgressIgnoredPorts() {
            return this.egressIgnoredPorts;
        }

        @Override
        public java.lang.Number getIgnoredGid() {
            return this.ignoredGid;
        }

        @Override
        public java.lang.Number getIgnoredUid() {
            return this.ignoredUid;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("appPorts", om.valueToTree(this.getAppPorts()));
            data.set("proxyEgressPort", om.valueToTree(this.getProxyEgressPort()));
            data.set("proxyIngressPort", om.valueToTree(this.getProxyIngressPort()));
            if (this.getEgressIgnoredIPs() != null) {
                data.set("egressIgnoredIPs", om.valueToTree(this.getEgressIgnoredIPs()));
            }
            if (this.getEgressIgnoredPorts() != null) {
                data.set("egressIgnoredPorts", om.valueToTree(this.getEgressIgnoredPorts()));
            }
            if (this.getIgnoredGid() != null) {
                data.set("ignoredGID", om.valueToTree(this.getIgnoredGid()));
            }
            if (this.getIgnoredUid() != null) {
                data.set("ignoredUID", om.valueToTree(this.getIgnoredUid()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ecs.AppMeshProxyConfigurationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AppMeshProxyConfigurationProps.Jsii$Proxy that = (AppMeshProxyConfigurationProps.Jsii$Proxy) o;

            if (!appPorts.equals(that.appPorts)) return false;
            if (!proxyEgressPort.equals(that.proxyEgressPort)) return false;
            if (!proxyIngressPort.equals(that.proxyIngressPort)) return false;
            if (this.egressIgnoredIPs != null ? !this.egressIgnoredIPs.equals(that.egressIgnoredIPs) : that.egressIgnoredIPs != null) return false;
            if (this.egressIgnoredPorts != null ? !this.egressIgnoredPorts.equals(that.egressIgnoredPorts) : that.egressIgnoredPorts != null) return false;
            if (this.ignoredGid != null ? !this.ignoredGid.equals(that.ignoredGid) : that.ignoredGid != null) return false;
            return this.ignoredUid != null ? this.ignoredUid.equals(that.ignoredUid) : that.ignoredUid == null;
        }

        @Override
        public int hashCode() {
            int result = this.appPorts.hashCode();
            result = 31 * result + (this.proxyEgressPort.hashCode());
            result = 31 * result + (this.proxyIngressPort.hashCode());
            result = 31 * result + (this.egressIgnoredIPs != null ? this.egressIgnoredIPs.hashCode() : 0);
            result = 31 * result + (this.egressIgnoredPorts != null ? this.egressIgnoredPorts.hashCode() : 0);
            result = 31 * result + (this.ignoredGid != null ? this.ignoredGid.hashCode() : 0);
            result = 31 * result + (this.ignoredUid != null ? this.ignoredUid.hashCode() : 0);
            return result;
        }
    }
}
