package software.amazon.awscdk.services.ecs;

/**
 * The properties for adding an AutoScalingGroup.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:32.946Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ecs.$Module.class, fqn = "@aws-cdk/aws-ecs.AddAutoScalingGroupCapacityOptions")
@software.amazon.jsii.Jsii.Proxy(AddAutoScalingGroupCapacityOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AddAutoScalingGroupCapacityOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * Specifies whether the containers can access the container instance role.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getCanContainersAccessInstanceRole() {
        return null;
    }

    /**
     * Specify whether to enable Automated Draining for Spot Instances running Amazon ECS Services.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/container-instance-spot.html">Using Spot Instances</a>.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getSpotInstanceDraining() {
        return null;
    }

    /**
     * The time period to wait before force terminating an instance that is draining.
     * <p>
     * This creates a Lambda function that is used by a lifecycle hook for the
     * AutoScalingGroup that will delay instance termination until all ECS tasks
     * have drained from the instance. Set to 0 to disable task draining.
     * <p>
     * Set to 0 to disable task draining.
     * <p>
     * Default: Duration.minutes(5)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Duration getTaskDrainTime() {
        return null;
    }

    /**
     * If {@link AddAutoScalingGroupCapacityOptions.taskDrainTime} is non-zero, then the ECS cluster creates an SNS Topic to as part of a system to drain instances of tasks when the instance is being shut down. If this property is provided, then this key will be used to encrypt the contents of that SNS Topic. See [SNS Data Encryption](https://docs.aws.amazon.com/sns/latest/dg/sns-data-encryption.html) for more information.
     * <p>
     * Default: The SNS Topic will not be encrypted.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getTopicEncryptionKey() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AddAutoScalingGroupCapacityOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AddAutoScalingGroupCapacityOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AddAutoScalingGroupCapacityOptions> {
        private java.lang.Boolean canContainersAccessInstanceRole;
        private java.lang.Boolean spotInstanceDraining;
        private software.amazon.awscdk.core.Duration taskDrainTime;
        private software.amazon.awscdk.services.kms.IKey topicEncryptionKey;

        /**
         * Sets the value of {@link AddAutoScalingGroupCapacityOptions#getCanContainersAccessInstanceRole}
         * @param canContainersAccessInstanceRole Specifies whether the containers can access the container instance role.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder canContainersAccessInstanceRole(java.lang.Boolean canContainersAccessInstanceRole) {
            this.canContainersAccessInstanceRole = canContainersAccessInstanceRole;
            return this;
        }

        /**
         * Sets the value of {@link AddAutoScalingGroupCapacityOptions#getSpotInstanceDraining}
         * @param spotInstanceDraining Specify whether to enable Automated Draining for Spot Instances running Amazon ECS Services.
         *                             For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/container-instance-spot.html">Using Spot Instances</a>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder spotInstanceDraining(java.lang.Boolean spotInstanceDraining) {
            this.spotInstanceDraining = spotInstanceDraining;
            return this;
        }

        /**
         * Sets the value of {@link AddAutoScalingGroupCapacityOptions#getTaskDrainTime}
         * @param taskDrainTime The time period to wait before force terminating an instance that is draining.
         *                      This creates a Lambda function that is used by a lifecycle hook for the
         *                      AutoScalingGroup that will delay instance termination until all ECS tasks
         *                      have drained from the instance. Set to 0 to disable task draining.
         *                      <p>
         *                      Set to 0 to disable task draining.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskDrainTime(software.amazon.awscdk.core.Duration taskDrainTime) {
            this.taskDrainTime = taskDrainTime;
            return this;
        }

        /**
         * Sets the value of {@link AddAutoScalingGroupCapacityOptions#getTopicEncryptionKey}
         * @param topicEncryptionKey If {@link AddAutoScalingGroupCapacityOptions.taskDrainTime} is non-zero, then the ECS cluster creates an SNS Topic to as part of a system to drain instances of tasks when the instance is being shut down. If this property is provided, then this key will be used to encrypt the contents of that SNS Topic. See [SNS Data Encryption](https://docs.aws.amazon.com/sns/latest/dg/sns-data-encryption.html) for more information.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder topicEncryptionKey(software.amazon.awscdk.services.kms.IKey topicEncryptionKey) {
            this.topicEncryptionKey = topicEncryptionKey;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AddAutoScalingGroupCapacityOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AddAutoScalingGroupCapacityOptions build() {
            return new Jsii$Proxy(canContainersAccessInstanceRole, spotInstanceDraining, taskDrainTime, topicEncryptionKey);
        }
    }

    /**
     * An implementation for {@link AddAutoScalingGroupCapacityOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AddAutoScalingGroupCapacityOptions {
        private final java.lang.Boolean canContainersAccessInstanceRole;
        private final java.lang.Boolean spotInstanceDraining;
        private final software.amazon.awscdk.core.Duration taskDrainTime;
        private final software.amazon.awscdk.services.kms.IKey topicEncryptionKey;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.canContainersAccessInstanceRole = this.jsiiGet("canContainersAccessInstanceRole", java.lang.Boolean.class);
            this.spotInstanceDraining = this.jsiiGet("spotInstanceDraining", java.lang.Boolean.class);
            this.taskDrainTime = this.jsiiGet("taskDrainTime", software.amazon.awscdk.core.Duration.class);
            this.topicEncryptionKey = this.jsiiGet("topicEncryptionKey", software.amazon.awscdk.services.kms.IKey.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.Boolean canContainersAccessInstanceRole, final java.lang.Boolean spotInstanceDraining, final software.amazon.awscdk.core.Duration taskDrainTime, final software.amazon.awscdk.services.kms.IKey topicEncryptionKey) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.canContainersAccessInstanceRole = canContainersAccessInstanceRole;
            this.spotInstanceDraining = spotInstanceDraining;
            this.taskDrainTime = taskDrainTime;
            this.topicEncryptionKey = topicEncryptionKey;
        }

        @Override
        public java.lang.Boolean getCanContainersAccessInstanceRole() {
            return this.canContainersAccessInstanceRole;
        }

        @Override
        public java.lang.Boolean getSpotInstanceDraining() {
            return this.spotInstanceDraining;
        }

        @Override
        public software.amazon.awscdk.core.Duration getTaskDrainTime() {
            return this.taskDrainTime;
        }

        @Override
        public software.amazon.awscdk.services.kms.IKey getTopicEncryptionKey() {
            return this.topicEncryptionKey;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getCanContainersAccessInstanceRole() != null) {
                data.set("canContainersAccessInstanceRole", om.valueToTree(this.getCanContainersAccessInstanceRole()));
            }
            if (this.getSpotInstanceDraining() != null) {
                data.set("spotInstanceDraining", om.valueToTree(this.getSpotInstanceDraining()));
            }
            if (this.getTaskDrainTime() != null) {
                data.set("taskDrainTime", om.valueToTree(this.getTaskDrainTime()));
            }
            if (this.getTopicEncryptionKey() != null) {
                data.set("topicEncryptionKey", om.valueToTree(this.getTopicEncryptionKey()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ecs.AddAutoScalingGroupCapacityOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AddAutoScalingGroupCapacityOptions.Jsii$Proxy that = (AddAutoScalingGroupCapacityOptions.Jsii$Proxy) o;

            if (this.canContainersAccessInstanceRole != null ? !this.canContainersAccessInstanceRole.equals(that.canContainersAccessInstanceRole) : that.canContainersAccessInstanceRole != null) return false;
            if (this.spotInstanceDraining != null ? !this.spotInstanceDraining.equals(that.spotInstanceDraining) : that.spotInstanceDraining != null) return false;
            if (this.taskDrainTime != null ? !this.taskDrainTime.equals(that.taskDrainTime) : that.taskDrainTime != null) return false;
            return this.topicEncryptionKey != null ? this.topicEncryptionKey.equals(that.topicEncryptionKey) : that.topicEncryptionKey == null;
        }

        @Override
        public int hashCode() {
            int result = this.canContainersAccessInstanceRole != null ? this.canContainersAccessInstanceRole.hashCode() : 0;
            result = 31 * result + (this.spotInstanceDraining != null ? this.spotInstanceDraining.hashCode() : 0);
            result = 31 * result + (this.taskDrainTime != null ? this.taskDrainTime.hashCode() : 0);
            result = 31 * result + (this.topicEncryptionKey != null ? this.topicEncryptionKey.hashCode() : 0);
            return result;
        }
    }
}
