package software.amazon.awscdk.services.ecs;

/**
 * The machine image type.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Cluster cluster;
 * cluster.addCapacity("graviton-cluster", AddCapacityOptions.builder()
 *         .minCapacity(2)
 *         .instanceType(new InstanceType("c6g.large"))
 *         .machineImageType(MachineImageType.BOTTLEROCKET)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-16T18:50:35.899Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ecs.$Module.class, fqn = "@aws-cdk/aws-ecs.MachineImageType")
public enum MachineImageType {
    /**
     * Amazon ECS-optimized Amazon Linux 2 AMI.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    AMAZON_LINUX_2,
    /**
     * Bottlerocket AMI.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BOTTLEROCKET,
}
