package software.amazon.awscdk.services.ecs;

/**
 * Specifies the json-file log driver configuration options.
 * <p>
 * <a href="https://docs.docker.com/config/containers/logging/json-file/">Source</a>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ecs.*;
 * JsonFileLogDriverProps jsonFileLogDriverProps = JsonFileLogDriverProps.builder()
 *         .compress(false)
 *         .env(List.of("env"))
 *         .envRegex("envRegex")
 *         .labels(List.of("labels"))
 *         .maxFile(123)
 *         .maxSize("maxSize")
 *         .tag("tag")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-16T18:50:35.872Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ecs.$Module.class, fqn = "@aws-cdk/aws-ecs.JsonFileLogDriverProps")
@software.amazon.jsii.Jsii.Proxy(JsonFileLogDriverProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface JsonFileLogDriverProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.ecs.BaseLogDriverProps {

    /**
     * Toggles compression for rotated logs.
     * <p>
     * Default: - false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getCompress() {
        return null;
    }

    /**
     * The maximum number of log files that can be present.
     * <p>
     * If rolling the logs creates
     * excess files, the oldest file is removed. Only effective when max-size is also set.
     * A positive integer.
     * <p>
     * Default: - 1
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxFile() {
        return null;
    }

    /**
     * The maximum size of the log before it is rolled.
     * <p>
     * A positive integer plus a modifier
     * representing the unit of measure (k, m, or g).
     * <p>
     * Default: - -1 (unlimited)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMaxSize() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link JsonFileLogDriverProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link JsonFileLogDriverProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<JsonFileLogDriverProps> {
        java.lang.Boolean compress;
        java.lang.Number maxFile;
        java.lang.String maxSize;
        java.util.List<java.lang.String> env;
        java.lang.String envRegex;
        java.util.List<java.lang.String> labels;
        java.lang.String tag;

        /**
         * Sets the value of {@link JsonFileLogDriverProps#getCompress}
         * @param compress Toggles compression for rotated logs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder compress(java.lang.Boolean compress) {
            this.compress = compress;
            return this;
        }

        /**
         * Sets the value of {@link JsonFileLogDriverProps#getMaxFile}
         * @param maxFile The maximum number of log files that can be present.
         *                If rolling the logs creates
         *                excess files, the oldest file is removed. Only effective when max-size is also set.
         *                A positive integer.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxFile(java.lang.Number maxFile) {
            this.maxFile = maxFile;
            return this;
        }

        /**
         * Sets the value of {@link JsonFileLogDriverProps#getMaxSize}
         * @param maxSize The maximum size of the log before it is rolled.
         *                A positive integer plus a modifier
         *                representing the unit of measure (k, m, or g).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxSize(java.lang.String maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        /**
         * Sets the value of {@link JsonFileLogDriverProps#getEnv}
         * @param env The env option takes an array of keys.
         *            If there is collision between
         *            label and env keys, the value of the env takes precedence. Adds additional fields
         *            to the extra attributes of a logging message.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder env(java.util.List<java.lang.String> env) {
            this.env = env;
            return this;
        }

        /**
         * Sets the value of {@link JsonFileLogDriverProps#getEnvRegex}
         * @param envRegex The env-regex option is similar to and compatible with env.
         *                 Its value is a regular
         *                 expression to match logging-related environment variables. It is used for advanced
         *                 log tag options.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder envRegex(java.lang.String envRegex) {
            this.envRegex = envRegex;
            return this;
        }

        /**
         * Sets the value of {@link JsonFileLogDriverProps#getLabels}
         * @param labels The labels option takes an array of keys.
         *               If there is collision
         *               between label and env keys, the value of the env takes precedence. Adds additional
         *               fields to the extra attributes of a logging message.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder labels(java.util.List<java.lang.String> labels) {
            this.labels = labels;
            return this;
        }

        /**
         * Sets the value of {@link JsonFileLogDriverProps#getTag}
         * @param tag By default, Docker uses the first 12 characters of the container ID to tag log messages.
         *            Refer to the log tag option documentation for customizing the
         *            log tag format.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tag(java.lang.String tag) {
            this.tag = tag;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link JsonFileLogDriverProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public JsonFileLogDriverProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link JsonFileLogDriverProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements JsonFileLogDriverProps {
        private final java.lang.Boolean compress;
        private final java.lang.Number maxFile;
        private final java.lang.String maxSize;
        private final java.util.List<java.lang.String> env;
        private final java.lang.String envRegex;
        private final java.util.List<java.lang.String> labels;
        private final java.lang.String tag;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.compress = software.amazon.jsii.Kernel.get(this, "compress", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.maxFile = software.amazon.jsii.Kernel.get(this, "maxFile", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.maxSize = software.amazon.jsii.Kernel.get(this, "maxSize", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.env = software.amazon.jsii.Kernel.get(this, "env", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.envRegex = software.amazon.jsii.Kernel.get(this, "envRegex", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.labels = software.amazon.jsii.Kernel.get(this, "labels", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.tag = software.amazon.jsii.Kernel.get(this, "tag", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.compress = builder.compress;
            this.maxFile = builder.maxFile;
            this.maxSize = builder.maxSize;
            this.env = builder.env;
            this.envRegex = builder.envRegex;
            this.labels = builder.labels;
            this.tag = builder.tag;
        }

        @Override
        public final java.lang.Boolean getCompress() {
            return this.compress;
        }

        @Override
        public final java.lang.Number getMaxFile() {
            return this.maxFile;
        }

        @Override
        public final java.lang.String getMaxSize() {
            return this.maxSize;
        }

        @Override
        public final java.util.List<java.lang.String> getEnv() {
            return this.env;
        }

        @Override
        public final java.lang.String getEnvRegex() {
            return this.envRegex;
        }

        @Override
        public final java.util.List<java.lang.String> getLabels() {
            return this.labels;
        }

        @Override
        public final java.lang.String getTag() {
            return this.tag;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getCompress() != null) {
                data.set("compress", om.valueToTree(this.getCompress()));
            }
            if (this.getMaxFile() != null) {
                data.set("maxFile", om.valueToTree(this.getMaxFile()));
            }
            if (this.getMaxSize() != null) {
                data.set("maxSize", om.valueToTree(this.getMaxSize()));
            }
            if (this.getEnv() != null) {
                data.set("env", om.valueToTree(this.getEnv()));
            }
            if (this.getEnvRegex() != null) {
                data.set("envRegex", om.valueToTree(this.getEnvRegex()));
            }
            if (this.getLabels() != null) {
                data.set("labels", om.valueToTree(this.getLabels()));
            }
            if (this.getTag() != null) {
                data.set("tag", om.valueToTree(this.getTag()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ecs.JsonFileLogDriverProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            JsonFileLogDriverProps.Jsii$Proxy that = (JsonFileLogDriverProps.Jsii$Proxy) o;

            if (this.compress != null ? !this.compress.equals(that.compress) : that.compress != null) return false;
            if (this.maxFile != null ? !this.maxFile.equals(that.maxFile) : that.maxFile != null) return false;
            if (this.maxSize != null ? !this.maxSize.equals(that.maxSize) : that.maxSize != null) return false;
            if (this.env != null ? !this.env.equals(that.env) : that.env != null) return false;
            if (this.envRegex != null ? !this.envRegex.equals(that.envRegex) : that.envRegex != null) return false;
            if (this.labels != null ? !this.labels.equals(that.labels) : that.labels != null) return false;
            return this.tag != null ? this.tag.equals(that.tag) : that.tag == null;
        }

        @Override
        public final int hashCode() {
            int result = this.compress != null ? this.compress.hashCode() : 0;
            result = 31 * result + (this.maxFile != null ? this.maxFile.hashCode() : 0);
            result = 31 * result + (this.maxSize != null ? this.maxSize.hashCode() : 0);
            result = 31 * result + (this.env != null ? this.env.hashCode() : 0);
            result = 31 * result + (this.envRegex != null ? this.envRegex.hashCode() : 0);
            result = 31 * result + (this.labels != null ? this.labels.hashCode() : 0);
            result = 31 * result + (this.tag != null ? this.tag.hashCode() : 0);
            return result;
        }
    }
}
