package software.amazon.awscdk.services.ecs;

/**
 * This creates a service using the External launch type on an ECS cluster.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Cluster cluster;
 * TaskDefinition taskDefinition;
 * ExternalService service = ExternalService.Builder.create(this, "Service")
 *         .cluster(cluster)
 *         .taskDefinition(taskDefinition)
 *         .desiredCount(5)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-16T18:50:35.806Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ecs.$Module.class, fqn = "@aws-cdk/aws-ecs.ExternalService")
public class ExternalService extends software.amazon.awscdk.services.ecs.BaseService implements software.amazon.awscdk.services.ecs.IExternalService {

    protected ExternalService(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ExternalService(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Constructs a new instance of the ExternalService class.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ExternalService(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.ExternalServiceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Imports from the specified service ARN.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param externalServiceArn This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.IExternalService fromExternalServiceArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String externalServiceArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecs.ExternalService.class, "fromExternalServiceArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.IExternalService.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(externalServiceArn, "externalServiceArn is required") });
    }

    /**
     * Imports from the specified service attributes.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param attrs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.IBaseService fromExternalServiceAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.ExternalServiceAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecs.ExternalService.class, "fromExternalServiceAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.IBaseService.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * Overriden method to throw error as `associateCloudMapService` is not supported for external service.
     * <p>
     * @param _options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void associateCloudMapService(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.AssociateCloudMapServiceOptions _options) {
        software.amazon.jsii.Kernel.call(this, "associateCloudMapService", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(_options, "_options is required") });
    }

    /**
     * Overriden method to throw error as `attachToApplicationTargetGroup` is not supported for external service.
     * <p>
     * @param _targetGroup This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.LoadBalancerTargetProps attachToApplicationTargetGroup(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup _targetGroup) {
        return software.amazon.jsii.Kernel.call(this, "attachToApplicationTargetGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.LoadBalancerTargetProps.class), new Object[] { java.util.Objects.requireNonNull(_targetGroup, "_targetGroup is required") });
    }

    /**
     * Overriden method to throw error as `autoScaleTaskCount` is not supported for external service.
     * <p>
     * @param _props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.ScalableTaskCount autoScaleTaskCount(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.applicationautoscaling.EnableScalingProps _props) {
        return software.amazon.jsii.Kernel.call(this, "autoScaleTaskCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.ScalableTaskCount.class), new Object[] { java.util.Objects.requireNonNull(_props, "_props is required") });
    }

    /**
     * Overriden method to throw error as `configureAwsVpcNetworkingWithSecurityGroups` is not supported for external service.
     * <p>
     * @param _vpc This parameter is required.
     * @param _assignPublicIp
     * @param _vpcSubnets
     * @param _securityGroups
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected void configureAwsVpcNetworkingWithSecurityGroups(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IVpc _vpc, final @org.jetbrains.annotations.Nullable java.lang.Boolean _assignPublicIp, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.SubnetSelection _vpcSubnets, final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> _securityGroups) {
        software.amazon.jsii.Kernel.call(this, "configureAwsVpcNetworkingWithSecurityGroups", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(_vpc, "_vpc is required"), _assignPublicIp, _vpcSubnets, _securityGroups });
    }

    /**
     * Overriden method to throw error as `configureAwsVpcNetworkingWithSecurityGroups` is not supported for external service.
     * <p>
     * @param _vpc This parameter is required.
     * @param _assignPublicIp
     * @param _vpcSubnets
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected void configureAwsVpcNetworkingWithSecurityGroups(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IVpc _vpc, final @org.jetbrains.annotations.Nullable java.lang.Boolean _assignPublicIp, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.SubnetSelection _vpcSubnets) {
        software.amazon.jsii.Kernel.call(this, "configureAwsVpcNetworkingWithSecurityGroups", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(_vpc, "_vpc is required"), _assignPublicIp, _vpcSubnets });
    }

    /**
     * Overriden method to throw error as `configureAwsVpcNetworkingWithSecurityGroups` is not supported for external service.
     * <p>
     * @param _vpc This parameter is required.
     * @param _assignPublicIp
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected void configureAwsVpcNetworkingWithSecurityGroups(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IVpc _vpc, final @org.jetbrains.annotations.Nullable java.lang.Boolean _assignPublicIp) {
        software.amazon.jsii.Kernel.call(this, "configureAwsVpcNetworkingWithSecurityGroups", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(_vpc, "_vpc is required"), _assignPublicIp });
    }

    /**
     * Overriden method to throw error as `configureAwsVpcNetworkingWithSecurityGroups` is not supported for external service.
     * <p>
     * @param _vpc This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected void configureAwsVpcNetworkingWithSecurityGroups(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IVpc _vpc) {
        software.amazon.jsii.Kernel.call(this, "configureAwsVpcNetworkingWithSecurityGroups", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(_vpc, "_vpc is required") });
    }

    /**
     * Overriden method to throw error as `enableCloudMap` is not supported for external service.
     * <p>
     * @param _options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicediscovery.Service enableCloudMap(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.CloudMapOptions _options) {
        return software.amazon.jsii.Kernel.call(this, "enableCloudMap", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.servicediscovery.Service.class), new Object[] { java.util.Objects.requireNonNull(_options, "_options is required") });
    }

    /**
     * Overriden method to throw error as `loadBalancerTarget` is not supported for external service.
     * <p>
     * @param _options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.IEcsLoadBalancerTarget loadBalancerTarget(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.LoadBalancerTargetOptions _options) {
        return software.amazon.jsii.Kernel.call(this, "loadBalancerTarget", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.IEcsLoadBalancerTarget.class), new Object[] { java.util.Objects.requireNonNull(_options, "_options is required") });
    }

    /**
     * Overriden method to throw error as `registerLoadBalancerTargets` is not supported for external service.
     * <p>
     * @param _targets This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void registerLoadBalancerTargets(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.EcsTarget... _targets) {
        software.amazon.jsii.Kernel.call(this, "registerLoadBalancerTargets", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(_targets).toArray(Object[]::new));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ecs.ExternalService}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ecs.ExternalService> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ecs.ExternalServiceProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ecs.ExternalServiceProps.Builder();
        }

        /**
         * The name of the cluster that hosts the service.
         * <p>
         * @return {@code this}
         * @param cluster The name of the cluster that hosts the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cluster(final software.amazon.awscdk.services.ecs.ICluster cluster) {
            this.props.cluster(cluster);
            return this;
        }

        /**
         * A list of Capacity Provider strategies used to place a service.
         * <p>
         * Default: - undefined
         * <p>
         * @return {@code this}
         * @param capacityProviderStrategies A list of Capacity Provider strategies used to place a service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder capacityProviderStrategies(final java.util.List<? extends software.amazon.awscdk.services.ecs.CapacityProviderStrategy> capacityProviderStrategies) {
            this.props.capacityProviderStrategies(capacityProviderStrategies);
            return this;
        }

        /**
         * Whether to enable the deployment circuit breaker.
         * <p>
         * If this property is defined, circuit breaker will be implicitly
         * enabled.
         * <p>
         * Default: - disabled
         * <p>
         * @return {@code this}
         * @param circuitBreaker Whether to enable the deployment circuit breaker. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder circuitBreaker(final software.amazon.awscdk.services.ecs.DeploymentCircuitBreaker circuitBreaker) {
            this.props.circuitBreaker(circuitBreaker);
            return this;
        }

        /**
         * The options for configuring an Amazon ECS service to use service discovery.
         * <p>
         * Default: - AWS Cloud Map service discovery is not enabled.
         * <p>
         * @return {@code this}
         * @param cloudMapOptions The options for configuring an Amazon ECS service to use service discovery. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloudMapOptions(final software.amazon.awscdk.services.ecs.CloudMapOptions cloudMapOptions) {
            this.props.cloudMapOptions(cloudMapOptions);
            return this;
        }

        /**
         * Specifies which deployment controller to use for the service.
         * <p>
         * For more information, see
         * <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-types.html">Amazon ECS Deployment Types</a>
         * <p>
         * Default: - Rolling update (ECS)
         * <p>
         * @return {@code this}
         * @param deploymentController Specifies which deployment controller to use for the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentController(final software.amazon.awscdk.services.ecs.DeploymentController deploymentController) {
            this.props.deploymentController(deploymentController);
            return this;
        }

        /**
         * The desired number of instantiations of the task definition to keep running on the service.
         * <p>
         * Default: - When creating the service, default is 1; when updating the service, default uses
         * the current task number.
         * <p>
         * @return {@code this}
         * @param desiredCount The desired number of instantiations of the task definition to keep running on the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder desiredCount(final java.lang.Number desiredCount) {
            this.props.desiredCount(desiredCount);
            return this;
        }

        /**
         * Specifies whether to enable Amazon ECS managed tags for the tasks within the service.
         * <p>
         * For more information, see
         * <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html">Tagging Your Amazon ECS Resources</a>
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param enableEcsManagedTags Specifies whether to enable Amazon ECS managed tags for the tasks within the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableEcsManagedTags(final java.lang.Boolean enableEcsManagedTags) {
            this.props.enableEcsManagedTags(enableEcsManagedTags);
            return this;
        }

        /**
         * Whether to enable the ability to execute into a container.
         * <p>
         * Default: - undefined
         * <p>
         * @return {@code this}
         * @param enableExecuteCommand Whether to enable the ability to execute into a container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableExecuteCommand(final java.lang.Boolean enableExecuteCommand) {
            this.props.enableExecuteCommand(enableExecuteCommand);
            return this;
        }

        /**
         * The period of time, in seconds, that the Amazon ECS service scheduler ignores unhealthy Elastic Load Balancing target health checks after a task has first started.
         * <p>
         * Default: - defaults to 60 seconds if at least one load balancer is in-use and it is not already set
         * <p>
         * @return {@code this}
         * @param healthCheckGracePeriod The period of time, in seconds, that the Amazon ECS service scheduler ignores unhealthy Elastic Load Balancing target health checks after a task has first started. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthCheckGracePeriod(final software.amazon.awscdk.core.Duration healthCheckGracePeriod) {
            this.props.healthCheckGracePeriod(healthCheckGracePeriod);
            return this;
        }

        /**
         * The maximum number of tasks, specified as a percentage of the Amazon ECS service's DesiredCount value, that can run in a service during a deployment.
         * <p>
         * Default: - 100 if daemon, otherwise 200
         * <p>
         * @return {@code this}
         * @param maxHealthyPercent The maximum number of tasks, specified as a percentage of the Amazon ECS service's DesiredCount value, that can run in a service during a deployment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxHealthyPercent(final java.lang.Number maxHealthyPercent) {
            this.props.maxHealthyPercent(maxHealthyPercent);
            return this;
        }

        /**
         * The minimum number of tasks, specified as a percentage of the Amazon ECS service's DesiredCount value, that must continue to run and remain healthy during a deployment.
         * <p>
         * Default: - 0 if daemon, otherwise 50
         * <p>
         * @return {@code this}
         * @param minHealthyPercent The minimum number of tasks, specified as a percentage of the Amazon ECS service's DesiredCount value, that must continue to run and remain healthy during a deployment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minHealthyPercent(final java.lang.Number minHealthyPercent) {
            this.props.minHealthyPercent(minHealthyPercent);
            return this;
        }

        /**
         * Specifies whether to propagate the tags from the task definition or the service to the tasks in the service.
         * <p>
         * Valid values are: PropagatedTagSource.SERVICE, PropagatedTagSource.TASK_DEFINITION or PropagatedTagSource.NONE
         * <p>
         * Default: PropagatedTagSource.NONE
         * <p>
         * @return {@code this}
         * @param propagateTags Specifies whether to propagate the tags from the task definition or the service to the tasks in the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder propagateTags(final software.amazon.awscdk.services.ecs.PropagatedTagSource propagateTags) {
            this.props.propagateTags(propagateTags);
            return this;
        }

        /**
         * (deprecated) Specifies whether to propagate the tags from the task definition or the service to the tasks in the service.
         * <p>
         * Tags can only be propagated to the tasks within the service during service creation.
         * <p>
         * Default: PropagatedTagSource.NONE
         * <p>
         * @return {@code this}
         * @deprecated Use `propagateTags` instead.
         * @param propagateTaskTagsFrom Specifies whether to propagate the tags from the task definition or the service to the tasks in the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder propagateTaskTagsFrom(final software.amazon.awscdk.services.ecs.PropagatedTagSource propagateTaskTagsFrom) {
            this.props.propagateTaskTagsFrom(propagateTaskTagsFrom);
            return this;
        }

        /**
         * The name of the service.
         * <p>
         * Default: - CloudFormation-generated name.
         * <p>
         * @return {@code this}
         * @param serviceName The name of the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceName(final java.lang.String serviceName) {
            this.props.serviceName(serviceName);
            return this;
        }

        /**
         * The task definition to use for tasks in the service.
         * <p>
         * [disable-awslint:ref-via-interface]
         * <p>
         * @return {@code this}
         * @param taskDefinition The task definition to use for tasks in the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskDefinition(final software.amazon.awscdk.services.ecs.TaskDefinition taskDefinition) {
            this.props.taskDefinition(taskDefinition);
            return this;
        }

        /**
         * The security groups to associate with the service.
         * <p>
         * If you do not specify a security group, a new security group is created.
         * <p>
         * Default: - A new security group is created.
         * <p>
         * @return {@code this}
         * @param securityGroups The security groups to associate with the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroups(final java.util.List<? extends software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups) {
            this.props.securityGroups(securityGroups);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ecs.ExternalService}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ecs.ExternalService build() {
            return new software.amazon.awscdk.services.ecs.ExternalService(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
