package software.amazon.awscdk.services.ecs;

/**
 * The details of the execute command configuration.
 * <p>
 * For more information, see
 * [ExecuteCommandConfiguration] https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-cluster-executecommandconfiguration.html
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * Key kmsKey = new Key(this, "KmsKey");
 * // Pass the KMS key in the `encryptionKey` field to associate the key to the log group
 * LogGroup logGroup = LogGroup.Builder.create(this, "LogGroup")
 *         .encryptionKey(kmsKey)
 *         .build();
 * // Pass the KMS key in the `encryptionKey` field to associate the key to the S3 bucket
 * Bucket execBucket = Bucket.Builder.create(this, "EcsExecBucket")
 *         .encryptionKey(kmsKey)
 *         .build();
 * Cluster cluster = Cluster.Builder.create(this, "Cluster")
 *         .vpc(vpc)
 *         .executeCommandConfiguration(ExecuteCommandConfiguration.builder()
 *                 .kmsKey(kmsKey)
 *                 .logConfiguration(ExecuteCommandLogConfiguration.builder()
 *                         .cloudWatchLogGroup(logGroup)
 *                         .cloudWatchEncryptionEnabled(true)
 *                         .s3Bucket(execBucket)
 *                         .s3EncryptionEnabled(true)
 *                         .s3KeyPrefix("exec-command-output")
 *                         .build())
 *                 .logging(ExecuteCommandLogging.OVERRIDE)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-16T18:50:35.802Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ecs.$Module.class, fqn = "@aws-cdk/aws-ecs.ExecuteCommandConfiguration")
@software.amazon.jsii.Jsii.Proxy(ExecuteCommandConfiguration.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ExecuteCommandConfiguration extends software.amazon.jsii.JsiiSerializable {

    /**
     * The AWS Key Management Service key ID to encrypt the data between the local client and the container.
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getKmsKey() {
        return null;
    }

    /**
     * The log configuration for the results of the execute command actions.
     * <p>
     * The logs can be sent to CloudWatch Logs or an Amazon S3 bucket.
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.ExecuteCommandLogConfiguration getLogConfiguration() {
        return null;
    }

    /**
     * The log settings to use for logging the execute command session.
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.ExecuteCommandLogging getLogging() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ExecuteCommandConfiguration}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ExecuteCommandConfiguration}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ExecuteCommandConfiguration> {
        software.amazon.awscdk.services.kms.IKey kmsKey;
        software.amazon.awscdk.services.ecs.ExecuteCommandLogConfiguration logConfiguration;
        software.amazon.awscdk.services.ecs.ExecuteCommandLogging logging;

        /**
         * Sets the value of {@link ExecuteCommandConfiguration#getKmsKey}
         * @param kmsKey The AWS Key Management Service key ID to encrypt the data between the local client and the container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKey(software.amazon.awscdk.services.kms.IKey kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        /**
         * Sets the value of {@link ExecuteCommandConfiguration#getLogConfiguration}
         * @param logConfiguration The log configuration for the results of the execute command actions.
         *                         The logs can be sent to CloudWatch Logs or an Amazon S3 bucket.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logConfiguration(software.amazon.awscdk.services.ecs.ExecuteCommandLogConfiguration logConfiguration) {
            this.logConfiguration = logConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link ExecuteCommandConfiguration#getLogging}
         * @param logging The log settings to use for logging the execute command session.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logging(software.amazon.awscdk.services.ecs.ExecuteCommandLogging logging) {
            this.logging = logging;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ExecuteCommandConfiguration}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ExecuteCommandConfiguration build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ExecuteCommandConfiguration}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ExecuteCommandConfiguration {
        private final software.amazon.awscdk.services.kms.IKey kmsKey;
        private final software.amazon.awscdk.services.ecs.ExecuteCommandLogConfiguration logConfiguration;
        private final software.amazon.awscdk.services.ecs.ExecuteCommandLogging logging;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.kmsKey = software.amazon.jsii.Kernel.get(this, "kmsKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
            this.logConfiguration = software.amazon.jsii.Kernel.get(this, "logConfiguration", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.ExecuteCommandLogConfiguration.class));
            this.logging = software.amazon.jsii.Kernel.get(this, "logging", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.ExecuteCommandLogging.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.kmsKey = builder.kmsKey;
            this.logConfiguration = builder.logConfiguration;
            this.logging = builder.logging;
        }

        @Override
        public final software.amazon.awscdk.services.kms.IKey getKmsKey() {
            return this.kmsKey;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.ExecuteCommandLogConfiguration getLogConfiguration() {
            return this.logConfiguration;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.ExecuteCommandLogging getLogging() {
            return this.logging;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getKmsKey() != null) {
                data.set("kmsKey", om.valueToTree(this.getKmsKey()));
            }
            if (this.getLogConfiguration() != null) {
                data.set("logConfiguration", om.valueToTree(this.getLogConfiguration()));
            }
            if (this.getLogging() != null) {
                data.set("logging", om.valueToTree(this.getLogging()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ecs.ExecuteCommandConfiguration"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ExecuteCommandConfiguration.Jsii$Proxy that = (ExecuteCommandConfiguration.Jsii$Proxy) o;

            if (this.kmsKey != null ? !this.kmsKey.equals(that.kmsKey) : that.kmsKey != null) return false;
            if (this.logConfiguration != null ? !this.logConfiguration.equals(that.logConfiguration) : that.logConfiguration != null) return false;
            return this.logging != null ? this.logging.equals(that.logging) : that.logging == null;
        }

        @Override
        public final int hashCode() {
            int result = this.kmsKey != null ? this.kmsKey.hashCode() : 0;
            result = 31 * result + (this.logConfiguration != null ? this.logConfiguration.hashCode() : 0);
            result = 31 * result + (this.logging != null ? this.logging.hashCode() : 0);
            return result;
        }
    }
}
