package software.amazon.awscdk.services.ecs;

/**
 * The deployment controller type to use for the service.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Cluster cluster;
 * ApplicationLoadBalancedFargateService loadBalancedFargateService = ApplicationLoadBalancedFargateService.Builder.create(this, "Service")
 *         .cluster(cluster)
 *         .memoryLimitMiB(1024)
 *         .desiredCount(1)
 *         .cpu(512)
 *         .taskImageOptions(ApplicationLoadBalancedTaskImageOptions.builder()
 *                 .image(ContainerImage.fromRegistry("amazon/amazon-ecs-sample"))
 *                 .build())
 *         .deploymentController(DeploymentController.builder()
 *                 .type(DeploymentControllerType.CODE_DEPLOY)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-16T18:50:35.779Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ecs.$Module.class, fqn = "@aws-cdk/aws-ecs.DeploymentControllerType")
public enum DeploymentControllerType {
    /**
     * The rolling update (ECS) deployment type involves replacing the current running version of the container with the latest version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ECS,
    /**
     * The blue/green (CODE_DEPLOY) deployment type uses the blue/green deployment model powered by AWS CodeDeploy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    CODE_DEPLOY,
    /**
     * The external (EXTERNAL) deployment type enables you to use any third-party deployment controller.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    EXTERNAL,
}
