package software.amazon.awscdk.services.ecs;

/**
 * awslogs provides two modes for delivering messages from the container to the log driver.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Cluster cluster;
 * // Create a Task Definition for the container to start
 * Ec2TaskDefinition taskDefinition = new Ec2TaskDefinition(this, "TaskDef");
 * taskDefinition.addContainer("TheContainer", ContainerDefinitionOptions.builder()
 *         .image(ContainerImage.fromAsset(resolve(__dirname, "..", "eventhandler-image")))
 *         .memoryLimitMiB(256)
 *         .logging(AwsLogDriver.Builder.create().streamPrefix("EventDemo").mode(AwsLogDriverMode.NON_BLOCKING).build())
 *         .build());
 * // An Rule that describes the event trigger (in this case a scheduled run)
 * Rule rule = Rule.Builder.create(this, "Rule")
 *         .schedule(Schedule.expression("rate(1 min)"))
 *         .build();
 * // Pass an environment variable to the container 'TheContainer' in the task
 * rule.addTarget(EcsTask.Builder.create()
 *         .cluster(cluster)
 *         .taskDefinition(taskDefinition)
 *         .taskCount(1)
 *         .containerOverrides(List.of(ContainerOverride.builder()
 *                 .containerName("TheContainer")
 *                 .environment(List.of(TaskEnvironmentVariable.builder()
 *                         .name("I_WAS_TRIGGERED")
 *                         .value("From CloudWatch Events")
 *                         .build()))
 *                 .build()))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-16T18:50:35.568Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ecs.$Module.class, fqn = "@aws-cdk/aws-ecs.AwsLogDriverMode")
public enum AwsLogDriverMode {
    /**
     * (default) direct, blocking delivery from container to driver.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BLOCKING,
    /**
     * The non-blocking message delivery mode prevents applications from blocking due to logging back pressure.
     * <p>
     * Applications are likely to fail in unexpected ways when STDERR or STDOUT streams block.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    NON_BLOCKING,
}
