package software.amazon.awscdk.services.ecs;

/**
 * Environment file from a local directory.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.assets.*;
 * import software.amazon.awscdk.services.ecs.*;
 * import software.amazon.awscdk.services.iam.*;
 * import software.amazon.awscdk.core.*;
 * DockerImage dockerImage;
 * IGrantable grantable;
 * ILocalBundling localBundling;
 * AssetEnvironmentFile assetEnvironmentFile = AssetEnvironmentFile.Builder.create("path")
 *         .assetHash("assetHash")
 *         .assetHashType(AssetHashType.SOURCE)
 *         .bundling(BundlingOptions.builder()
 *                 .image(dockerImage)
 *                 // the properties below are optional
 *                 .command(List.of("command"))
 *                 .entrypoint(List.of("entrypoint"))
 *                 .environment(Map.of(
 *                         "environmentKey", "environment"))
 *                 .local(localBundling)
 *                 .outputType(BundlingOutput.ARCHIVED)
 *                 .securityOpt("securityOpt")
 *                 .user("user")
 *                 .volumes(List.of(DockerVolume.builder()
 *                         .containerPath("containerPath")
 *                         .hostPath("hostPath")
 *                         // the properties below are optional
 *                         .consistency(DockerVolumeConsistency.CONSISTENT)
 *                         .build()))
 *                 .workingDirectory("workingDirectory")
 *                 .build())
 *         .exclude(List.of("exclude"))
 *         .follow(FollowMode.NEVER)
 *         .followSymlinks(SymlinkFollowMode.NEVER)
 *         .ignoreMode(IgnoreMode.GLOB)
 *         .readers(List.of(grantable))
 *         .sourceHash("sourceHash")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-16T18:50:35.560Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ecs.$Module.class, fqn = "@aws-cdk/aws-ecs.AssetEnvironmentFile")
public class AssetEnvironmentFile extends software.amazon.awscdk.services.ecs.EnvironmentFile {

    protected AssetEnvironmentFile(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AssetEnvironmentFile(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param path The path to the asset file or directory. This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public AssetEnvironmentFile(final @org.jetbrains.annotations.NotNull java.lang.String path, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.assets.AssetOptions options) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(path, "path is required"), options });
    }

    /**
     * @param path The path to the asset file or directory. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public AssetEnvironmentFile(final @org.jetbrains.annotations.NotNull java.lang.String path) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(path, "path is required") });
    }

    /**
     * Called when the container is initialized to allow this object to bind to the stack.
     * <p>
     * @param scope This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.EnvironmentFileConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.EnvironmentFileConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required") });
    }

    /**
     * The path to the asset file or directory.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getPath() {
        return software.amazon.jsii.Kernel.get(this, "path", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
