package software.amazon.awscdk.services.ec2;

/**
 * A CloudFormation `AWS::EC2::PrefixList`.
 * <p>
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-prefixlist.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:15.055Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnPrefixList")
public class CfnPrefixList extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnPrefixList(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnPrefixList(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.CfnPrefixList.class, "CFN_RESOURCE_TYPE_NAME", java.lang.String.class);
    }

    /**
     * Create a new `AWS::EC2::PrefixList`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnPrefixList(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.CfnPrefixListProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        this.jsiiCall("inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(this.jsiiCall("renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return this.jsiiGet("attrArn", java.lang.String.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrOwnerId() {
        return this.jsiiGet("attrOwnerId", java.lang.String.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrPrefixListId() {
        return this.jsiiGet("attrPrefixListId", java.lang.String.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getAttrVersion() {
        return this.jsiiGet("attrVersion", java.lang.Number.class);
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(this.jsiiGet("cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * `AWS::EC2::PrefixList.Tags`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-prefixlist.html#cfn-ec2-prefixlist-tags
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return this.jsiiGet("tags", software.amazon.awscdk.core.TagManager.class);
    }

    /**
     * `AWS::EC2::PrefixList.AddressFamily`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-prefixlist.html#cfn-ec2-prefixlist-addressfamily
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAddressFamily() {
        return this.jsiiGet("addressFamily", java.lang.String.class);
    }

    /**
     * `AWS::EC2::PrefixList.AddressFamily`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-prefixlist.html#cfn-ec2-prefixlist-addressfamily
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAddressFamily(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        this.jsiiSet("addressFamily", java.util.Objects.requireNonNull(value, "addressFamily is required"));
    }

    /**
     * `AWS::EC2::PrefixList.MaxEntries`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-prefixlist.html#cfn-ec2-prefixlist-maxentries
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getMaxEntries() {
        return this.jsiiGet("maxEntries", java.lang.Number.class);
    }

    /**
     * `AWS::EC2::PrefixList.MaxEntries`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-prefixlist.html#cfn-ec2-prefixlist-maxentries
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMaxEntries(final @org.jetbrains.annotations.NotNull java.lang.Number value) {
        this.jsiiSet("maxEntries", java.util.Objects.requireNonNull(value, "maxEntries is required"));
    }

    /**
     * `AWS::EC2::PrefixList.PrefixListName`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-prefixlist.html#cfn-ec2-prefixlist-prefixlistname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getPrefixListName() {
        return this.jsiiGet("prefixListName", java.lang.String.class);
    }

    /**
     * `AWS::EC2::PrefixList.PrefixListName`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-prefixlist.html#cfn-ec2-prefixlist-prefixlistname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPrefixListName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        this.jsiiSet("prefixListName", java.util.Objects.requireNonNull(value, "prefixListName is required"));
    }

    /**
     * `AWS::EC2::PrefixList.Entries`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-prefixlist.html#cfn-ec2-prefixlist-entries
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEntries() {
        return this.jsiiGet("entries", java.lang.Object.class);
    }

    /**
     * `AWS::EC2::PrefixList.Entries`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-prefixlist.html#cfn-ec2-prefixlist-entries
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEntries(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("entries", value);
    }

    /**
     * `AWS::EC2::PrefixList.Entries`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-prefixlist.html#cfn-ec2-prefixlist-entries
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEntries(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        this.jsiiSet("entries", value);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-prefixlist-entry.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnPrefixList.EntryProperty")
    @software.amazon.jsii.Jsii.Proxy(EntryProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EntryProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnPrefixList.EntryProperty.Cidr`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-prefixlist-entry.html#cfn-ec2-prefixlist-entry-cidr
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCidr();

        /**
         * `CfnPrefixList.EntryProperty.Description`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-prefixlist-entry.html#cfn-ec2-prefixlist-entry-description
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EntryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EntryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EntryProperty> {
            private java.lang.String cidr;
            private java.lang.String description;

            /**
             * Sets the value of {@link EntryProperty#getCidr}
             * @param cidr `CfnPrefixList.EntryProperty.Cidr`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cidr(java.lang.String cidr) {
                this.cidr = cidr;
                return this;
            }

            /**
             * Sets the value of {@link EntryProperty#getDescription}
             * @param description `CfnPrefixList.EntryProperty.Description`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EntryProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EntryProperty build() {
                return new Jsii$Proxy(cidr, description);
            }
        }

        /**
         * An implementation for {@link EntryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EntryProperty {
            private final java.lang.String cidr;
            private final java.lang.String description;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cidr = this.jsiiGet("cidr", java.lang.String.class);
                this.description = this.jsiiGet("description", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String cidr, final java.lang.String description) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cidr = java.util.Objects.requireNonNull(cidr, "cidr is required");
                this.description = description;
            }

            @Override
            public java.lang.String getCidr() {
                return this.cidr;
            }

            @Override
            public java.lang.String getDescription() {
                return this.description;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("cidr", om.valueToTree(this.getCidr()));
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnPrefixList.EntryProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EntryProperty.Jsii$Proxy that = (EntryProperty.Jsii$Proxy) o;

                if (!cidr.equals(that.cidr)) return false;
                return this.description != null ? this.description.equals(that.description) : that.description == null;
            }

            @Override
            public int hashCode() {
                int result = this.cidr.hashCode();
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ec2.CfnPrefixList}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ec2.CfnPrefixList> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ec2.CfnPrefixListProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ec2.CfnPrefixListProps.Builder();
        }

        /**
         * `AWS::EC2::PrefixList.AddressFamily`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-prefixlist.html#cfn-ec2-prefixlist-addressfamily
         * @param addressFamily `AWS::EC2::PrefixList.AddressFamily`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder addressFamily(final java.lang.String addressFamily) {
            this.props.addressFamily(addressFamily);
            return this;
        }

        /**
         * `AWS::EC2::PrefixList.MaxEntries`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-prefixlist.html#cfn-ec2-prefixlist-maxentries
         * @param maxEntries `AWS::EC2::PrefixList.MaxEntries`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxEntries(final java.lang.Number maxEntries) {
            this.props.maxEntries(maxEntries);
            return this;
        }

        /**
         * `AWS::EC2::PrefixList.PrefixListName`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-prefixlist.html#cfn-ec2-prefixlist-prefixlistname
         * @param prefixListName `AWS::EC2::PrefixList.PrefixListName`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder prefixListName(final java.lang.String prefixListName) {
            this.props.prefixListName(prefixListName);
            return this;
        }

        /**
         * `AWS::EC2::PrefixList.Entries`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-prefixlist.html#cfn-ec2-prefixlist-entries
         * @param entries `AWS::EC2::PrefixList.Entries`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder entries(final software.amazon.awscdk.core.IResolvable entries) {
            this.props.entries(entries);
            return this;
        }
        /**
         * `AWS::EC2::PrefixList.Entries`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-prefixlist.html#cfn-ec2-prefixlist-entries
         * @param entries `AWS::EC2::PrefixList.Entries`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder entries(final java.util.List<java.lang.Object> entries) {
            this.props.entries(entries);
            return this;
        }

        /**
         * `AWS::EC2::PrefixList.Tags`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-prefixlist.html#cfn-ec2-prefixlist-tags
         * @param tags `AWS::EC2::PrefixList.Tags`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<software.amazon.awscdk.core.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ec2.CfnPrefixList}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ec2.CfnPrefixList build() {
            return new software.amazon.awscdk.services.ec2.CfnPrefixList(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
