/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ec2;

import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.Resource;
import software.amazon.awscdk.core.TagManager;
import software.amazon.awscdk.services.ec2.;
import software.amazon.awscdk.services.ec2.BlockDevice;
import software.amazon.awscdk.services.ec2.Connections;
import software.amazon.awscdk.services.ec2.CpuCredits;
import software.amazon.awscdk.services.ec2.IConnectable;
import software.amazon.awscdk.services.ec2.ILaunchTemplate;
import software.amazon.awscdk.services.ec2.IMachineImage;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.ec2.InstanceInitiatedShutdownBehavior;
import software.amazon.awscdk.services.ec2.InstanceType;
import software.amazon.awscdk.services.ec2.LaunchTemplateAttributes;
import software.amazon.awscdk.services.ec2.LaunchTemplateProps;
import software.amazon.awscdk.services.ec2.LaunchTemplateSpotOptions;
import software.amazon.awscdk.services.ec2.OperatingSystemType;
import software.amazon.awscdk.services.ec2.UserData;
import software.amazon.awscdk.services.iam.IGrantable;
import software.amazon.awscdk.services.iam.IPrincipal;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-ec2.LaunchTemplate")
public class LaunchTemplate
extends Resource
implements ILaunchTemplate,
IGrantable,
IConnectable {
    protected LaunchTemplate(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected LaunchTemplate(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public LaunchTemplate(@NotNull Construct scope, @NotNull String id, @Nullable LaunchTemplateProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public LaunchTemplate(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    @NotNull
    public static ILaunchTemplate fromLaunchTemplateAttributes(@NotNull Construct scope, @NotNull String id, @NotNull LaunchTemplateAttributes attrs) {
        return (ILaunchTemplate)JsiiObject.jsiiStaticCall(LaunchTemplate.class, (String)"fromLaunchTemplateAttributes", (NativeType)NativeType.forClass(ILaunchTemplate.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    @Override
    @NotNull
    public Connections getConnections() {
        return (Connections)Kernel.get((Object)this, (String)"connections", (NativeType)NativeType.forClass(Connections.class));
    }

    @NotNull
    public String getDefaultVersionNumber() {
        return (String)Kernel.get((Object)this, (String)"defaultVersionNumber", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public IPrincipal getGrantPrincipal() {
        return (IPrincipal)Kernel.get((Object)this, (String)"grantPrincipal", (NativeType)NativeType.forClass(IPrincipal.class));
    }

    @NotNull
    public String getLatestVersionNumber() {
        return (String)Kernel.get((Object)this, (String)"latestVersionNumber", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    protected TagManager getTags() {
        return (TagManager)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.forClass(TagManager.class));
    }

    @Override
    @NotNull
    public String getVersionNumber() {
        return (String)Kernel.get((Object)this, (String)"versionNumber", (NativeType)NativeType.forClass(String.class));
    }

    @Nullable
    public String getImageId() {
        return (String)Kernel.get((Object)this, (String)"imageId", (NativeType)NativeType.forClass(String.class));
    }

    @Nullable
    public InstanceType getInstanceType() {
        return (InstanceType)((Object)Kernel.get((Object)this, (String)"instanceType", (NativeType)NativeType.forClass(InstanceType.class)));
    }

    @Override
    @Nullable
    public String getLaunchTemplateId() {
        return (String)Kernel.get((Object)this, (String)"launchTemplateId", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @Nullable
    public String getLaunchTemplateName() {
        return (String)Kernel.get((Object)this, (String)"launchTemplateName", (NativeType)NativeType.forClass(String.class));
    }

    @Nullable
    public OperatingSystemType getOsType() {
        return (OperatingSystemType)((Object)Kernel.get((Object)this, (String)"osType", (NativeType)NativeType.forClass(OperatingSystemType.class)));
    }

    @Nullable
    public IRole getRole() {
        return (IRole)Kernel.get((Object)this, (String)"role", (NativeType)NativeType.forClass(IRole.class));
    }

    @Nullable
    public UserData getUserData() {
        return (UserData)((Object)Kernel.get((Object)this, (String)"userData", (NativeType)NativeType.forClass(UserData.class)));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<LaunchTemplate> {
        private final Construct scope;
        private final String id;
        private LaunchTemplateProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder blockDevices(List<? extends BlockDevice> blockDevices) {
            this.props().blockDevices(blockDevices);
            return this;
        }

        public Builder cpuCredits(CpuCredits cpuCredits) {
            this.props().cpuCredits(cpuCredits);
            return this;
        }

        public Builder detailedMonitoring(Boolean detailedMonitoring) {
            this.props().detailedMonitoring(detailedMonitoring);
            return this;
        }

        public Builder disableApiTermination(Boolean disableApiTermination) {
            this.props().disableApiTermination(disableApiTermination);
            return this;
        }

        public Builder ebsOptimized(Boolean ebsOptimized) {
            this.props().ebsOptimized(ebsOptimized);
            return this;
        }

        public Builder hibernationConfigured(Boolean hibernationConfigured) {
            this.props().hibernationConfigured(hibernationConfigured);
            return this;
        }

        public Builder instanceInitiatedShutdownBehavior(InstanceInitiatedShutdownBehavior instanceInitiatedShutdownBehavior) {
            this.props().instanceInitiatedShutdownBehavior(instanceInitiatedShutdownBehavior);
            return this;
        }

        public Builder instanceType(InstanceType instanceType) {
            this.props().instanceType(instanceType);
            return this;
        }

        public Builder keyName(String keyName) {
            this.props().keyName(keyName);
            return this;
        }

        public Builder launchTemplateName(String launchTemplateName) {
            this.props().launchTemplateName(launchTemplateName);
            return this;
        }

        public Builder machineImage(IMachineImage machineImage) {
            this.props().machineImage(machineImage);
            return this;
        }

        public Builder nitroEnclaveEnabled(Boolean nitroEnclaveEnabled) {
            this.props().nitroEnclaveEnabled(nitroEnclaveEnabled);
            return this;
        }

        public Builder requireImdsv2(Boolean requireImdsv2) {
            this.props().requireImdsv2(requireImdsv2);
            return this;
        }

        public Builder role(IRole role) {
            this.props().role(role);
            return this;
        }

        public Builder securityGroup(ISecurityGroup securityGroup) {
            this.props().securityGroup(securityGroup);
            return this;
        }

        public Builder spotOptions(LaunchTemplateSpotOptions spotOptions) {
            this.props().spotOptions(spotOptions);
            return this;
        }

        public Builder userData(UserData userData) {
            this.props().userData(userData);
            return this;
        }

        public LaunchTemplate build() {
            return new LaunchTemplate(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private LaunchTemplateProps.Builder props() {
            if (this.props == null) {
                this.props = new LaunchTemplateProps.Builder();
            }
            return this.props;
        }
    }
}

