package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a `CfnNetworkInsightsAccessScope`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * CfnNetworkInsightsAccessScopeProps cfnNetworkInsightsAccessScopeProps = CfnNetworkInsightsAccessScopeProps.builder()
 *         .excludePaths(List.of(AccessScopePathRequestProperty.builder()
 *                 .destination(PathStatementRequestProperty.builder()
 *                         .packetHeaderStatement(PacketHeaderStatementRequestProperty.builder()
 *                                 .destinationAddresses(List.of("destinationAddresses"))
 *                                 .destinationPorts(List.of("destinationPorts"))
 *                                 .destinationPrefixLists(List.of("destinationPrefixLists"))
 *                                 .protocols(List.of("protocols"))
 *                                 .sourceAddresses(List.of("sourceAddresses"))
 *                                 .sourcePorts(List.of("sourcePorts"))
 *                                 .sourcePrefixLists(List.of("sourcePrefixLists"))
 *                                 .build())
 *                         .resourceStatement(ResourceStatementRequestProperty.builder()
 *                                 .resources(List.of("resources"))
 *                                 .resourceTypes(List.of("resourceTypes"))
 *                                 .build())
 *                         .build())
 *                 .source(PathStatementRequestProperty.builder()
 *                         .packetHeaderStatement(PacketHeaderStatementRequestProperty.builder()
 *                                 .destinationAddresses(List.of("destinationAddresses"))
 *                                 .destinationPorts(List.of("destinationPorts"))
 *                                 .destinationPrefixLists(List.of("destinationPrefixLists"))
 *                                 .protocols(List.of("protocols"))
 *                                 .sourceAddresses(List.of("sourceAddresses"))
 *                                 .sourcePorts(List.of("sourcePorts"))
 *                                 .sourcePrefixLists(List.of("sourcePrefixLists"))
 *                                 .build())
 *                         .resourceStatement(ResourceStatementRequestProperty.builder()
 *                                 .resources(List.of("resources"))
 *                                 .resourceTypes(List.of("resourceTypes"))
 *                                 .build())
 *                         .build())
 *                 .throughResources(List.of(ThroughResourcesStatementRequestProperty.builder()
 *                         .resourceStatement(ResourceStatementRequestProperty.builder()
 *                                 .resources(List.of("resources"))
 *                                 .resourceTypes(List.of("resourceTypes"))
 *                                 .build())
 *                         .build()))
 *                 .build()))
 *         .matchPaths(List.of(AccessScopePathRequestProperty.builder()
 *                 .destination(PathStatementRequestProperty.builder()
 *                         .packetHeaderStatement(PacketHeaderStatementRequestProperty.builder()
 *                                 .destinationAddresses(List.of("destinationAddresses"))
 *                                 .destinationPorts(List.of("destinationPorts"))
 *                                 .destinationPrefixLists(List.of("destinationPrefixLists"))
 *                                 .protocols(List.of("protocols"))
 *                                 .sourceAddresses(List.of("sourceAddresses"))
 *                                 .sourcePorts(List.of("sourcePorts"))
 *                                 .sourcePrefixLists(List.of("sourcePrefixLists"))
 *                                 .build())
 *                         .resourceStatement(ResourceStatementRequestProperty.builder()
 *                                 .resources(List.of("resources"))
 *                                 .resourceTypes(List.of("resourceTypes"))
 *                                 .build())
 *                         .build())
 *                 .source(PathStatementRequestProperty.builder()
 *                         .packetHeaderStatement(PacketHeaderStatementRequestProperty.builder()
 *                                 .destinationAddresses(List.of("destinationAddresses"))
 *                                 .destinationPorts(List.of("destinationPorts"))
 *                                 .destinationPrefixLists(List.of("destinationPrefixLists"))
 *                                 .protocols(List.of("protocols"))
 *                                 .sourceAddresses(List.of("sourceAddresses"))
 *                                 .sourcePorts(List.of("sourcePorts"))
 *                                 .sourcePrefixLists(List.of("sourcePrefixLists"))
 *                                 .build())
 *                         .resourceStatement(ResourceStatementRequestProperty.builder()
 *                                 .resources(List.of("resources"))
 *                                 .resourceTypes(List.of("resourceTypes"))
 *                                 .build())
 *                         .build())
 *                 .throughResources(List.of(ThroughResourcesStatementRequestProperty.builder()
 *                         .resourceStatement(ResourceStatementRequestProperty.builder()
 *                                 .resources(List.of("resources"))
 *                                 .resourceTypes(List.of("resourceTypes"))
 *                                 .build())
 *                         .build()))
 *                 .build()))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-28T18:14:38.039Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnNetworkInsightsAccessScopeProps")
@software.amazon.jsii.Jsii.Proxy(CfnNetworkInsightsAccessScopeProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnNetworkInsightsAccessScopeProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The paths to exclude.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getExcludePaths() {
        return null;
    }

    /**
     * The paths to match.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getMatchPaths() {
        return null;
    }

    /**
     * The tags.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnNetworkInsightsAccessScopeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnNetworkInsightsAccessScopeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnNetworkInsightsAccessScopeProps> {
        java.lang.Object excludePaths;
        java.lang.Object matchPaths;
        java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Sets the value of {@link CfnNetworkInsightsAccessScopeProps#getExcludePaths}
         * @param excludePaths The paths to exclude.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder excludePaths(software.amazon.awscdk.core.IResolvable excludePaths) {
            this.excludePaths = excludePaths;
            return this;
        }

        /**
         * Sets the value of {@link CfnNetworkInsightsAccessScopeProps#getExcludePaths}
         * @param excludePaths The paths to exclude.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder excludePaths(java.util.List<? extends java.lang.Object> excludePaths) {
            this.excludePaths = excludePaths;
            return this;
        }

        /**
         * Sets the value of {@link CfnNetworkInsightsAccessScopeProps#getMatchPaths}
         * @param matchPaths The paths to match.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder matchPaths(software.amazon.awscdk.core.IResolvable matchPaths) {
            this.matchPaths = matchPaths;
            return this;
        }

        /**
         * Sets the value of {@link CfnNetworkInsightsAccessScopeProps#getMatchPaths}
         * @param matchPaths The paths to match.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder matchPaths(java.util.List<? extends java.lang.Object> matchPaths) {
            this.matchPaths = matchPaths;
            return this;
        }

        /**
         * Sets the value of {@link CfnNetworkInsightsAccessScopeProps#getTags}
         * @param tags The tags.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnNetworkInsightsAccessScopeProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnNetworkInsightsAccessScopeProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnNetworkInsightsAccessScopeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnNetworkInsightsAccessScopeProps {
        private final java.lang.Object excludePaths;
        private final java.lang.Object matchPaths;
        private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.excludePaths = software.amazon.jsii.Kernel.get(this, "excludePaths", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.matchPaths = software.amazon.jsii.Kernel.get(this, "matchPaths", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.excludePaths = builder.excludePaths;
            this.matchPaths = builder.matchPaths;
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Object getExcludePaths() {
            return this.excludePaths;
        }

        @Override
        public final java.lang.Object getMatchPaths() {
            return this.matchPaths;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getExcludePaths() != null) {
                data.set("excludePaths", om.valueToTree(this.getExcludePaths()));
            }
            if (this.getMatchPaths() != null) {
                data.set("matchPaths", om.valueToTree(this.getMatchPaths()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnNetworkInsightsAccessScopeProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnNetworkInsightsAccessScopeProps.Jsii$Proxy that = (CfnNetworkInsightsAccessScopeProps.Jsii$Proxy) o;

            if (this.excludePaths != null ? !this.excludePaths.equals(that.excludePaths) : that.excludePaths != null) return false;
            if (this.matchPaths != null ? !this.matchPaths.equals(that.matchPaths) : that.matchPaths != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.excludePaths != null ? this.excludePaths.hashCode() : 0;
            result = 31 * result + (this.matchPaths != null ? this.matchPaths.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
