package software.amazon.awscdk.services.ec2;

/**
 * What class and generation of instance to use.
 * <p>
 * We have both symbolic and concrete enums for every type.
 * <p>
 * The first are for people that want to specify by purpose,
 * the second one are for people who already know exactly what
 * 'R4' means.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * DatabaseInstance sourceInstance;
 * DatabaseInstanceFromSnapshot.Builder.create(this, "Instance")
 *         .snapshotIdentifier("my-snapshot")
 *         .engine(DatabaseInstanceEngine.postgres(PostgresInstanceEngineProps.builder().version(PostgresEngineVersion.VER_12_3).build()))
 *         // optional, defaults to m5.large
 *         .instanceType(InstanceType.of(InstanceClass.BURSTABLE2, InstanceSize.LARGE))
 *         .vpc(vpc)
 *         .build();
 * DatabaseInstanceReadReplica.Builder.create(this, "ReadReplica")
 *         .sourceDatabaseInstance(sourceInstance)
 *         .instanceType(InstanceType.of(InstanceClass.BURSTABLE2, InstanceSize.LARGE))
 *         .vpc(vpc)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-16T18:50:29.121Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.InstanceClass")
public enum InstanceClass {
    /**
     * Standard instances, 3rd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STANDARD3,
    /**
     * Standard instances, 3rd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    M3,
    /**
     * Standard instances, 4th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STANDARD4,
    /**
     * Standard instances, 4th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    M4,
    /**
     * Standard instances, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STANDARD5,
    /**
     * Standard instances, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    M5,
    /**
     * Standard instances with local NVME drive, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STANDARD5_NVME_DRIVE,
    /**
     * Standard instances with local NVME drive, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    M5D,
    /**
     * Standard instances based on AMD EPYC, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STANDARD5_AMD,
    /**
     * Standard instances based on AMD EPYC, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    M5A,
    /**
     * Standard instances based on AMD EPYC with local NVME drive, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STANDARD5_AMD_NVME_DRIVE,
    /**
     * Standard instances based on AMD EPYC with local NVME drive, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    M5AD,
    /**
     * Standard instances for high performance computing, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STANDARD5_HIGH_PERFORMANCE,
    /**
     * Standard instances for high performance computing, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    M5N,
    /**
     * Standard instances with local NVME drive for high performance computing, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STANDARD5_NVME_DRIVE_HIGH_PERFORMANCE,
    /**
     * Standard instances with local NVME drive for high performance computing, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    M5DN,
    /**
     * Standard instances with high memory and compute capacity based on Intel Xeon Scalable (Cascade Lake) processors, 5nd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STANDARD5_HIGH_COMPUTE,
    /**
     * Standard instances with high memory and compute capacity based on Intel Xeon Scalable (Cascade Lake) processors, 5nd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    M5ZN,
    /**
     * Memory optimized instances, 3rd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MEMORY3,
    /**
     * Memory optimized instances, 3rd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    R3,
    /**
     * Memory optimized instances, 4th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MEMORY4,
    /**
     * Memory optimized instances, 4th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    R4,
    /**
     * Memory optimized instances, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MEMORY5,
    /**
     * Memory optimized instances, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    R5,
    /**
     * Memory optimized instances, 6th generation with Intel Xeon Scalable processors (3rd generation processors code named Ice Lake).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MEMORY6_INTEL,
    /**
     * Memory optimized instances, 6th generation with Intel Xeon Scalable processors (3rd generation processors code named Ice Lake).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    R6I,
    /**
     * Memory optimized instances for high performance computing, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MEMORY5_HIGH_PERFORMANCE,
    /**
     * Memory optimized instances for high performance computing, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    R5N,
    /**
     * Memory optimized instances with local NVME drive, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MEMORY5_NVME_DRIVE,
    /**
     * Memory optimized instances with local NVME drive, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    R5D,
    /**
     * Memory optimized instances with local NVME drive for high performance computing, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MEMORY5_NVME_DRIVE_HIGH_PERFORMANCE,
    /**
     * Memory optimized instances with local NVME drive for high performance computing, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    R5DN,
    /**
     * Memory optimized instances based on AMD EPYC, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MEMORY5_AMD,
    /**
     * Memory optimized instances based on AMD EPYC, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    R5A,
    /**
     * Memory optimized instances based on AMD EPYC with local NVME drive, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MEMORY5_AMD_NVME_DRIVE,
    /**
     * High memory instances (6TB) based on Intel Xeon Platinum 8176M (Skylake) processors, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    HIGH_MEMORY_6TB_1,
    /**
     * High memory instances (6TB) based on Intel Xeon Platinum 8176M (Skylake) processors, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    U_6TB1,
    /**
     * High memory instances (9TB) based on Intel Xeon Platinum 8176M (Skylake) processors, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    HIGH_MEMORY_9TB_1,
    /**
     * High memory instances (9TB) based on Intel Xeon Platinum 8176M (Skylake) processors, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    U_9TB1,
    /**
     * High memory instances (12TB) based on Intel Xeon Platinum 8176M (Skylake) processors, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    HIGH_MEMORY_12TB_1,
    /**
     * High memory instances (12TB) based on Intel Xeon Platinum 8176M (Skylake) processors, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    U_12TB1,
    /**
     * High memory instances (18TB) based on Intel Xeon Scalable (Cascade Lake) processors, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    HIGH_MEMORY_18TB_1,
    /**
     * High memory instances (18TB) based on Intel Xeon Scalable (Cascade Lake) processors, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    U_18TB1,
    /**
     * High memory instances (24TB) based on Intel Xeon Scalable (Cascade Lake) processors, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    HIGH_MEMORY_24TB_1,
    /**
     * High memory instances (24TB) based on Intel Xeon Scalable (Cascade Lake) processors, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    U_24TB1,
    /**
     * Memory optimized instances based on AMD EPYC with local NVME drive, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    R5AD,
    /**
     * Memory optimized instances that are also EBS-optimized, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MEMORY5_EBS_OPTIMIZED,
    /**
     * Memory optimized instances that are also EBS-optimized, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    R5B,
    /**
     * Memory optimized instances, 6th generation with Graviton2 processors.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MEMORY6_GRAVITON,
    /**
     * Memory optimized instances, 6th generation with Graviton2 processors.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    R6G,
    /**
     * Memory optimized instances, 6th generation with Graviton2 processors and local NVME drive.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MEMORY6_GRAVITON2_NVME_DRIVE,
    /**
     * Memory optimized instances, 6th generation with Graviton2 processors and local NVME drive.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    R6GD,
    /**
     * Compute optimized instances, 3rd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    COMPUTE3,
    /**
     * Compute optimized instances, 3rd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    C3,
    /**
     * Compute optimized instances, 4th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    COMPUTE4,
    /**
     * Compute optimized instances, 4th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    C4,
    /**
     * Compute optimized instances, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    COMPUTE5,
    /**
     * Compute optimized instances, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    C5,
    /**
     * Compute optimized instances with local NVME drive, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    COMPUTE5_NVME_DRIVE,
    /**
     * Compute optimized instances with local NVME drive, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    C5D,
    /**
     * Compute optimized instances based on AMD EPYC, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    COMPUTE5_AMD,
    /**
     * Compute optimized instances based on AMD EPYC, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    C5A,
    /**
     * Compute optimized instances with local NVME drive based on AMD EPYC, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    COMPUTE5_AMD_NVME_DRIVE,
    /**
     * Compute optimized instances with local NVME drive based on AMD EPYC, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    C5AD,
    /**
     * Compute optimized instances for high performance computing, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    COMPUTE5_HIGH_PERFORMANCE,
    /**
     * Compute optimized instances for high performance computing, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    C5N,
    /**
     * Compute optimized instances, 6th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    COMPUTE6_INTEL,
    /**
     * Compute optimized instances, 6th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    C6I,
    /**
     * Compute optimized instances based on AMD EPYC (codename Milan), 6th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    COMPUTE6_AMD,
    /**
     * Compute optimized instances based on AMD EPYC (codename Milan), 6th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    C6A,
    /**
     * Compute optimized instances for high performance computing, 6th generation with Graviton2 processors.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    COMPUTE6_GRAVITON2,
    /**
     * Compute optimized instances for high performance computing, 6th generation with Graviton2 processors.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    C6G,
    /**
     * Compute optimized instances for high performance computing, 6th generation with Graviton2 processors and local NVME drive.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    COMPUTE6_GRAVITON2_NVME_DRIVE,
    /**
     * Compute optimized instances for high performance computing, 6th generation with Graviton2 processors and local NVME drive.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    C6GD,
    /**
     * Compute optimized instances for high performance computing, 6th generation with Graviton2 processors and high network bandwidth capabilities.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    COMPUTE6_GRAVITON2_HIGH_NETWORK_BANDWITH,
    /**
     * Compute optimized instances for high performance computing, 6th generation with Graviton2 processors and high network bandwidth capabilities.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    COMPUTE6_GRAVITON2_HIGH_NETWORK_BANDWIDTH,
    /**
     * Compute optimized instances for high performance computing, 6th generation with Graviton2 processors and high network bandwidth capabilities.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    C6GN,
    /**
     * Storage-optimized instances, 2nd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STORAGE2,
    /**
     * Storage-optimized instances, 2nd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    D2,
    /**
     * Storage-optimized instances, 3rd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STORAGE3,
    /**
     * Storage-optimized instances, 3rd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    D3,
    /**
     * Storage-optimized instances, 3rd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STORAGE3_ENHANCED_NETWORK,
    /**
     * Storage-optimized instances, 3rd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    D3EN,
    /**
     * Storage/compute balanced instances, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STORAGE_COMPUTE_1,
    /**
     * Storage/compute balanced instances, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    H1,
    /**
     * I/O-optimized instances, 3rd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    IO3,
    /**
     * I/O-optimized instances, 3rd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    I3,
    /**
     * I/O-optimized instances with local NVME drive, 3rd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    IO3_DENSE_NVME_DRIVE,
    /**
     * I/O-optimized instances with local NVME drive, 3rd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    I3EN,
    /**
     * I/O-optimized instances with local NVME drive powered by Intel Xeon Scalable processors (code named Ice Lake), 4th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    IO4_INTEL,
    /**
     * I/O-optimized instances with local NVME drive powered by Intel Xeon Scalable processors (code named Ice Lake), 4th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    I4I,
    /**
     * Storage optimized instances powered by Graviton2 processor, 4th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STORAGE4_GRAVITON_NETWORK_OPTIMIZED,
    /**
     * Storage optimized instances powered by Graviton2 processor, 4th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    IM4GN,
    /**
     * Storage optimized instances powered by Graviton2 processor, 4th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STORAGE4_GRAVITON_NETWORK_STORAGE_OPTIMIZED,
    /**
     * Storage optimized instances powered by Graviton2 processor, 4th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    IS4GEN,
    /**
     * Burstable instances, 2nd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BURSTABLE2,
    /**
     * Burstable instances, 2nd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    T2,
    /**
     * Burstable instances, 3rd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BURSTABLE3,
    /**
     * Burstable instances, 3rd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    T3,
    /**
     * Burstable instances based on AMD EPYC, 3rd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BURSTABLE3_AMD,
    /**
     * Burstable instances based on AMD EPYC, 3rd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    T3A,
    /**
     * Burstable instances, 4th generation with Graviton2 processors.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BURSTABLE4_GRAVITON,
    /**
     * Burstable instances, 4th generation with Graviton2 processors.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    T4G,
    /**
     * Memory-intensive instances, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MEMORY_INTENSIVE_1,
    /**
     * Memory-intensive instances, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    X1,
    /**
     * Memory-intensive instances, extended, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MEMORY_INTENSIVE_1_EXTENDED,
    /**
     * Memory-intensive instances, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    X1E,
    /**
     * Memory-intensive instances, 2nd generation with Graviton2 processors.
     * <p>
     * This instance type can be used only in RDS. It is not supported in EC2.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MEMORY_INTENSIVE_2_GRAVITON2,
    /**
     * Memory-intensive instances, 2nd generation with Graviton2 processors.
     * <p>
     * This instance type can be used only in RDS. It is not supported in EC2.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    X2G,
    /**
     * Memory-intensive instances, 2nd generation with Graviton2 processors and local NVME drive.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MEMORY_INTENSIVE_2_GRAVITON2_NVME_DRIVE,
    /**
     * Memory-intensive instances, 2nd generation with Graviton2 processors and local NVME drive.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    X2GD,
    /**
     * Memory-intensive instances with higher network bandwith, local NVME drive, and extended memory.
     * <p>
     * Intel Xeon Scalable (Ice Lake) processors
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MEMORY_INTENSIVE_2_XT_INTEL,
    /**
     * Memory-intensive instances with higher network bandwith, local NVME drive, and extended memory.
     * <p>
     * Intel Xeon Scalable (Ice Lake) processors
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    X2IEDN,
    /**
     * Memory-intensive instances with higher network bandwith and local NVME drive, Intel Xeon Scalable (Ice Lake) processors.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MEMORY_INTENSIVE_2_INTEL,
    /**
     * Memory-intensive instances with higher network bandwith and local NVME drive, Intel Xeon Scalable (Ice Lake) processors.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    X2IDN,
    /**
     * Memory-intensive instances with higher network bandwith and single-threaded performance, Intel Xeon Scalable (Cascade Lake) processors.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MEMORY_INTENSIVE_2_XTZ_INTEL,
    /**
     * Memory-intensive instances with higher network bandwith and single-threaded performance, Intel Xeon Scalable (Cascade Lake) processors.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    X2IEZN,
    /**
     * Instances with customizable hardware acceleration, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    FPGA1,
    /**
     * Instances with customizable hardware acceleration, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    F1,
    /**
     * Graphics-optimized instances, 3rd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    GRAPHICS3,
    /**
     * Graphics-optimized instances, 3rd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    G3,
    /**
     * Graphics-optimized instances with NVME drive for high performance computing, 4th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    GRAPHICS4_NVME_DRIVE_HIGH_PERFORMANCE,
    /**
     * Graphics-optimized instances with NVME drive for high performance computing, 4th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    G4DN,
    /**
     * Graphics-optimized instances based on AMD EPYC And Radeon Pro GPU (NAVI) with local NVME drive, 4th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    GRAPHICS4_AMD_NVME_DRIVE,
    /**
     * Graphics-optimized instances based on AMD EPYC And Radeon Pro GPU (NAVI) with local NVME drive, 4th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    G4AD,
    /**
     * Graphics-optimized instances, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    GRAPHICS5,
    /**
     * Graphics-optimized instances, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    G5,
    /**
     * Graphics-optimized instances powered by AWS Graviton2 Processors and NVIDIA T4G Tensor Core GPUs, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    GRAPHICS5_GRAVITON2,
    /**
     * Graphics-optimized instances powered by AWS Graviton2 Processors and NVIDIA T4G Tensor Core GPUs, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    G5G,
    /**
     * Parallel-processing optimized instances, 2nd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PARALLEL2,
    /**
     * Parallel-processing optimized instances, 2nd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    P2,
    /**
     * Parallel-processing optimized instances, 3nd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PARALLEL3,
    /**
     * Parallel-processing optimized instances, 3rd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    P3,
    /**
     * Parallel-processing optimized instances, 4th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PARALLEL4,
    /**
     * Parallel-processing optimized instances, 4th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    P4D,
    /**
     * Arm processor based instances, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ARM1,
    /**
     * Arm processor based instances, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    A1,
    /**
     * Arm processor based instances, 2nd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STANDARD6_GRAVITON,
    /**
     * Arm processor based instances, 2nd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    M6G,
    /**
     * Standard instances based on Intel (Ice Lake), 6th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STANDARD6_INTEL,
    /**
     * Standard instances based on Intel (Ice Lake), 6th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    M6I,
    /**
     * Standard instances based on 3rd Gen AMD EPYC processors, 6th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STANDARD6_AMD,
    /**
     * Standard instances based on 3rd Gen AMD EPYC processors, 6th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    M6A,
    /**
     * Standard instances, 6th generation with Graviton2 processors and local NVME drive.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STANDARD6_GRAVITON2_NVME_DRIVE,
    /**
     * Standard instances, 6th generation with Graviton2 processors and local NVME drive.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    M6GD,
    /**
     * High memory and compute capacity instances, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    HIGH_COMPUTE_MEMORY1,
    /**
     * High memory and compute capacity instances, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    Z1D,
    /**
     * Inferentia Chips based instances for machine learning inference applications, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    INFERENCE1,
    /**
     * Inferentia Chips based instances for machine learning inference applications, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    INF1,
    /**
     * Macintosh instances built on Apple Mac mini computers, 1st generation with Intel procesors.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MACINTOSH1_INTEL,
    /**
     * Macintosh instances built on Apple Mac mini computers, 1st generation with Intel procesors.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MAC1,
    /**
     * Multi-stream video transcoding instances for resolutions up to 4K UHD, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    VIDEO_TRANSCODING1,
    /**
     * Multi-stream video transcoding instances for resolutions up to 4K UHD, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    VT1,
    /**
     * High performance computing based on AMD EPYC, 6th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    HIGH_PERFORMANCE_COMPUTING6_AMD,
    /**
     * High performance computing based on AMD EPYC, 6th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    HPC6A,
}
