package software.amazon.awscdk.core;

/**
 * Use the original deployment environment.
 * <p>
 * This deployment environment is restricted in cross-environment deployments,
 * CI/CD deployments, and will use up CloudFormation parameters in your template.
 * <p>
 * This is the only StackSynthesizer that supports customizing asset behavior
 * by overriding <code>Stack.addFileAsset()</code> and <code>Stack.addDockerImageAsset()</code>.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.27.0 (build 07d848a)", date = "2021-04-06T14:01:45.984Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "@aws-cdk/core.LegacyStackSynthesizer")
public class LegacyStackSynthesizer extends software.amazon.awscdk.core.StackSynthesizer {

    protected LegacyStackSynthesizer(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected LegacyStackSynthesizer(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public LegacyStackSynthesizer() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Register a Docker Image Asset.
     * <p>
     * Returns the parameters that can be used to refer to the asset inside the template.
     * <p>
     * @param asset This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.DockerImageAssetLocation addDockerImageAsset(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.DockerImageAssetSource asset) {
        return software.amazon.jsii.Kernel.call(this, "addDockerImageAsset", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.DockerImageAssetLocation.class), new Object[] { java.util.Objects.requireNonNull(asset, "asset is required") });
    }

    /**
     * Register a File Asset.
     * <p>
     * Returns the parameters that can be used to refer to the asset inside the template.
     * <p>
     * @param asset This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.FileAssetLocation addFileAsset(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.FileAssetSource asset) {
        return software.amazon.jsii.Kernel.call(this, "addFileAsset", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.FileAssetLocation.class), new Object[] { java.util.Objects.requireNonNull(asset, "asset is required") });
    }

    /**
     * Bind to the stack this environment is going to be used on.
     * <p>
     * Must be called before any of the other methods are called.
     * <p>
     * @param stack This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Stack stack) {
        software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(stack, "stack is required") });
    }

    /**
     * Synthesize the associated stack to the session.
     * <p>
     * @param session This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void synthesize(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ISynthesisSession session) {
        software.amazon.jsii.Kernel.call(this, "synthesize", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(session, "session is required") });
    }
}
