package software.amazon.awscdk.core;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.24.0 (build b722f66)", date = "2021-03-17T00:03:50.320Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "@aws-cdk/core.Arn")
public class Arn extends software.amazon.jsii.JsiiObject {

    protected Arn(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Arn(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Extract the full resource name from an ARN.
     * <p>
     * Necessary for resource names (paths) that may contain the separator, like
     * <code>arn:aws:iam::111111111111:role/path/to/role/name</code>.
     * <p>
     * Only works if we statically know the expected <code>resourceType</code> beforehand, since we're going
     * to use that to split the string on ':<resourceType>/' (and take the right-hand side).
     * <p>
     * We can't extract the 'resourceType' from the ARN at hand, because CloudFormation Expressions
     * only allow literals in the 'separator' argument to <code>{ Fn::Split }</code>, and so it can't be
     * <code>{ Fn::Select: [5, { Fn::Split: [':', ARN] }}</code>.
     * <p>
     * Only necessary for ARN formats for which the type-name separator is <code>/</code>.
     * <p>
     * @param arn This parameter is required.
     * @param resourceType This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String extractResourceName(final @org.jetbrains.annotations.NotNull java.lang.String arn, final @org.jetbrains.annotations.NotNull java.lang.String resourceType) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Arn.class, "extractResourceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(arn, "arn is required"), java.util.Objects.requireNonNull(resourceType, "resourceType is required") });
    }

    /**
     * Creates an ARN from components.
     * <p>
     * If <code>partition</code>, <code>region</code> or <code>account</code> are not specified, the stack's
     * partition, region and account will be used.
     * <p>
     * If any component is the empty string, an empty string will be inserted
     * into the generated ARN at the location that component corresponds to.
     * <p>
     * The ARN will be formatted as follows:
     * <p>
     * arn:{partition}:{service}:{region}:{account}:{resource}{sep}{resource-name}
     * <p>
     * The required ARN pieces that are omitted will be taken from the stack that
     * the 'scope' is attached to. If all ARN pieces are supplied, the supplied scope
     * can be 'undefined'.
     * <p>
     * @param components This parameter is required.
     * @param stack This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String format(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ArnComponents components, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Stack stack) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Arn.class, "format", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(components, "components is required"), java.util.Objects.requireNonNull(stack, "stack is required") });
    }

    /**
     * Given an ARN, parses it and returns components.
     * <p>
     * IF THE ARN IS A CONCRETE STRING...
     * <p>
     * ...it will be parsed and validated. The separator (<code>sep</code>) will be set to '/'
     * if the 6th component includes a '/', in which case, <code>resource</code> will be set
     * to the value before the '/' and <code>resourceName</code> will be the rest. In case
     * there is no '/', <code>resource</code> will be set to the 6th components and
     * <code>resourceName</code> will be set to the rest of the string.
     * <p>
     * IF THE ARN IS A TOKEN...
     * <p>
     * ...it cannot be validated, since we don't have the actual value yet at the
     * time of this function call. You will have to supply <code>sepIfToken</code> and
     * whether or not ARNs of the expected format usually have resource names
     * in order to parse it properly. The resulting <code>ArnComponents</code> object will
     * contain tokens for the subexpressions of the ARN, not string literals.
     * <p>
     * If the resource name could possibly contain the separator char, the actual
     * resource name cannot be properly parsed. This only occurs if the separator
     * char is '/', and happens for example for S3 object ARNs, IAM Role ARNs,
     * IAM OIDC Provider ARNs, etc. To properly extract the resource name from a
     * Tokenized ARN, you must know the resource type and call
     * <code>Arn.extractResourceName</code>.
     * <p>
     * @return an ArnComponents object which allows access to the various
     * components of the ARN.
     * @param arn The ARN to parse. This parameter is required.
     * @param sepIfToken The separator used to separate resource from resourceName.
     * @param hasName Whether there is a name component in the ARN at all.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ArnComponents parse(final @org.jetbrains.annotations.NotNull java.lang.String arn, final @org.jetbrains.annotations.Nullable java.lang.String sepIfToken, final @org.jetbrains.annotations.Nullable java.lang.Boolean hasName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Arn.class, "parse", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.ArnComponents.class), new Object[] { java.util.Objects.requireNonNull(arn, "arn is required"), sepIfToken, hasName });
    }

    /**
     * Given an ARN, parses it and returns components.
     * <p>
     * IF THE ARN IS A CONCRETE STRING...
     * <p>
     * ...it will be parsed and validated. The separator (<code>sep</code>) will be set to '/'
     * if the 6th component includes a '/', in which case, <code>resource</code> will be set
     * to the value before the '/' and <code>resourceName</code> will be the rest. In case
     * there is no '/', <code>resource</code> will be set to the 6th components and
     * <code>resourceName</code> will be set to the rest of the string.
     * <p>
     * IF THE ARN IS A TOKEN...
     * <p>
     * ...it cannot be validated, since we don't have the actual value yet at the
     * time of this function call. You will have to supply <code>sepIfToken</code> and
     * whether or not ARNs of the expected format usually have resource names
     * in order to parse it properly. The resulting <code>ArnComponents</code> object will
     * contain tokens for the subexpressions of the ARN, not string literals.
     * <p>
     * If the resource name could possibly contain the separator char, the actual
     * resource name cannot be properly parsed. This only occurs if the separator
     * char is '/', and happens for example for S3 object ARNs, IAM Role ARNs,
     * IAM OIDC Provider ARNs, etc. To properly extract the resource name from a
     * Tokenized ARN, you must know the resource type and call
     * <code>Arn.extractResourceName</code>.
     * <p>
     * @return an ArnComponents object which allows access to the various
     * components of the ARN.
     * @param arn The ARN to parse. This parameter is required.
     * @param sepIfToken The separator used to separate resource from resourceName.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ArnComponents parse(final @org.jetbrains.annotations.NotNull java.lang.String arn, final @org.jetbrains.annotations.Nullable java.lang.String sepIfToken) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Arn.class, "parse", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.ArnComponents.class), new Object[] { java.util.Objects.requireNonNull(arn, "arn is required"), sepIfToken });
    }

    /**
     * Given an ARN, parses it and returns components.
     * <p>
     * IF THE ARN IS A CONCRETE STRING...
     * <p>
     * ...it will be parsed and validated. The separator (<code>sep</code>) will be set to '/'
     * if the 6th component includes a '/', in which case, <code>resource</code> will be set
     * to the value before the '/' and <code>resourceName</code> will be the rest. In case
     * there is no '/', <code>resource</code> will be set to the 6th components and
     * <code>resourceName</code> will be set to the rest of the string.
     * <p>
     * IF THE ARN IS A TOKEN...
     * <p>
     * ...it cannot be validated, since we don't have the actual value yet at the
     * time of this function call. You will have to supply <code>sepIfToken</code> and
     * whether or not ARNs of the expected format usually have resource names
     * in order to parse it properly. The resulting <code>ArnComponents</code> object will
     * contain tokens for the subexpressions of the ARN, not string literals.
     * <p>
     * If the resource name could possibly contain the separator char, the actual
     * resource name cannot be properly parsed. This only occurs if the separator
     * char is '/', and happens for example for S3 object ARNs, IAM Role ARNs,
     * IAM OIDC Provider ARNs, etc. To properly extract the resource name from a
     * Tokenized ARN, you must know the resource type and call
     * <code>Arn.extractResourceName</code>.
     * <p>
     * @return an ArnComponents object which allows access to the various
     * components of the ARN.
     * @param arn The ARN to parse. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ArnComponents parse(final @org.jetbrains.annotations.NotNull java.lang.String arn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Arn.class, "parse", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.ArnComponents.class), new Object[] { java.util.Objects.requireNonNull(arn, "arn is required") });
    }
}
