package software.amazon.awscdk.core;

/**
 * (experimental) Bundling options.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.21.0 (build 4262b22)", date = "2021-02-19T10:08:32.079Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "@aws-cdk/core.BundlingOptions")
@software.amazon.jsii.Jsii.Proxy(BundlingOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface BundlingOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The Docker image where the command will run.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.BundlingDockerImage getImage();

    /**
     * (experimental) The command to run in the Docker container.
     * <p>
     * Default: - run the command defined in the image
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>{@code
     * // Example automatically generated. See https://github.com/aws/jsii/issues/826
     * asList("npm", "install");}</pre></blockquote>
     * <p>
     * @see https://docs.docker.com/engine/reference/run/
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCommand() {
        return null;
    }

    /**
     * (experimental) The entrypoint to run in the Docker container.
     * <p>
     * Default: - run the entrypoint defined in the image
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>{@code
     * // Example automatically generated. See https://github.com/aws/jsii/issues/826
     * asList("/bin/sh", "-c");}</pre></blockquote>
     * <p>
     * @see https://docs.docker.com/engine/reference/builder/#entrypoint
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getEntrypoint() {
        return null;
    }

    /**
     * (experimental) The environment variables to pass to the Docker container.
     * <p>
     * Default: - no environment variables.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getEnvironment() {
        return null;
    }

    /**
     * (experimental) Local bundling provider.
     * <p>
     * The provider implements a method <code>tryBundle()</code> which should return <code>true</code>
     * if local bundling was performed. If <code>false</code> is returned, docker bundling
     * will be done.
     * <p>
     * Default: - bundling will only be performed in a Docker container
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.ILocalBundling getLocal() {
        return null;
    }

    /**
     * (experimental) The user to use when running the Docker container.
     * <p>
     * user | user:group | uid | uid:gid | user:gid | uid:group
     * <p>
     * Default: - uid:gid of the current user or 1000:1000 on Windows
     * <p>
     * @see https://docs.docker.com/engine/reference/run/#user
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getUser() {
        return null;
    }

    /**
     * (experimental) Additional Docker volumes to mount.
     * <p>
     * Default: - no additional volumes are mounted
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.core.DockerVolume> getVolumes() {
        return null;
    }

    /**
     * (experimental) Working directory inside the Docker container.
     * <p>
     * Default: /asset-input
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getWorkingDirectory() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link BundlingOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BundlingOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<BundlingOptions> {
        private software.amazon.awscdk.core.BundlingDockerImage image;
        private java.util.List<java.lang.String> command;
        private java.util.List<java.lang.String> entrypoint;
        private java.util.Map<java.lang.String, java.lang.String> environment;
        private software.amazon.awscdk.core.ILocalBundling local;
        private java.lang.String user;
        private java.util.List<software.amazon.awscdk.core.DockerVolume> volumes;
        private java.lang.String workingDirectory;

        /**
         * Sets the value of {@link BundlingOptions#getImage}
         * @param image The Docker image where the command will run. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder image(software.amazon.awscdk.core.BundlingDockerImage image) {
            this.image = image;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getCommand}
         * @param command The command to run in the Docker container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder command(java.util.List<java.lang.String> command) {
            this.command = command;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getEntrypoint}
         * @param entrypoint The entrypoint to run in the Docker container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder entrypoint(java.util.List<java.lang.String> entrypoint) {
            this.entrypoint = entrypoint;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getEnvironment}
         * @param environment The environment variables to pass to the Docker container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder environment(java.util.Map<java.lang.String, java.lang.String> environment) {
            this.environment = environment;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getLocal}
         * @param local Local bundling provider.
         *              The provider implements a method <code>tryBundle()</code> which should return <code>true</code>
         *              if local bundling was performed. If <code>false</code> is returned, docker bundling
         *              will be done.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder local(software.amazon.awscdk.core.ILocalBundling local) {
            this.local = local;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getUser}
         * @param user The user to use when running the Docker container.
         *             user | user:group | uid | uid:gid | user:gid | uid:group
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder user(java.lang.String user) {
            this.user = user;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getVolumes}
         * @param volumes Additional Docker volumes to mount.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder volumes(java.util.List<? extends software.amazon.awscdk.core.DockerVolume> volumes) {
            this.volumes = (java.util.List<software.amazon.awscdk.core.DockerVolume>)volumes;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getWorkingDirectory}
         * @param workingDirectory Working directory inside the Docker container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder workingDirectory(java.lang.String workingDirectory) {
            this.workingDirectory = workingDirectory;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BundlingOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public BundlingOptions build() {
            return new Jsii$Proxy(image, command, entrypoint, environment, local, user, volumes, workingDirectory);
        }
    }

    /**
     * An implementation for {@link BundlingOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BundlingOptions {
        private final software.amazon.awscdk.core.BundlingDockerImage image;
        private final java.util.List<java.lang.String> command;
        private final java.util.List<java.lang.String> entrypoint;
        private final java.util.Map<java.lang.String, java.lang.String> environment;
        private final software.amazon.awscdk.core.ILocalBundling local;
        private final java.lang.String user;
        private final java.util.List<software.amazon.awscdk.core.DockerVolume> volumes;
        private final java.lang.String workingDirectory;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.image = software.amazon.jsii.Kernel.get(this, "image", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.BundlingDockerImage.class));
            this.command = software.amazon.jsii.Kernel.get(this, "command", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.entrypoint = software.amazon.jsii.Kernel.get(this, "entrypoint", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.environment = software.amazon.jsii.Kernel.get(this, "environment", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.local = software.amazon.jsii.Kernel.get(this, "local", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.ILocalBundling.class));
            this.user = software.amazon.jsii.Kernel.get(this, "user", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.volumes = software.amazon.jsii.Kernel.get(this, "volumes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.DockerVolume.class)));
            this.workingDirectory = software.amazon.jsii.Kernel.get(this, "workingDirectory", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final software.amazon.awscdk.core.BundlingDockerImage image, final java.util.List<java.lang.String> command, final java.util.List<java.lang.String> entrypoint, final java.util.Map<java.lang.String, java.lang.String> environment, final software.amazon.awscdk.core.ILocalBundling local, final java.lang.String user, final java.util.List<? extends software.amazon.awscdk.core.DockerVolume> volumes, final java.lang.String workingDirectory) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.image = java.util.Objects.requireNonNull(image, "image is required");
            this.command = command;
            this.entrypoint = entrypoint;
            this.environment = environment;
            this.local = local;
            this.user = user;
            this.volumes = (java.util.List<software.amazon.awscdk.core.DockerVolume>)volumes;
            this.workingDirectory = workingDirectory;
        }

        @Override
        public final software.amazon.awscdk.core.BundlingDockerImage getImage() {
            return this.image;
        }

        @Override
        public final java.util.List<java.lang.String> getCommand() {
            return this.command;
        }

        @Override
        public final java.util.List<java.lang.String> getEntrypoint() {
            return this.entrypoint;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getEnvironment() {
            return this.environment;
        }

        @Override
        public final software.amazon.awscdk.core.ILocalBundling getLocal() {
            return this.local;
        }

        @Override
        public final java.lang.String getUser() {
            return this.user;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.core.DockerVolume> getVolumes() {
            return this.volumes;
        }

        @Override
        public final java.lang.String getWorkingDirectory() {
            return this.workingDirectory;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("image", om.valueToTree(this.getImage()));
            if (this.getCommand() != null) {
                data.set("command", om.valueToTree(this.getCommand()));
            }
            if (this.getEntrypoint() != null) {
                data.set("entrypoint", om.valueToTree(this.getEntrypoint()));
            }
            if (this.getEnvironment() != null) {
                data.set("environment", om.valueToTree(this.getEnvironment()));
            }
            if (this.getLocal() != null) {
                data.set("local", om.valueToTree(this.getLocal()));
            }
            if (this.getUser() != null) {
                data.set("user", om.valueToTree(this.getUser()));
            }
            if (this.getVolumes() != null) {
                data.set("volumes", om.valueToTree(this.getVolumes()));
            }
            if (this.getWorkingDirectory() != null) {
                data.set("workingDirectory", om.valueToTree(this.getWorkingDirectory()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/core.BundlingOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BundlingOptions.Jsii$Proxy that = (BundlingOptions.Jsii$Proxy) o;

            if (!image.equals(that.image)) return false;
            if (this.command != null ? !this.command.equals(that.command) : that.command != null) return false;
            if (this.entrypoint != null ? !this.entrypoint.equals(that.entrypoint) : that.entrypoint != null) return false;
            if (this.environment != null ? !this.environment.equals(that.environment) : that.environment != null) return false;
            if (this.local != null ? !this.local.equals(that.local) : that.local != null) return false;
            if (this.user != null ? !this.user.equals(that.user) : that.user != null) return false;
            if (this.volumes != null ? !this.volumes.equals(that.volumes) : that.volumes != null) return false;
            return this.workingDirectory != null ? this.workingDirectory.equals(that.workingDirectory) : that.workingDirectory == null;
        }

        @Override
        public final int hashCode() {
            int result = this.image.hashCode();
            result = 31 * result + (this.command != null ? this.command.hashCode() : 0);
            result = 31 * result + (this.entrypoint != null ? this.entrypoint.hashCode() : 0);
            result = 31 * result + (this.environment != null ? this.environment.hashCode() : 0);
            result = 31 * result + (this.local != null ? this.local.hashCode() : 0);
            result = 31 * result + (this.user != null ? this.user.hashCode() : 0);
            result = 31 * result + (this.volumes != null ? this.volumes.hashCode() : 0);
            result = 31 * result + (this.workingDirectory != null ? this.workingDirectory.hashCode() : 0);
            return result;
        }
    }
}
