package software.amazon.awscdk.core;

/**
 * The Tag Aspect will handle adding a tag to this node and cascading tags to children.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.15.0 (build 585166b)", date = "2021-01-28T16:32:48.001Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "@aws-cdk/core.Tag")
public class Tag extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.core.IAspect {

    protected Tag(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Tag(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param key This parameter is required.
     * @param value This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Tag(final @org.jetbrains.annotations.NotNull java.lang.String key, final @org.jetbrains.annotations.NotNull java.lang.String value, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.TagProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(key, "key is required"), java.util.Objects.requireNonNull(value, "value is required"), props });
    }

    /**
     * @param key This parameter is required.
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Tag(final @org.jetbrains.annotations.NotNull java.lang.String key, final @org.jetbrains.annotations.NotNull java.lang.String value) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(key, "key is required"), java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * (deprecated) DEPRECATED: add tags to the node of a construct and all its the taggable children.
     * <p>
     * @deprecated use `Tags.of(scope).add()`
     * @param scope This parameter is required.
     * @param key This parameter is required.
     * @param value This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public static void add(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String key, final @org.jetbrains.annotations.NotNull java.lang.String value, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.TagProps props) {
        software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Tag.class, "add", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(key, "key is required"), java.util.Objects.requireNonNull(value, "value is required"), props });
    }

    /**
     * (deprecated) DEPRECATED: add tags to the node of a construct and all its the taggable children.
     * <p>
     * @deprecated use `Tags.of(scope).add()`
     * @param scope This parameter is required.
     * @param key This parameter is required.
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public static void add(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String key, final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Tag.class, "add", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(key, "key is required"), java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * (deprecated) DEPRECATED: remove tags to the node of a construct and all its the taggable children.
     * <p>
     * @deprecated use `Tags.of(scope).remove()`
     * @param scope This parameter is required.
     * @param key This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public static void remove(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String key, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.TagProps props) {
        software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Tag.class, "remove", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(key, "key is required"), props });
    }

    /**
     * (deprecated) DEPRECATED: remove tags to the node of a construct and all its the taggable children.
     * <p>
     * @deprecated use `Tags.of(scope).remove()`
     * @param scope This parameter is required.
     * @param key This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public static void remove(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String key) {
        software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Tag.class, "remove", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(key, "key is required") });
    }

    /**
     * @param resource This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void applyTag(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ITaggable resource) {
        software.amazon.jsii.Kernel.call(this, "applyTag", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(resource, "resource is required") });
    }

    /**
     * All aspects can visit an IConstruct.
     * <p>
     * @param construct This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void visit(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IConstruct construct) {
        software.amazon.jsii.Kernel.call(this, "visit", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(construct, "construct is required") });
    }

    /**
     * The string key for the tag.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getKey() {
        return software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagProps getProps() {
        return software.amazon.jsii.Kernel.get(this, "props", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.TagProps.class));
    }

    /**
     * The string value of the tag.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getValue() {
        return software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.core.Tag}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.core.Tag> {
        /**
         * @return a new instance of {@link Builder}.
         * @param key This parameter is required.
         * @param value This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final java.lang.String key, final java.lang.String value) {
            return new Builder(key, value);
        }

        private final java.lang.String key;
        private final java.lang.String value;
        private software.amazon.awscdk.core.TagProps.Builder props;

        private Builder(final java.lang.String key, final java.lang.String value) {
            this.key = key;
            this.value = value;
        }

        /**
         * Whether the tag should be applied to instances in an AutoScalingGroup.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param applyToLaunchedInstances Whether the tag should be applied to instances in an AutoScalingGroup. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applyToLaunchedInstances(final java.lang.Boolean applyToLaunchedInstances) {
            this.props().applyToLaunchedInstances(applyToLaunchedInstances);
            return this;
        }

        /**
         * An array of Resource Types that will not receive this tag.
         * <p>
         * An empty array will allow this tag to be applied to all resources. A
         * non-empty array will apply this tag only if the Resource type is not in
         * this array.
         * <p>
         * Default: []
         * <p>
         * @return {@code this}
         * @param excludeResourceTypes An array of Resource Types that will not receive this tag. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder excludeResourceTypes(final java.util.List<java.lang.String> excludeResourceTypes) {
            this.props().excludeResourceTypes(excludeResourceTypes);
            return this;
        }

        /**
         * An array of Resource Types that will receive this tag.
         * <p>
         * An empty array will match any Resource. A non-empty array will apply this
         * tag only to Resource types that are included in this array.
         * <p>
         * Default: []
         * <p>
         * @return {@code this}
         * @param includeResourceTypes An array of Resource Types that will receive this tag. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder includeResourceTypes(final java.util.List<java.lang.String> includeResourceTypes) {
            this.props().includeResourceTypes(includeResourceTypes);
            return this;
        }

        /**
         * Priority of the tag operation.
         * <p>
         * Higher or equal priority tags will take precedence.
         * <p>
         * Setting priority will enable the user to control tags when they need to not
         * follow the default precedence pattern of last applied and closest to the
         * construct in the tree.
         * <p>
         * Default: Default priorities:
         * - 100 for {@link SetTag}
         * - 200 for {@link RemoveTag}
         * - 50 for tags added directly to CloudFormation resources
         * <p>
         * @return {@code this}
         * @param priority Priority of the tag operation. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder priority(final java.lang.Number priority) {
            this.props().priority(priority);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.core.Tag}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.core.Tag build() {
            return new software.amazon.awscdk.core.Tag(
                this.key,
                this.value,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.core.TagProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.core.TagProps.Builder();
            }
            return this.props;
        }
    }
}
