package software.amazon.awscdk.core;

/**
 * Represents the source for a file asset.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.15.0 (build 585166b)", date = "2021-01-28T16:32:45.716Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "@aws-cdk/core.FileAssetSource")
@software.amazon.jsii.Jsii.Proxy(FileAssetSource.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface FileAssetSource extends software.amazon.jsii.JsiiSerializable {

    /**
     * A hash on the content source.
     * <p>
     * This hash is used to uniquely identify this
     * asset throughout the system. If this value doesn't change, the asset will
     * not be rebuilt or republished.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSourceHash();

    /**
     * An external command that will produce the packaged asset.
     * <p>
     * The command should produce the location of a ZIP file on <code>stdout</code>.
     * <p>
     * Default: - Exactly one of `directory` and `executable` is required
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getExecutable() {
        return null;
    }

    /**
     * The path, relative to the root of the cloud assembly, in which this asset source resides.
     * <p>
     * This can be a path to a file or a directory, dependning on the
     * packaging type.
     * <p>
     * Default: - Exactly one of `directory` and `executable` is required
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getFileName() {
        return null;
    }

    /**
     * Which type of packaging to perform.
     * <p>
     * Default: - Required if `fileName` is specified.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.FileAssetPackaging getPackaging() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link FileAssetSource}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link FileAssetSource}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<FileAssetSource> {
        private java.lang.String sourceHash;
        private java.util.List<java.lang.String> executable;
        private java.lang.String fileName;
        private software.amazon.awscdk.core.FileAssetPackaging packaging;

        /**
         * Sets the value of {@link FileAssetSource#getSourceHash}
         * @param sourceHash A hash on the content source. This parameter is required.
         *                   This hash is used to uniquely identify this
         *                   asset throughout the system. If this value doesn't change, the asset will
         *                   not be rebuilt or republished.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceHash(java.lang.String sourceHash) {
            this.sourceHash = sourceHash;
            return this;
        }

        /**
         * Sets the value of {@link FileAssetSource#getExecutable}
         * @param executable An external command that will produce the packaged asset.
         *                   The command should produce the location of a ZIP file on <code>stdout</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder executable(java.util.List<java.lang.String> executable) {
            this.executable = executable;
            return this;
        }

        /**
         * Sets the value of {@link FileAssetSource#getFileName}
         * @param fileName The path, relative to the root of the cloud assembly, in which this asset source resides.
         *                 This can be a path to a file or a directory, dependning on the
         *                 packaging type.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fileName(java.lang.String fileName) {
            this.fileName = fileName;
            return this;
        }

        /**
         * Sets the value of {@link FileAssetSource#getPackaging}
         * @param packaging Which type of packaging to perform.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder packaging(software.amazon.awscdk.core.FileAssetPackaging packaging) {
            this.packaging = packaging;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link FileAssetSource}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public FileAssetSource build() {
            return new Jsii$Proxy(sourceHash, executable, fileName, packaging);
        }
    }

    /**
     * An implementation for {@link FileAssetSource}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FileAssetSource {
        private final java.lang.String sourceHash;
        private final java.util.List<java.lang.String> executable;
        private final java.lang.String fileName;
        private final software.amazon.awscdk.core.FileAssetPackaging packaging;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.sourceHash = software.amazon.jsii.Kernel.get(this, "sourceHash", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.executable = software.amazon.jsii.Kernel.get(this, "executable", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.fileName = software.amazon.jsii.Kernel.get(this, "fileName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.packaging = software.amazon.jsii.Kernel.get(this, "packaging", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.FileAssetPackaging.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final java.lang.String sourceHash, final java.util.List<java.lang.String> executable, final java.lang.String fileName, final software.amazon.awscdk.core.FileAssetPackaging packaging) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.sourceHash = java.util.Objects.requireNonNull(sourceHash, "sourceHash is required");
            this.executable = executable;
            this.fileName = fileName;
            this.packaging = packaging;
        }

        @Override
        public final java.lang.String getSourceHash() {
            return this.sourceHash;
        }

        @Override
        public final java.util.List<java.lang.String> getExecutable() {
            return this.executable;
        }

        @Override
        public final java.lang.String getFileName() {
            return this.fileName;
        }

        @Override
        public final software.amazon.awscdk.core.FileAssetPackaging getPackaging() {
            return this.packaging;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("sourceHash", om.valueToTree(this.getSourceHash()));
            if (this.getExecutable() != null) {
                data.set("executable", om.valueToTree(this.getExecutable()));
            }
            if (this.getFileName() != null) {
                data.set("fileName", om.valueToTree(this.getFileName()));
            }
            if (this.getPackaging() != null) {
                data.set("packaging", om.valueToTree(this.getPackaging()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/core.FileAssetSource"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            FileAssetSource.Jsii$Proxy that = (FileAssetSource.Jsii$Proxy) o;

            if (!sourceHash.equals(that.sourceHash)) return false;
            if (this.executable != null ? !this.executable.equals(that.executable) : that.executable != null) return false;
            if (this.fileName != null ? !this.fileName.equals(that.fileName) : that.fileName != null) return false;
            return this.packaging != null ? this.packaging.equals(that.packaging) : that.packaging == null;
        }

        @Override
        public final int hashCode() {
            int result = this.sourceHash.hashCode();
            result = 31 * result + (this.executable != null ? this.executable.hashCode() : 0);
            result = 31 * result + (this.fileName != null ? this.fileName.hashCode() : 0);
            result = 31 * result + (this.packaging != null ? this.packaging.hashCode() : 0);
            return result;
        }
    }
}
