package software.amazon.awscdk.core;

/**
 * Lazily produce a value.
 * <p>
 * Can be used to return a string, list or numeric value whose actual value
 * will only be calculated later, during synthesis.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.15.0 (build 585166b)", date = "2021-01-27T11:16:20.458Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "@aws-cdk/core.Lazy")
public class Lazy extends software.amazon.jsii.JsiiObject {

    protected Lazy(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Lazy(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Defer the one-time calculation of an arbitrarily typed value to synthesis time.
     * <p>
     * Use this if you want to render an object to a template whose actual value depends on
     * some state mutation that may happen after the construct has been created.
     * <p>
     * The inner function will only be invoked one time and cannot depend on
     * resolution context.
     * <p>
     * @param producer This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolvable any(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IStableAnyProducer producer, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.LazyAnyValueOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Lazy.class, "any", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.IResolvable.class), new Object[] { java.util.Objects.requireNonNull(producer, "producer is required"), options });
    }

    /**
     * Defer the one-time calculation of an arbitrarily typed value to synthesis time.
     * <p>
     * Use this if you want to render an object to a template whose actual value depends on
     * some state mutation that may happen after the construct has been created.
     * <p>
     * The inner function will only be invoked one time and cannot depend on
     * resolution context.
     * <p>
     * @param producer This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolvable any(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IStableAnyProducer producer) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Lazy.class, "any", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.IResolvable.class), new Object[] { java.util.Objects.requireNonNull(producer, "producer is required") });
    }

    /**
     * (deprecated) Defer the one-time calculation of an arbitrarily typed value to synthesis time.
     * <p>
     * Use this if you want to render an object to a template whose actual value depends on
     * some state mutation that may happen after the construct has been created.
     * <p>
     * @deprecated Use `Lazy.any()` or `Lazy.uncachedAny()` instead.
     * @param producer This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolvable anyValue(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IAnyProducer producer, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.LazyAnyValueOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Lazy.class, "anyValue", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.IResolvable.class), new Object[] { java.util.Objects.requireNonNull(producer, "producer is required"), options });
    }

    /**
     * (deprecated) Defer the one-time calculation of an arbitrarily typed value to synthesis time.
     * <p>
     * Use this if you want to render an object to a template whose actual value depends on
     * some state mutation that may happen after the construct has been created.
     * <p>
     * @deprecated Use `Lazy.any()` or `Lazy.uncachedAny()` instead.
     * @param producer This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolvable anyValue(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IAnyProducer producer) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Lazy.class, "anyValue", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.IResolvable.class), new Object[] { java.util.Objects.requireNonNull(producer, "producer is required") });
    }

    /**
     * Defer the one-time calculation of a list value to synthesis time.
     * <p>
     * Use this if you want to render a list to a template whose actual value depends on
     * some state mutation that may happen after the construct has been created.
     * <p>
     * If you are simply looking to force a value to a <code>string[]</code> type and don't need
     * the calculation to be deferred, use <code>Token.asList()</code> instead.
     * <p>
     * The inner function will only be invoked once, and the resolved value
     * cannot depend on the Stack the Token is used in.
     * <p>
     * @param producer This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> list(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IStableListProducer producer, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.LazyListValueOptions options) {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Lazy.class, "list", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)), new Object[] { java.util.Objects.requireNonNull(producer, "producer is required"), options }));
    }

    /**
     * Defer the one-time calculation of a list value to synthesis time.
     * <p>
     * Use this if you want to render a list to a template whose actual value depends on
     * some state mutation that may happen after the construct has been created.
     * <p>
     * If you are simply looking to force a value to a <code>string[]</code> type and don't need
     * the calculation to be deferred, use <code>Token.asList()</code> instead.
     * <p>
     * The inner function will only be invoked once, and the resolved value
     * cannot depend on the Stack the Token is used in.
     * <p>
     * @param producer This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> list(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IStableListProducer producer) {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Lazy.class, "list", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)), new Object[] { java.util.Objects.requireNonNull(producer, "producer is required") }));
    }

    /**
     * (deprecated) Defer the one-time calculation of a list value to synthesis time.
     * <p>
     * Use this if you want to render a list to a template whose actual value depends on
     * some state mutation that may happen after the construct has been created.
     * <p>
     * If you are simply looking to force a value to a <code>string[]</code> type and don't need
     * the calculation to be deferred, use <code>Token.asList()</code> instead.
     * <p>
     * @deprecated Use `Lazy.list()` or `Lazy.uncachedList()` instead.
     * @param producer This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public static @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> listValue(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IListProducer producer, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.LazyListValueOptions options) {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Lazy.class, "listValue", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)), new Object[] { java.util.Objects.requireNonNull(producer, "producer is required"), options }));
    }

    /**
     * (deprecated) Defer the one-time calculation of a list value to synthesis time.
     * <p>
     * Use this if you want to render a list to a template whose actual value depends on
     * some state mutation that may happen after the construct has been created.
     * <p>
     * If you are simply looking to force a value to a <code>string[]</code> type and don't need
     * the calculation to be deferred, use <code>Token.asList()</code> instead.
     * <p>
     * @deprecated Use `Lazy.list()` or `Lazy.uncachedList()` instead.
     * @param producer This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public static @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> listValue(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IListProducer producer) {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Lazy.class, "listValue", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)), new Object[] { java.util.Objects.requireNonNull(producer, "producer is required") }));
    }

    /**
     * Defer the one-time calculation of a number value to synthesis time.
     * <p>
     * Use this if you want to render a number to a template whose actual value depends on
     * some state mutation that may happen after the construct has been created.
     * <p>
     * If you are simply looking to force a value to a <code>number</code> type and don't need
     * the calculation to be deferred, use <code>Token.asNumber()</code> instead.
     * <p>
     * The inner function will only be invoked once, and the resolved value
     * cannot depend on the Stack the Token is used in.
     * <p>
     * @param producer This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.Number number(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IStableNumberProducer producer) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Lazy.class, "number", software.amazon.jsii.NativeType.forClass(java.lang.Number.class), new Object[] { java.util.Objects.requireNonNull(producer, "producer is required") });
    }

    /**
     * (deprecated) Defer the one-time calculation of a number value to synthesis time.
     * <p>
     * Use this if you want to render a number to a template whose actual value depends on
     * some state mutation that may happen after the construct has been created.
     * <p>
     * If you are simply looking to force a value to a <code>number</code> type and don't need
     * the calculation to be deferred, use <code>Token.asNumber()</code> instead.
     * <p>
     * @deprecated Use `Lazy.number()` or `Lazy.uncachedNumber()` instead.
     * @param producer This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public static @org.jetbrains.annotations.NotNull java.lang.Number numberValue(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.INumberProducer producer) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Lazy.class, "numberValue", software.amazon.jsii.NativeType.forClass(java.lang.Number.class), new Object[] { java.util.Objects.requireNonNull(producer, "producer is required") });
    }

    /**
     * Defer the one-time calculation of a string value to synthesis time.
     * <p>
     * Use this if you want to render a string to a template whose actual value depends on
     * some state mutation that may happen after the construct has been created.
     * <p>
     * If you are simply looking to force a value to a <code>string</code> type and don't need
     * the calculation to be deferred, use <code>Token.asString()</code> instead.
     * <p>
     * The inner function will only be invoked once, and the resolved value
     * cannot depend on the Stack the Token is used in.
     * <p>
     * @param producer This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String string(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IStableStringProducer producer, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.LazyStringValueOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Lazy.class, "string", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(producer, "producer is required"), options });
    }

    /**
     * Defer the one-time calculation of a string value to synthesis time.
     * <p>
     * Use this if you want to render a string to a template whose actual value depends on
     * some state mutation that may happen after the construct has been created.
     * <p>
     * If you are simply looking to force a value to a <code>string</code> type and don't need
     * the calculation to be deferred, use <code>Token.asString()</code> instead.
     * <p>
     * The inner function will only be invoked once, and the resolved value
     * cannot depend on the Stack the Token is used in.
     * <p>
     * @param producer This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String string(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IStableStringProducer producer) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Lazy.class, "string", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(producer, "producer is required") });
    }

    /**
     * (deprecated) Defer the calculation of a string value to synthesis time.
     * <p>
     * Use this if you want to render a string to a template whose actual value depends on
     * some state mutation that may happen after the construct has been created.
     * <p>
     * If you are simply looking to force a value to a <code>string</code> type and don't need
     * the calculation to be deferred, use <code>Token.asString()</code> instead.
     * <p>
     * @deprecated Use `Lazy.string()` or `Lazy.uncachedString()` instead.
     * @param producer This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public static @org.jetbrains.annotations.NotNull java.lang.String stringValue(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IStringProducer producer, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.LazyStringValueOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Lazy.class, "stringValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(producer, "producer is required"), options });
    }

    /**
     * (deprecated) Defer the calculation of a string value to synthesis time.
     * <p>
     * Use this if you want to render a string to a template whose actual value depends on
     * some state mutation that may happen after the construct has been created.
     * <p>
     * If you are simply looking to force a value to a <code>string</code> type and don't need
     * the calculation to be deferred, use <code>Token.asString()</code> instead.
     * <p>
     * @deprecated Use `Lazy.string()` or `Lazy.uncachedString()` instead.
     * @param producer This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public static @org.jetbrains.annotations.NotNull java.lang.String stringValue(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IStringProducer producer) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Lazy.class, "stringValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(producer, "producer is required") });
    }

    /**
     * Defer the calculation of an untyped value to synthesis time.
     * <p>
     * Use of this function is not recommended; unless you know you need it for sure, you
     * probably don't. Use <code>Lazy.any()</code> instead.
     * <p>
     * The inner function may be invoked multiple times during synthesis. You
     * should only use this method if the returned value depends on variables
     * that may change during the Aspect application phase of synthesis, or if
     * the value depends on the Stack the value is being used in. Both of these
     * cases are rare, and only ever occur for AWS Construct Library authors.
     * <p>
     * @param producer This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolvable uncachedAny(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IAnyProducer producer, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.LazyAnyValueOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Lazy.class, "uncachedAny", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.IResolvable.class), new Object[] { java.util.Objects.requireNonNull(producer, "producer is required"), options });
    }

    /**
     * Defer the calculation of an untyped value to synthesis time.
     * <p>
     * Use of this function is not recommended; unless you know you need it for sure, you
     * probably don't. Use <code>Lazy.any()</code> instead.
     * <p>
     * The inner function may be invoked multiple times during synthesis. You
     * should only use this method if the returned value depends on variables
     * that may change during the Aspect application phase of synthesis, or if
     * the value depends on the Stack the value is being used in. Both of these
     * cases are rare, and only ever occur for AWS Construct Library authors.
     * <p>
     * @param producer This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolvable uncachedAny(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IAnyProducer producer) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Lazy.class, "uncachedAny", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.IResolvable.class), new Object[] { java.util.Objects.requireNonNull(producer, "producer is required") });
    }

    /**
     * Defer the calculation of a list value to synthesis time.
     * <p>
     * Use of this function is not recommended; unless you know you need it for sure, you
     * probably don't. Use <code>Lazy.list()</code> instead.
     * <p>
     * The inner function may be invoked multiple times during synthesis. You
     * should only use this method if the returned value depends on variables
     * that may change during the Aspect application phase of synthesis, or if
     * the value depends on the Stack the value is being used in. Both of these
     * cases are rare, and only ever occur for AWS Construct Library authors.
     * <p>
     * @param producer This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> uncachedList(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IListProducer producer, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.LazyListValueOptions options) {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Lazy.class, "uncachedList", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)), new Object[] { java.util.Objects.requireNonNull(producer, "producer is required"), options }));
    }

    /**
     * Defer the calculation of a list value to synthesis time.
     * <p>
     * Use of this function is not recommended; unless you know you need it for sure, you
     * probably don't. Use <code>Lazy.list()</code> instead.
     * <p>
     * The inner function may be invoked multiple times during synthesis. You
     * should only use this method if the returned value depends on variables
     * that may change during the Aspect application phase of synthesis, or if
     * the value depends on the Stack the value is being used in. Both of these
     * cases are rare, and only ever occur for AWS Construct Library authors.
     * <p>
     * @param producer This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> uncachedList(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IListProducer producer) {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Lazy.class, "uncachedList", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)), new Object[] { java.util.Objects.requireNonNull(producer, "producer is required") }));
    }

    /**
     * Defer the calculation of a number value to synthesis time.
     * <p>
     * Use of this function is not recommended; unless you know you need it for sure, you
     * probably don't. Use <code>Lazy.number()</code> instead.
     * <p>
     * The inner function may be invoked multiple times during synthesis. You
     * should only use this method if the returned value depends on variables
     * that may change during the Aspect application phase of synthesis, or if
     * the value depends on the Stack the value is being used in. Both of these
     * cases are rare, and only ever occur for AWS Construct Library authors.
     * <p>
     * @param producer This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.Number uncachedNumber(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.INumberProducer producer) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Lazy.class, "uncachedNumber", software.amazon.jsii.NativeType.forClass(java.lang.Number.class), new Object[] { java.util.Objects.requireNonNull(producer, "producer is required") });
    }

    /**
     * Defer the calculation of a string value to synthesis time.
     * <p>
     * Use of this function is not recommended; unless you know you need it for sure, you
     * probably don't. Use <code>Lazy.string()</code> instead.
     * <p>
     * The inner function may be invoked multiple times during synthesis. You
     * should only use this method if the returned value depends on variables
     * that may change during the Aspect application phase of synthesis, or if
     * the value depends on the Stack the value is being used in. Both of these
     * cases are rare, and only ever occur for AWS Construct Library authors.
     * <p>
     * @param producer This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String uncachedString(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IStringProducer producer, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.LazyStringValueOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Lazy.class, "uncachedString", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(producer, "producer is required"), options });
    }

    /**
     * Defer the calculation of a string value to synthesis time.
     * <p>
     * Use of this function is not recommended; unless you know you need it for sure, you
     * probably don't. Use <code>Lazy.string()</code> instead.
     * <p>
     * The inner function may be invoked multiple times during synthesis. You
     * should only use this method if the returned value depends on variables
     * that may change during the Aspect application phase of synthesis, or if
     * the value depends on the Stack the value is being used in. Both of these
     * cases are rare, and only ever occur for AWS Construct Library authors.
     * <p>
     * @param producer This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String uncachedString(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IStringProducer producer) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Lazy.class, "uncachedString", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(producer, "producer is required") });
    }
}
