package software.amazon.awscdk.core;

/**
 * Base class for implementing an IStackSynthesizer.
 * <p>
 * This class needs to exist to provide public surface area for external
 * implementations of stack synthesizers. The protected methods give
 * access to functions that are otherwise &#64;_internal to the framework
 * and could not be accessed by external implementors.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.15.0 (build 585166b)", date = "2021-01-21T13:42:52.436Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "@aws-cdk/core.StackSynthesizer")
public abstract class StackSynthesizer extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.core.IStackSynthesizer {

    protected StackSynthesizer(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected StackSynthesizer(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected StackSynthesizer() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Register a Docker Image Asset.
     * <p>
     * Returns the parameters that can be used to refer to the asset inside the template.
     * <p>
     * @param asset This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public abstract @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.DockerImageAssetLocation addDockerImageAsset(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.DockerImageAssetSource asset);

    /**
     * Register a File Asset.
     * <p>
     * Returns the parameters that can be used to refer to the asset inside the template.
     * <p>
     * @param asset This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public abstract @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.FileAssetLocation addFileAsset(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.FileAssetSource asset);

    /**
     * Bind to the stack this environment is going to be used on.
     * <p>
     * Must be called before any of the other methods are called.
     * <p>
     * @param stack This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public abstract void bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Stack stack);

    /**
     * Write the stack artifact to the session.
     * <p>
     * Use default settings to add a CloudFormationStackArtifact artifact to
     * the given synthesis session.
     * <p>
     * @param stack This parameter is required.
     * @param session This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void emitStackArtifact(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Stack stack, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ISynthesisSession session, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.SynthesizeStackArtifactOptions options) {
        software.amazon.jsii.Kernel.call(this, "emitStackArtifact", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(stack, "stack is required"), java.util.Objects.requireNonNull(session, "session is required"), options });
    }

    /**
     * Write the stack artifact to the session.
     * <p>
     * Use default settings to add a CloudFormationStackArtifact artifact to
     * the given synthesis session.
     * <p>
     * @param stack This parameter is required.
     * @param session This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void emitStackArtifact(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Stack stack, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ISynthesisSession session) {
        software.amazon.jsii.Kernel.call(this, "emitStackArtifact", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(stack, "stack is required"), java.util.Objects.requireNonNull(session, "session is required") });
    }

    /**
     * Synthesize the associated stack to the session.
     * <p>
     * @param session This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public abstract void synthesize(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ISynthesisSession session);

    /**
     * Have the stack write out its template.
     * <p>
     * @param stack This parameter is required.
     * @param session This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void synthesizeStackTemplate(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Stack stack, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ISynthesisSession session) {
        software.amazon.jsii.Kernel.call(this, "synthesizeStackTemplate", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(stack, "stack is required"), java.util.Objects.requireNonNull(session, "session is required") });
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.core.StackSynthesizer implements software.amazon.awscdk.core.IStackSynthesizer.Jsii$Default {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * Register a Docker Image Asset.
         * <p>
         * Returns the parameters that can be used to refer to the asset inside the template.
         * <p>
         * @param asset This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.DockerImageAssetLocation addDockerImageAsset(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.DockerImageAssetSource asset) {
            return software.amazon.jsii.Kernel.call(this, "addDockerImageAsset", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.DockerImageAssetLocation.class), new Object[] { java.util.Objects.requireNonNull(asset, "asset is required") });
        }

        /**
         * Register a File Asset.
         * <p>
         * Returns the parameters that can be used to refer to the asset inside the template.
         * <p>
         * @param asset This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.FileAssetLocation addFileAsset(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.FileAssetSource asset) {
            return software.amazon.jsii.Kernel.call(this, "addFileAsset", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.FileAssetLocation.class), new Object[] { java.util.Objects.requireNonNull(asset, "asset is required") });
        }

        /**
         * Bind to the stack this environment is going to be used on.
         * <p>
         * Must be called before any of the other methods are called.
         * <p>
         * @param stack This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final void bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Stack stack) {
            software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(stack, "stack is required") });
        }

        /**
         * Synthesize the associated stack to the session.
         * <p>
         * @param session This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final void synthesize(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ISynthesisSession session) {
            software.amazon.jsii.Kernel.call(this, "synthesize", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(session, "session is required") });
        }
    }
}
