package software.amazon.awscdk.core;

/**
 * Trait marker for classes that can be depended upon.
 * <p>
 * The presence of this interface indicates that an object has
 * an <code>IDependableTrait</code> implementation.
 * <p>
 * This interface can be used to take an (ordering) dependency on a set of
 * constructs. An ordering dependency implies that the resources represented by
 * those constructs are deployed before the resources depending ON them are
 * deployed.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.15.0 (build 585166b)", date = "2021-01-06T15:17:10.109Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "@aws-cdk/core.IDependable")
@software.amazon.jsii.Jsii.Proxy(IDependable.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface IDependable extends software.amazon.jsii.JsiiSerializable {

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.core.IDependable.Jsii$Default {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }
    }

    /**
     * Internal default implementation for {@link IDependable}.
     */
    @software.amazon.jsii.Internal
    interface Jsii$Default extends IDependable {
    }
}
