package software.amazon.awscdk.core;

/**
 * Use the UpdatePolicy attribute to specify how AWS CloudFormation handles updates to the AWS::AutoScaling::AutoScalingGroup resource.
 * 
 * AWS CloudFormation invokes one of three update policies depending on the type of change you make or whether a
 * scheduled action is associated with the Auto Scaling group.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.16.0 (build 98909b5)", date = "2019-09-10T21:04:46.903Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnUpdatePolicy extends software.amazon.jsii.JsiiSerializable {
    /**
     * Specifies whether an Auto Scaling group and the instances it contains are replaced during an update.
     * 
     * During replacement,
     * AWS CloudFormation retains the old group until it finishes creating the new one. If the update fails, AWS CloudFormation
     * can roll back to the old Auto Scaling group and delete the new Auto Scaling group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.core.CfnAutoScalingReplacingUpdate getAutoScalingReplacingUpdate();

    /**
     * To specify how AWS CloudFormation handles rolling updates for an Auto Scaling group, use the AutoScalingRollingUpdate policy.
     * 
     * Rolling updates enable you to specify whether AWS CloudFormation updates instances that are in an Auto Scaling
     * group in batches or all at once.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.core.CfnAutoScalingRollingUpdate getAutoScalingRollingUpdate();

    /**
     * To specify how AWS CloudFormation handles updates for the MinSize, MaxSize, and DesiredCapacity properties when the AWS::AutoScaling::AutoScalingGroup resource has an associated scheduled action, use the AutoScalingScheduledAction policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.core.CfnAutoScalingScheduledAction getAutoScalingScheduledAction();

    /**
     * To perform an AWS CodeDeploy deployment when the version changes on an AWS::Lambda::Alias resource, use the CodeDeployLambdaAliasUpdate update policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.core.CfnCodeDeployLambdaAliasUpdate getCodeDeployLambdaAliasUpdate();

    /**
     * To modify a replication group's shards by adding or removing shards, rather than replacing the entire AWS::ElastiCache::ReplicationGroup resource, use the UseOnlineResharding update policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Boolean getUseOnlineResharding();

    /**
     * @return a {@link Builder} of {@link CfnUpdatePolicy}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link CfnUpdatePolicy}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        private software.amazon.awscdk.core.CfnAutoScalingReplacingUpdate autoScalingReplacingUpdate;
        private software.amazon.awscdk.core.CfnAutoScalingRollingUpdate autoScalingRollingUpdate;
        private software.amazon.awscdk.core.CfnAutoScalingScheduledAction autoScalingScheduledAction;
        private software.amazon.awscdk.core.CfnCodeDeployLambdaAliasUpdate codeDeployLambdaAliasUpdate;
        private java.lang.Boolean useOnlineResharding;

        /**
         * Sets the value of AutoScalingReplacingUpdate
         * @param autoScalingReplacingUpdate Specifies whether an Auto Scaling group and the instances it contains are replaced during an update.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoScalingReplacingUpdate(software.amazon.awscdk.core.CfnAutoScalingReplacingUpdate autoScalingReplacingUpdate) {
            this.autoScalingReplacingUpdate = autoScalingReplacingUpdate;
            return this;
        }

        /**
         * Sets the value of AutoScalingRollingUpdate
         * @param autoScalingRollingUpdate To specify how AWS CloudFormation handles rolling updates for an Auto Scaling group, use the AutoScalingRollingUpdate policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoScalingRollingUpdate(software.amazon.awscdk.core.CfnAutoScalingRollingUpdate autoScalingRollingUpdate) {
            this.autoScalingRollingUpdate = autoScalingRollingUpdate;
            return this;
        }

        /**
         * Sets the value of AutoScalingScheduledAction
         * @param autoScalingScheduledAction To specify how AWS CloudFormation handles updates for the MinSize, MaxSize, and DesiredCapacity properties when the AWS::AutoScaling::AutoScalingGroup resource has an associated scheduled action, use the AutoScalingScheduledAction policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoScalingScheduledAction(software.amazon.awscdk.core.CfnAutoScalingScheduledAction autoScalingScheduledAction) {
            this.autoScalingScheduledAction = autoScalingScheduledAction;
            return this;
        }

        /**
         * Sets the value of CodeDeployLambdaAliasUpdate
         * @param codeDeployLambdaAliasUpdate To perform an AWS CodeDeploy deployment when the version changes on an AWS::Lambda::Alias resource, use the CodeDeployLambdaAliasUpdate update policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder codeDeployLambdaAliasUpdate(software.amazon.awscdk.core.CfnCodeDeployLambdaAliasUpdate codeDeployLambdaAliasUpdate) {
            this.codeDeployLambdaAliasUpdate = codeDeployLambdaAliasUpdate;
            return this;
        }

        /**
         * Sets the value of UseOnlineResharding
         * @param useOnlineResharding To modify a replication group's shards by adding or removing shards, rather than replacing the entire AWS::ElastiCache::ReplicationGroup resource, use the UseOnlineResharding update policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder useOnlineResharding(java.lang.Boolean useOnlineResharding) {
            this.useOnlineResharding = useOnlineResharding;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnUpdatePolicy}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public CfnUpdatePolicy build() {
            return new Jsii$Proxy(autoScalingReplacingUpdate, autoScalingRollingUpdate, autoScalingScheduledAction, codeDeployLambdaAliasUpdate, useOnlineResharding);
        }

    }

    /**
     * An implementation for {@link CfnUpdatePolicy}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnUpdatePolicy {
        private final software.amazon.awscdk.core.CfnAutoScalingReplacingUpdate autoScalingReplacingUpdate;
        private final software.amazon.awscdk.core.CfnAutoScalingRollingUpdate autoScalingRollingUpdate;
        private final software.amazon.awscdk.core.CfnAutoScalingScheduledAction autoScalingScheduledAction;
        private final software.amazon.awscdk.core.CfnCodeDeployLambdaAliasUpdate codeDeployLambdaAliasUpdate;
        private final java.lang.Boolean useOnlineResharding;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.autoScalingReplacingUpdate = this.jsiiGet("autoScalingReplacingUpdate", software.amazon.awscdk.core.CfnAutoScalingReplacingUpdate.class);
            this.autoScalingRollingUpdate = this.jsiiGet("autoScalingRollingUpdate", software.amazon.awscdk.core.CfnAutoScalingRollingUpdate.class);
            this.autoScalingScheduledAction = this.jsiiGet("autoScalingScheduledAction", software.amazon.awscdk.core.CfnAutoScalingScheduledAction.class);
            this.codeDeployLambdaAliasUpdate = this.jsiiGet("codeDeployLambdaAliasUpdate", software.amazon.awscdk.core.CfnCodeDeployLambdaAliasUpdate.class);
            this.useOnlineResharding = this.jsiiGet("useOnlineResharding", java.lang.Boolean.class);
        }


        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(software.amazon.awscdk.core.CfnAutoScalingReplacingUpdate autoScalingReplacingUpdate, software.amazon.awscdk.core.CfnAutoScalingRollingUpdate autoScalingRollingUpdate, software.amazon.awscdk.core.CfnAutoScalingScheduledAction autoScalingScheduledAction, software.amazon.awscdk.core.CfnCodeDeployLambdaAliasUpdate codeDeployLambdaAliasUpdate, java.lang.Boolean useOnlineResharding) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.autoScalingReplacingUpdate = autoScalingReplacingUpdate;
            this.autoScalingRollingUpdate = autoScalingRollingUpdate;
            this.autoScalingScheduledAction = autoScalingScheduledAction;
            this.codeDeployLambdaAliasUpdate = codeDeployLambdaAliasUpdate;
            this.useOnlineResharding = useOnlineResharding;
        }

        @Override
        public software.amazon.awscdk.core.CfnAutoScalingReplacingUpdate getAutoScalingReplacingUpdate() {
            return this.autoScalingReplacingUpdate;
        }

        @Override
        public software.amazon.awscdk.core.CfnAutoScalingRollingUpdate getAutoScalingRollingUpdate() {
            return this.autoScalingRollingUpdate;
        }

        @Override
        public software.amazon.awscdk.core.CfnAutoScalingScheduledAction getAutoScalingScheduledAction() {
            return this.autoScalingScheduledAction;
        }

        @Override
        public software.amazon.awscdk.core.CfnCodeDeployLambdaAliasUpdate getCodeDeployLambdaAliasUpdate() {
            return this.codeDeployLambdaAliasUpdate;
        }

        @Override
        public java.lang.Boolean getUseOnlineResharding() {
            return this.useOnlineResharding;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            if (this.getAutoScalingReplacingUpdate() != null) {
                obj.set("autoScalingReplacingUpdate", om.valueToTree(this.getAutoScalingReplacingUpdate()));
            }
            if (this.getAutoScalingRollingUpdate() != null) {
                obj.set("autoScalingRollingUpdate", om.valueToTree(this.getAutoScalingRollingUpdate()));
            }
            if (this.getAutoScalingScheduledAction() != null) {
                obj.set("autoScalingScheduledAction", om.valueToTree(this.getAutoScalingScheduledAction()));
            }
            if (this.getCodeDeployLambdaAliasUpdate() != null) {
                obj.set("codeDeployLambdaAliasUpdate", om.valueToTree(this.getCodeDeployLambdaAliasUpdate()));
            }
            if (this.getUseOnlineResharding() != null) {
                obj.set("useOnlineResharding", om.valueToTree(this.getUseOnlineResharding()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnUpdatePolicy.Jsii$Proxy that = (CfnUpdatePolicy.Jsii$Proxy) o;

            if (this.autoScalingReplacingUpdate != null ? !this.autoScalingReplacingUpdate.equals(that.autoScalingReplacingUpdate) : that.autoScalingReplacingUpdate != null) return false;
            if (this.autoScalingRollingUpdate != null ? !this.autoScalingRollingUpdate.equals(that.autoScalingRollingUpdate) : that.autoScalingRollingUpdate != null) return false;
            if (this.autoScalingScheduledAction != null ? !this.autoScalingScheduledAction.equals(that.autoScalingScheduledAction) : that.autoScalingScheduledAction != null) return false;
            if (this.codeDeployLambdaAliasUpdate != null ? !this.codeDeployLambdaAliasUpdate.equals(that.codeDeployLambdaAliasUpdate) : that.codeDeployLambdaAliasUpdate != null) return false;
            return this.useOnlineResharding != null ? this.useOnlineResharding.equals(that.useOnlineResharding) : that.useOnlineResharding == null;
        }

        @Override
        public int hashCode() {
            int result = this.autoScalingReplacingUpdate != null ? this.autoScalingReplacingUpdate.hashCode() : 0;
            result = 31 * result + (this.autoScalingRollingUpdate != null ? this.autoScalingRollingUpdate.hashCode() : 0);
            result = 31 * result + (this.autoScalingScheduledAction != null ? this.autoScalingScheduledAction.hashCode() : 0);
            result = 31 * result + (this.codeDeployLambdaAliasUpdate != null ? this.codeDeployLambdaAliasUpdate.hashCode() : 0);
            result = 31 * result + (this.useOnlineResharding != null ? this.useOnlineResharding.hashCode() : 0);
            return result;
        }

    }
}
