package software.amazon.awscdk.core;

/**
 * Represents file path ignoring behavior.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.15.0 (build 585166b)", date = "2020-12-17T11:03:29.982Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "@aws-cdk/core.IgnoreStrategy")
public abstract class IgnoreStrategy extends software.amazon.jsii.JsiiObject {

    protected IgnoreStrategy(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected IgnoreStrategy(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected IgnoreStrategy() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Ignores file paths based on the [`.dockerignore specification`](https://docs.docker.com/engine/reference/builder/#dockerignore-file).
     * <p>
     * @return `DockerIgnorePattern` associated with the given patterns.
     * @param absoluteRootPath the absolute path to the root directory of the paths to be considered. This parameter is required.
     * @param patterns This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.DockerIgnoreStrategy docker(final @org.jetbrains.annotations.NotNull java.lang.String absoluteRootPath, final @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> patterns) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.IgnoreStrategy.class, "docker", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.DockerIgnoreStrategy.class), new Object[] { java.util.Objects.requireNonNull(absoluteRootPath, "absoluteRootPath is required"), java.util.Objects.requireNonNull(patterns, "patterns is required") });
    }

    /**
     * Creates an IgnoreStrategy based on the `ignoreMode` and `exclude` in a `CopyOptions`.
     * <p>
     * @return `IgnoreStrategy` based on the `CopyOptions`
     * @param options the `CopyOptions` to create the `IgnoreStrategy` from. This parameter is required.
     * @param absoluteRootPath the absolute path to the root directory of the paths to be considered. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IgnoreStrategy fromCopyOptions(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.CopyOptions options, final @org.jetbrains.annotations.NotNull java.lang.String absoluteRootPath) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.IgnoreStrategy.class, "fromCopyOptions", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.IgnoreStrategy.class), new Object[] { java.util.Objects.requireNonNull(options, "options is required"), java.util.Objects.requireNonNull(absoluteRootPath, "absoluteRootPath is required") });
    }

    /**
     * Ignores file paths based on the [`.gitignore specification`](https://git-scm.com/docs/gitignore).
     * <p>
     * @return `GitIgnorePattern` associated with the given patterns.
     * @param absoluteRootPath the absolute path to the root directory of the paths to be considered. This parameter is required.
     * @param patterns This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.GitIgnoreStrategy git(final @org.jetbrains.annotations.NotNull java.lang.String absoluteRootPath, final @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> patterns) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.IgnoreStrategy.class, "git", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.GitIgnoreStrategy.class), new Object[] { java.util.Objects.requireNonNull(absoluteRootPath, "absoluteRootPath is required"), java.util.Objects.requireNonNull(patterns, "patterns is required") });
    }

    /**
     * Ignores file paths based on simple glob patterns.
     * <p>
     * @return `GlobIgnorePattern` associated with the given patterns.
     * @param absoluteRootPath the absolute path to the root directory of the paths to be considered. This parameter is required.
     * @param patterns This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.GlobIgnoreStrategy glob(final @org.jetbrains.annotations.NotNull java.lang.String absoluteRootPath, final @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> patterns) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.IgnoreStrategy.class, "glob", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.GlobIgnoreStrategy.class), new Object[] { java.util.Objects.requireNonNull(absoluteRootPath, "absoluteRootPath is required"), java.util.Objects.requireNonNull(patterns, "patterns is required") });
    }

    /**
     * Adds another pattern.
     * <p>
     * @param pattern This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract void add(final @org.jetbrains.annotations.NotNull java.lang.String pattern);

    /**
     * Determines whether a given file path should be ignored or not.
     * <p>
     * @return `true` if the file should be ignored
     * @param absoluteFilePath absolute file path to be assessed against the pattern. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull java.lang.Boolean ignores(final @org.jetbrains.annotations.NotNull java.lang.String absoluteFilePath);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.core.IgnoreStrategy {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * Adds another pattern.
         * <p>
         * @param pattern This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final void add(final @org.jetbrains.annotations.NotNull java.lang.String pattern) {
            software.amazon.jsii.Kernel.call(this, "add", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(pattern, "pattern is required") });
        }

        /**
         * Determines whether a given file path should be ignored or not.
         * <p>
         * @return `true` if the file should be ignored
         * @param absoluteFilePath absolute file path to be assessed against the pattern. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull java.lang.Boolean ignores(final @org.jetbrains.annotations.NotNull java.lang.String absoluteFilePath) {
            return software.amazon.jsii.Kernel.call(this, "ignores", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { java.util.Objects.requireNonNull(absoluteFilePath, "absoluteFilePath is required") });
        }
    }
}
