package software.amazon.awscdk.core;

/**
 * Represents a CloudFormation element that can be used within a Condition.
 * <p>
 * You can use intrinsic functions, such as <code>Fn.conditionIf</code>,
 * <code>Fn.conditionEquals</code>, and <code>Fn.conditionNot</code>, to conditionally create
 * stack resources. These conditions are evaluated based on input parameters
 * that you declare when you create or update a stack. After you define all your
 * conditions, you can associate them with resources or resource properties in
 * the Resources and Outputs sections of a template.
 * <p>
 * You define all conditions in the Conditions section of a template except for
 * <code>Fn.conditionIf</code> conditions. You can use the <code>Fn.conditionIf</code> condition
 * in the metadata attribute, update policy attribute, and property values in
 * the Resources section and Outputs sections of a template.
 * <p>
 * You might use conditions when you want to reuse a template that can create
 * resources in different contexts, such as a test environment versus a
 * production environment. In your template, you can add an EnvironmentType
 * input parameter, which accepts either prod or test as inputs. For the
 * production environment, you might include Amazon EC2 instances with certain
 * capabilities; however, for the test environment, you want to use less
 * capabilities to save costs. With conditions, you can define which resources
 * are created and how they're configured for each environment type.
 * <p>
 * You can use <code>toString</code> when you wish to embed a condition expression
 * in a property value that accepts a <code>string</code>. For example:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Queue.Builder.create(this, "MyQueue")
 *         .queueName(Fn.conditionIf('Condition', 'Hello', 'World').toString())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.14.1 (build 828de8a)", date = "2020-12-01T18:32:35.250Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "@aws-cdk/core.ICfnConditionExpression")
@software.amazon.jsii.Jsii.Proxy(ICfnConditionExpression.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ICfnConditionExpression extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.core.IResolvable {

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.core.ICfnConditionExpression.Jsii$Default {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * The creation stack of this resolvable which will be appended to errors thrown during resolution.
         * <p>
         * This may return an array with a single informational element indicating how
         * to get this property populated, if it was skipped for performance reasons.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getCreationStack() {
            return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "creationStack", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
        }

        /**
         * Produce the Token's value at resolution time.
         * <p>
         * @param context This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull java.lang.Object resolve(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolveContext context) {
            return software.amazon.jsii.Kernel.call(this, "resolve", software.amazon.jsii.NativeType.forClass(java.lang.Object.class), new Object[] { java.util.Objects.requireNonNull(context, "context is required") });
        }

        /**
         * Return a string representation of this resolvable object.
         * <p>
         * Returns a reversible string representation.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull java.lang.String toString() {
            return software.amazon.jsii.Kernel.call(this, "toString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }
    }

    /**
     * Internal default implementation for {@link ICfnConditionExpression}.
     */
    @software.amazon.jsii.Internal
    interface Jsii$Default extends ICfnConditionExpression, software.amazon.awscdk.core.IResolvable.Jsii$Default {

        /**
         * The creation stack of this resolvable which will be appended to errors thrown during resolution.
         * <p>
         * This may return an array with a single informational element indicating how
         * to get this property populated, if it was skipped for performance reasons.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getCreationStack() {
            return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "creationStack", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
        }

        /**
         * Produce the Token's value at resolution time.
         * <p>
         * @param context This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull java.lang.Object resolve(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolveContext context) {
            return software.amazon.jsii.Kernel.call(this, "resolve", software.amazon.jsii.NativeType.forClass(java.lang.Object.class), new Object[] { java.util.Objects.requireNonNull(context, "context is required") });
        }
    }
}
